/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.plugin.exchange;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.hq.plugin.exchange.ExchangeUtils;
import org.hyperic.hq.product.AutoServerDetector;
import org.hyperic.hq.product.GenericPlugin;
import org.hyperic.hq.product.PluginException;
import org.hyperic.hq.product.ServerDetector;
import org.hyperic.hq.product.ServerResource;
import org.hyperic.hq.product.ServiceResource;
import org.hyperic.sigar.win32.Service;
import org.hyperic.sigar.win32.Win32Exception;
import org.hyperic.util.config.ConfigResponse;

public class ExchangeClientAccessDetector
extends ServerDetector
implements AutoServerDetector {
    private static final Log log = LogFactory.getLog((String)ExchangeClientAccessDetector.class.getName());
    private static final String IMAP4_NAME = "IMAP4";
    private static final String POP3_NAME = "POP3";
    private static final String ADDRESS_BOOK_NAME = "AddressBook";
    private static final String[] SERVICES = new String[]{"IMAP4", "POP3", "AddressBook"};
    private static final Map<String, String> servicesMap = new HashMap<String, String>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getServerResources(ConfigResponse platformConfig) throws PluginException {
        String exe;
        ArrayList<ServerResource> servers = new ArrayList<ServerResource>();
        Service exch = null;
        String serviceName = "";
        try {
            serviceName = this.getTypeProperty("SERVER_NAME");
            exch = new Service(serviceName);
            if (log.isDebugEnabled()) {
                log.debug((Object)("clientAccessDetetctor: getServerResources: looking for service:" + serviceName));
            }
            if (exch.getStatus() != 4) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("[getServerResources] service '" + serviceName + "' is not RUNNING (status='" + exch.getStatusString() + "')"));
                }
                List list = null;
                return list;
            }
            exe = exch.getConfig().getExe().trim();
        }
        catch (Win32Exception e) {
            log.debug((Object)("[getServerResources] Error getting '" + serviceName + "' service information " + (Object)((Object)e)), (Throwable)e);
            List list = null;
            return list;
        }
        finally {
            if (exch != null) {
                exch.close();
            }
        }
        File bin = new File(exe).getParentFile();
        if (!this.isInstallTypeVersion(bin.getPath())) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("[getServerResources] exchange on '" + bin + "' IS NOT a " + this.getTypeInfo().getName()));
            }
            return null;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("[getServerResources] exchange on '" + bin + "' IS a " + this.getTypeInfo().getName()));
        }
        ConfigResponse cprops = new ConfigResponse();
        ConfigResponse productProps = new ConfigResponse();
        String roleRegKeyStr = this.getTypeProperty("EXCHANGE_ROLE_REG_KEY");
        if (roleRegKeyStr != null) {
            String adSiteName;
            if (!ExchangeUtils.checkRoleConfiguredAndSetVersion(roleRegKeyStr, cprops)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("role configured  - but not found in registry - ignoring server:" + roleRegKeyStr));
                }
                return null;
            }
            String discoverSite = this.getTypeProperty("SITE_DISCOVERY");
            if (discoverSite != null && (adSiteName = ExchangeUtils.fetchActiveDirectorySiteName()) != null) {
                productProps.setValue("active_directory.site", adSiteName);
            }
        }
        ServerResource server = this.createServerResource(exe);
        this.setCustomProperties(server, cprops);
        server.setIdentifier(serviceName);
        this.setProductConfig(server, productProps);
        server.setMeasurementConfig();
        servers.add(server);
        return servers;
    }

    private boolean isExchangeServiceRunning(String serviceName) {
        return this.isWin32ServiceRunning(serviceName);
    }

    private ServiceResource createService(String name, String win32Name) {
        ConfigResponse cfg = new ConfigResponse();
        cfg.setValue("service_name", win32Name);
        ServiceResource service = new ServiceResource();
        service.setType((GenericPlugin)this, name);
        service.setServiceName(name);
        this.setProductConfig(service, new ConfigResponse());
        this.setMeasurementConfig(service, new ConfigResponse());
        this.setControlConfig(service, cfg);
        log.debug((Object)("=" + win32Name + "=> " + service.getProductConfig()));
        return service;
    }

    protected List discoverServices(ConfigResponse config) throws PluginException {
        ArrayList<ServiceResource> actualServices = new ArrayList<ServiceResource>();
        for (Map.Entry<String, String> entry : servicesMap.entrySet()) {
            if (!this.isExchangeServiceRunning(entry.getValue())) {
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)(entry.getValue() + " is not running"));
                continue;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)(entry.getValue() + " is running, adding to inventory"));
            }
            actualServices.add(this.createService(entry.getKey(), entry.getValue()));
        }
        return actualServices;
    }

    static {
        servicesMap.put(IMAP4_NAME, "MSExchangeIMAP4");
        servicesMap.put(POP3_NAME, "MSExchangePOP3");
        servicesMap.put(ADDRESS_BOOK_NAME, "MSExchangeAB");
    }
}

