/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.plugin.exchange;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.hq.plugin.exchange.ExchangeUtils;
import org.hyperic.hq.product.AutoServerDetector;
import org.hyperic.hq.product.GenericPlugin;
import org.hyperic.hq.product.PluginException;
import org.hyperic.hq.product.ServerDetector;
import org.hyperic.hq.product.ServerResource;
import org.hyperic.hq.product.ServiceResource;
import org.hyperic.sigar.win32.Pdh;
import org.hyperic.sigar.win32.Service;
import org.hyperic.sigar.win32.Win32Exception;
import org.hyperic.util.config.ConfigResponse;

public class ExchangeTransportDetector
extends ServerDetector
implements AutoServerDetector {
    private static final Log log = LogFactory.getLog((String)ExchangeTransportDetector.class.getName());
    private static final String TRANSPORT = "MSExchangeTransport";
    private static final String SMTP_SEND = "SmtpSend";
    private static final String SMTP_RECEIVE = "SmtpReceive";
    private static final String[] SERVICES = new String[]{"SmtpSend", "SmtpReceive"};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getServerResources(ConfigResponse platformConfig) throws PluginException {
        String exe;
        ArrayList<ServerResource> servers = new ArrayList<ServerResource>();
        Service exch = null;
        try {
            exch = new Service(TRANSPORT);
            if (exch.getStatus() != 4) {
                log.debug((Object)("[getServerResources] service 'MSExchangeTransport' is not RUNNING (status='" + exch.getStatusString() + "')"));
                List list = null;
                return list;
            }
            exe = exch.getConfig().getExe().trim();
        }
        catch (Win32Exception e) {
            log.debug((Object)("[getServerResources] Error getting 'MSExchangeTransport' service information " + (Object)((Object)e)), (Throwable)e);
            List list = null;
            return list;
        }
        finally {
            if (exch != null) {
                exch.close();
            }
        }
        File bin = new File(exe).getParentFile();
        if (!this.isInstallTypeVersion(bin.getPath())) {
            log.debug((Object)("[getServerResources] exchange on '" + bin + "' IS NOT a " + this.getTypeInfo().getName()));
            return null;
        }
        log.debug((Object)("[getServerResources] exchange on '" + bin + "' IS a " + this.getTypeInfo().getName()));
        ConfigResponse cprops = new ConfigResponse();
        ConfigResponse productProps = new ConfigResponse();
        String roleRegKeyStr = this.getTypeProperty("EXCHANGE_ROLE_REG_KEY");
        if (roleRegKeyStr != null) {
            String adSiteName;
            if (!ExchangeUtils.checkRoleConfiguredAndSetVersion(roleRegKeyStr, cprops)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("role configured  - but not found in registry - ignoring server:" + roleRegKeyStr));
                }
                return null;
            }
            String discoverSite = this.getTypeProperty("SITE_DISCOVERY");
            if (discoverSite != null && (adSiteName = ExchangeUtils.fetchActiveDirectorySiteName()) != null) {
                productProps.setValue("active_directory.site", adSiteName);
            }
        }
        ServerResource server = this.createServerResource(exe);
        server.setCustomProperties(cprops);
        server.setIdentifier(TRANSPORT);
        this.setProductConfig(server, productProps);
        server.setMeasurementConfig();
        servers.add(server);
        return servers;
    }

    private List discoverPerfServices(String type) {
        ArrayList<ServiceResource> services = new ArrayList<ServiceResource>();
        try {
            String[] instances = Pdh.getInstances((String)("MSExchangeTransport " + type));
            for (int i = 0; i < instances.length; ++i) {
                String name = instances[i];
                if (name.equalsIgnoreCase("_Total")) continue;
                ServiceResource service = new ServiceResource();
                service.setType((GenericPlugin)this, type);
                service.setName(type + " " + name);
                ConfigResponse config = new ConfigResponse();
                config.setValue("name", name);
                service.setProductConfig(config);
                service.setMeasurementConfig();
                services.add(service);
            }
        }
        catch (Win32Exception e) {
            log.debug((Object)e, (Throwable)e);
        }
        return services;
    }

    protected List discoverServices(ConfigResponse config) throws PluginException {
        ArrayList services = new ArrayList();
        for (int i = 0; i < SERVICES.length; ++i) {
            services.addAll(this.discoverPerfServices(SERVICES[i]));
        }
        return services;
    }
}

