/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.plugin.mssql;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.hq.product.MetricValue;
import org.hyperic.hq.product.PluginException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PDH {
    private static final Log log = LogFactory.getLog(PDH.class);

    private static native long pdhOpenQuery() throws PluginException;

    private static native long pdhAddCounter(long var0, String var2) throws PluginException;

    private static native void pdhRemoveCounter(long var0) throws PluginException;

    private static native void PdhCollectQueryData(long var0) throws PluginException;

    private static native double PdhGetFormattedCounterValue(long var0) throws PluginException;

    private static native String[] pdhGetInstances(String var0) throws PluginException;

    public static String[] getInstances(String path) throws PluginException {
        String[] instances = PDH.pdhGetInstances(path);
        HashMap<String, InstanceIndex> names = new HashMap<String, InstanceIndex>(instances.length);
        for (int i = 0; i < instances.length; ++i) {
            InstanceIndex ix = (InstanceIndex)names.get(instances[i]);
            if (ix == null) {
                ix = new InstanceIndex();
                names.put(instances[i], ix);
                continue;
            }
            ++ix.index;
            instances[i] = instances[i] + "#" + ix.index;
        }
        return instances;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, Double> getFormattedValues(List<String> paths) throws PluginException, InterruptedException {
        HashMap<String, Double> res = new HashMap<String, Double>();
        long q = PDH.pdhOpenQuery();
        HashMap<String, Long> counters = new HashMap<String, Long>();
        for (String path : paths) {
            try {
                counters.put(path, PDH.pdhAddCounter(q, path));
                log.debug((Object)("[getFormattedValues] path:'" + path + "' OK"));
            }
            catch (PluginException ex) {
                log.debug((Object)("[getFormattedValues] Error adding metric => path:'" + path + "' ex:" + (Object)((Object)ex)));
                res.put(path, Double.NaN);
            }
        }
        log.debug((Object)("[getFormattedValues] counters:'" + counters + "'"));
        if (counters.size() > 0) {
            try {
                PDH.PdhCollectQueryData(q);
                Thread.sleep(1000L);
                PDH.PdhCollectQueryData(q);
                for (String path : paths) {
                    try {
                        Long c = (Long)counters.get(path);
                        if (c == null) continue;
                        Double val = PDH.PdhGetFormattedCounterValue(c);
                        log.debug((Object)("[getFormattedValues] path:'" + path + "' val:" + val));
                        res.put(path, val);
                    }
                    catch (PluginException ex) {
                        log.debug((Object)("[getFormattedValues] Error getting metric value => path:'" + path + "' ex:" + (Object)((Object)ex)));
                    }
                }
            }
            finally {
                for (Long counter : counters.values()) {
                    try {
                        PDH.pdhRemoveCounter(counter);
                    }
                    catch (PluginException ex) {
                        log.debug((Object)("[getFormattedValues] Error removing counter => ex:" + (Object)((Object)ex)));
                    }
                }
            }
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static double getValue(String path) throws PluginException {
        double res = MetricValue.NONE.getValue();
        long q = PDH.pdhOpenQuery();
        long counter = PDH.pdhAddCounter(q, path);
        try {
            PDH.PdhCollectQueryData(q);
            res = PDH.PdhGetFormattedCounterValue(counter);
        }
        finally {
            PDH.pdhRemoveCounter(counter);
        }
        return res;
    }

    static {
        String os = System.getProperty("os.arch");
        log.debug((Object)("[static] os: " + os));
        String libName = "exchange_pdh.dll";
        String libPathInJar = "/priv_lib/";
        libPathInJar = libPathInJar + (os.contains("64") ? "x64/" : "win32/");
        libPathInJar = libPathInJar + libName;
        try {
            int length;
            URL in = PDH.class.getClassLoader().getResource(libPathInJar);
            if (in == null) {
                throw new FileNotFoundException(libPathInJar);
            }
            File out = new File(System.getProperty("java.io.tmpdir"), libName);
            log.info((Object)("[static] Reading dll fom: " + in));
            log.info((Object)("[static] Writing dll to: " + out.getAbsolutePath()));
            InputStream inStream = in.openStream();
            FileOutputStream outStream = new FileOutputStream(out);
            byte[] buffer = new byte[1024];
            while ((length = inStream.read(buffer)) > 0) {
                ((OutputStream)outStream).write(buffer, 0, length);
            }
            inStream.close();
            ((OutputStream)outStream).close();
            System.load(out.getAbsolutePath());
        }
        catch (Exception e) {
            log.error((Object)e, (Throwable)e);
        }
    }

    private static final class InstanceIndex {
        long index = 0L;

        private InstanceIndex() {
        }
    }
}

