/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.cm.filemonitor.standalone;

import java.util.Arrays;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import org.hyperic.cm.filemonitor.IChangeListener;
import org.hyperic.cm.filemonitor.data.EventActionsEnum;
import org.hyperic.cm.filemonitor.data.EventMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChangeListenerObj
implements IChangeListener {
    private BlockingQueue<String> queue;
    private boolean unlimited;
    private int counter = 0;
    private List<EventActionsEnum> eventOrder = Arrays.asList(EventActionsEnum.CREATE, EventActionsEnum.MODIFY, EventActionsEnum.RENAME, EventActionsEnum.DELETE);
    private boolean match = true;

    public ChangeListenerObj(BlockingQueue<String> queue, boolean unlimited) {
        this.queue = queue;
        this.unlimited = unlimited;
    }

    public boolean isComplete() {
        return this.counter == 4;
    }

    public int getCounter() {
        return this.counter;
    }

    @Override
    public void onChange(EventMessage item) {
        String msg = "--- Recieved event: " + (Object)((Object)item.getType());
        if (!this.unlimited) {
            msg = String.valueOf(msg) + ". Expected: " + (this.eventOrder.size() > this.counter ? (Comparable)((Object)this.eventOrder.get(this.counter)) : "-1");
            System.out.println(msg);
        }
        this.match = this.match && this.eventOrder.get(this.counter).equals((Object)item.getType());
        ++this.counter;
        try {
            this.queue.put(item.getType().protocolValue());
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public boolean isMatch() {
        return this.match;
    }
}

