/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.product;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Arrays;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.hq.product.LogFileTrackPlugin;
import org.hyperic.hq.product.PluginException;
import org.hyperic.hq.product.TrackEvent;
import org.hyperic.sigar.FileInfo;
import org.hyperic.sigar.FileTail;
import org.hyperic.sigar.FileWatcher;
import org.hyperic.sigar.Sigar;
import org.hyperic.sigar.SigarException;
import org.hyperic.util.config.ConfigResponse;

public class LogFileTailPlugin
extends LogFileTrackPlugin {
    private static Sigar sigar = null;
    private static Log log = LogFactory.getLog((String)LogFileTailPlugin.class.getName());
    private FileTail watcher = null;

    static void cleanup() {
        if (sigar != null) {
            sigar.close();
        }
    }

    public TrackEvent processLine(FileInfo info, String line) {
        return this.newTrackEvent(System.currentTimeMillis(), 3, info.getName(), line);
    }

    private FileTail getFileWatcher() {
        if (this.watcher == null) {
            log.debug((Object)"init file tail");
            if (sigar == null) {
                sigar = new Sigar();
            }
            this.watcher = new FileTail(sigar){

                public void tail(FileInfo info, Reader reader) {
                    BufferedReader buffer = new BufferedReader(reader);
                    try {
                        String line;
                        while ((line = buffer.readLine()) != null) {
                            TrackEvent event = LogFileTailPlugin.this.processLine(info, line);
                            if (event == null) continue;
                            LogFileTailPlugin.this.getManager().reportEvent(event);
                        }
                    }
                    catch (IOException e) {
                        log.error((Object)(info.getName() + ": " + e.getMessage()));
                    }
                }
            };
            this.getManager().addFileWatcher((FileWatcher)this.watcher);
        }
        return this.watcher;
    }

    public void configure(ConfigResponse config) throws PluginException {
        super.configure(config);
        String[] files = this.getFiles(config);
        if (debugLogging) {
            this.debugLog("Adding file watchers for files=" + Arrays.asList(files));
        }
        try {
            this.getFileWatcher().add(files);
        }
        catch (SigarException e) {
            throw new PluginException(e.getMessage(), e);
        }
    }

    public void shutdown() throws PluginException {
        if (this.watcher != null) {
            this.debugLog("Removing file watcher");
            this.getManager().removeFileWatcher((FileWatcher)this.watcher);
            this.watcher = null;
        }
        super.shutdown();
    }
}

