/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.product.pluginxml;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.hq.product.IMonitorConfig;
import org.hyperic.hq.product.MeasurementInfo;
import org.hyperic.hq.product.PlatformTypeInfo;
import org.hyperic.hq.product.PluginException;
import org.hyperic.hq.product.ProductPlugin;
import org.hyperic.hq.product.ProductPluginManager;
import org.hyperic.hq.product.ServerTypeInfo;
import org.hyperic.hq.product.ServiceTypeInfo;
import org.hyperic.hq.product.TypeBuilder;
import org.hyperic.hq.product.TypeInfo;
import org.hyperic.hq.product.pluginxml.PluginParser;
import org.hyperic.util.ArrayUtil;
import org.hyperic.util.config.ConfigOption;
import org.hyperic.util.config.ConfigSchema;
import org.hyperic.util.config.EnumerationConfigOption;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PluginData {
    public static final String PLUGIN_XML = "etc/hq-plugin.xml";
    public static final String PLUGIN_PROPERTIES = "etc/plugin.properties";
    public static final String PLUGINS_PREFIX = "pdk/plugins/";
    private static final Log log = LogFactory.getLog((String)"PluginData");
    private static final TypeInfo[] NO_TYPES = new TypeInfo[0];
    private static final String PLUGIN_VERSION_PROP = "PLUGIN_VERSION";
    private static HashMap cache = new HashMap();
    Map scratch;
    PluginParser parser;
    private TypeInfo[] types = NO_TYPES;
    private Map metricStash = new HashMap();
    private Map pluginImpls = new HashMap();
    String name = null;
    String version = null;
    String file = null;
    ClassLoader loader;
    Map fileScanIncludes = new HashMap();
    Map rgyScanIncludes = new HashMap();
    Map rgyScanKeys = new HashMap();
    Map help = new HashMap();
    Map config = new HashMap();
    Map cprops = new HashMap();
    static Map sharedConfig = new HashMap();
    Map actions = new HashMap();
    private List classpath = null;
    private Properties properties = new Properties();
    private static Properties globalProperties = new Properties();
    private static Map serviceExtensions = null;
    private static Map serviceInventoryPlugins = new HashMap();
    List includes = new ArrayList();
    private List<IMonitorConfig> monitoredConfigs = new LinkedList<IMonitorConfig>();

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getPluginName() {
        if (this.name != null) {
            return this.name;
        }
        if (this.file != null) {
            return ProductPluginManager.getNameFromFile(this.file);
        }
        return null;
    }

    public String getFile() {
        return this.file;
    }

    public void setFile(String file) {
        this.file = file;
    }

    public ClassLoader getClassLoader() {
        return this.loader;
    }

    public List getIncludes() {
        return this.includes;
    }

    public static void deployed(ClassLoader loader) {
        PluginData data = (PluginData)cache.get(loader);
        if (data != null) {
            data.deployed();
        }
    }

    public static synchronized PluginData getInstance(ProductPluginManager manager, ClassLoader loader, String file) throws PluginException {
        PluginData data = (PluginData)cache.get(loader);
        if (data != null) {
            return data;
        }
        PluginParser parser = new PluginParser();
        boolean isServer = manager.getRegisterTypes();
        if (!isServer) {
            parser.collectHelp(false);
            parser.collectMetrics(false);
        }
        boolean isJar = file.endsWith(".jar");
        InputStream is = null;
        data = new PluginData();
        data.file = file;
        if (isJar) {
            try {
                is = PluginData.openPluginResource(loader, PLUGIN_PROPERTIES);
                if (is != null) {
                    Properties props = new Properties();
                    props.load(is);
                    data.properties.putAll((Map<?, ?>)props);
                }
            }
            catch (FileNotFoundException e) {
            }
            catch (IOException e) {
                throw new PluginException(e.getMessage(), e);
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException e) {}
                    is = null;
                }
            }
        }
        PluginResolver resolver = null;
        try {
            if (isJar) {
                String name;
                is = PluginData.openPluginResource(loader, PLUGIN_XML);
                if (is == null && (is = PluginData.openPluginResource(loader, name = "etc/" + data.getPluginName() + "-plugin.xml")) == null) {
                    log.debug((Object)(file + "!" + PLUGIN_XML + " does not exist"));
                }
                resolver = new PluginResolver(data, loader);
            } else {
                is = new FileInputStream(file);
                resolver = new PluginResolver(data);
            }
            if (is != null) {
                parser.parse(is, data, resolver);
            }
        }
        catch (IOException e) {
            throw new PluginException(e.getMessage(), e);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {}
            }
            is = null;
        }
        data.loader = loader;
        cache.put(loader, data);
        return data;
    }

    public static InputStream openPluginResource(ClassLoader loader, String file) throws IOException {
        InputStream is = null;
        if (log.isTraceEnabled()) {
            URL url = loader.getResource(file);
            log.trace((Object)(file + " => " + url));
        }
        is = loader.getResourceAsStream(file);
        return is;
    }

    List getMetrics(String name, boolean create) {
        ArrayList metrics = (ArrayList)this.metricStash.get(name);
        if (metrics == null && create) {
            metrics = new ArrayList();
            this.metricStash.put(name, metrics);
        }
        return metrics;
    }

    public List getMetrics(String name) {
        return this.getMetrics(name, false);
    }

    public void addMetric(String name, MeasurementInfo metric) {
        this.getMetrics(name, true).add(metric);
    }

    public void removeMetrics(String name) {
        this.metricStash.remove(name);
    }

    public static ServiceExtension getServiceExtension(String name) {
        if (serviceExtensions == null) {
            return null;
        }
        return (ServiceExtension)serviceExtensions.get(name);
    }

    String qualifiedPluginClass(String implClass) {
        String pluginPackage;
        if (implClass != null && implClass.indexOf(".") == -1 && (pluginPackage = this.getProperty("package")) != null) {
            return pluginPackage + "." + implClass;
        }
        return implClass;
    }

    public void addPlugin(String type, String typeName, String implClass) {
        HashMap<String, String> plugins = (HashMap<String, String>)this.pluginImpls.get(type);
        if (plugins == null) {
            plugins = new HashMap<String, String>();
            this.pluginImpls.put(type, plugins);
        }
        plugins.put(typeName, this.qualifiedPluginClass(implClass));
    }

    public void removePlugins(String typeName) {
        for (Map pluginTypes : this.pluginImpls.values()) {
            pluginTypes.remove(typeName);
        }
    }

    private String getPlatformName(TypeInfo info) {
        String name = info.getName();
        String[] platforms = info.getPlatformTypes();
        if (platforms.length == 1) {
            name = name + " " + platforms[0];
        }
        return name;
    }

    public String getPlugin(String type, TypeInfo info) {
        String plugin = this.getPlugin(type, this.getPlatformName(info));
        if (plugin != null) {
            return plugin;
        }
        return this.getPlugin(type, info.getName());
    }

    public String getPlugin(String type, String typeName) {
        Map plugins = (Map)this.pluginImpls.get(type);
        if (plugins == null) {
            return null;
        }
        return (String)plugins.get(typeName);
    }

    public void addControlActions(String typeName, List actions) {
        ArrayList controlActions = this.getControlActions(typeName);
        if (controlActions == null) {
            controlActions = new ArrayList();
            this.actions.put(typeName, controlActions);
        }
        controlActions.addAll(actions);
    }

    public void removeControlActions(String typeName) {
        this.actions.remove(typeName);
    }

    public List getControlActions(TypeInfo info) {
        List actions = this.getControlActions(this.getPlatformName(info));
        if (actions != null) {
            return actions;
        }
        return this.getControlActions(info.getName());
    }

    public List getControlActions(String typeName) {
        return (List)this.actions.get(typeName);
    }

    public TypeInfo[] getTypes() {
        return this.types;
    }

    public void addTypes(TypeInfo[] types) {
        this.types = this.types == NO_TYPES ? types : (TypeInfo[])ArrayUtil.merge((Object[])this.types, (Object[])types, (Object[])new TypeInfo[0]);
    }

    public void removeTypes(TypeInfo[] types) {
        ArrayList<TypeInfo> existingTypes = new ArrayList<TypeInfo>(Arrays.asList(this.types));
        for (int i = 0; i < types.length; ++i) {
            if (!existingTypes.contains(types[i])) continue;
            existingTypes.remove(types[i]);
        }
        this.types = existingTypes.toArray(new TypeInfo[existingTypes.size()]);
    }

    void addServiceExtension(ServiceTypeInfo service) {
        this.addTypes(new TypeInfo[]{service});
        if (serviceExtensions == null) {
            serviceExtensions = new HashMap();
        }
        ServiceExtension ext = new ServiceExtension(service, this);
        serviceExtensions.put(service.getName(), ext);
    }

    public Map getServiceInventoryPlugins(String serverType) {
        return (Map)serviceInventoryPlugins.get(serverType);
    }

    public void addServiceInventoryPlugin(String serverType, String serviceType, String name) {
        HashMap<String, String> services = this.getServiceInventoryPlugins(serverType);
        if (services == null) {
            services = new HashMap<String, String>();
            serviceInventoryPlugins.put(serverType, services);
        }
        services.put(serviceType, this.qualifiedPluginClass(name));
    }

    public List getClassPath() {
        return this.classpath;
    }

    void setClassPath(List classpath) {
        this.classpath = new ArrayList();
        this.classpath.addAll(classpath);
    }

    public String getHelp(String name) {
        return (String)this.help.get(name);
    }

    public List getFileScanIncludes(String name) {
        return (List)this.fileScanIncludes.get(name);
    }

    void addFileScanIncludes(String name, List sigs) {
        ArrayList serverSigs = this.getFileScanIncludes(name);
        if (serverSigs == null) {
            serverSigs = new ArrayList();
        }
        serverSigs.addAll(sigs);
        this.fileScanIncludes.put(name, serverSigs);
    }

    public List getRegistryScanIncludes(String name) {
        return (List)this.rgyScanIncludes.get(name);
    }

    void addRegistryScanIncludes(String name, List sigs) {
        ArrayList serverSigs = this.getRegistryScanIncludes(name);
        if (serverSigs == null) {
            serverSigs = new ArrayList();
        }
        serverSigs.addAll(sigs);
        this.rgyScanIncludes.put(name, serverSigs);
    }

    public List getRegistryScanKeys(String name) {
        return (List)this.rgyScanKeys.get(name);
    }

    void addRegistryScanKey(String name, String key) {
        ArrayList<String> keys = this.getRegistryScanKeys(name);
        if (keys == null) {
            keys = new ArrayList<String>();
        }
        keys.add(key);
        this.rgyScanKeys.put(name, keys);
    }

    public ConfigSchema getConfigSchema(TypeInfo info, int type) {
        ConfigSchema schema = this.getConfigSchema(this.getPlatformName(info), type);
        if (schema != null) {
            return schema;
        }
        return this.getConfigSchema(info.getName(), type);
    }

    public ConfigSchema getConfigSchema(String name, int type) {
        ConfigSchema[] schemas = (ConfigSchema[])this.config.get(name);
        if (schemas == null) {
            return null;
        }
        return schemas[type];
    }

    void addConfigSchema(String name, int type, ConfigSchema schema) {
        ConfigSchema[] schemas = (ConfigSchema[])this.config.get(name);
        if (schemas == null) {
            schemas = new ConfigSchema[4];
            this.config.put(name, schemas);
        }
        schemas[type] = schema;
    }

    static ConfigSchema getSharedConfigSchema(String name) {
        return (ConfigSchema)sharedConfig.get(name);
    }

    public ConfigSchema getCustomPropertiesSchema(TypeInfo info) {
        return this.getCustomPropertiesSchema(info.getName());
    }

    public ConfigSchema getCustomPropertiesSchema(String name) {
        ServiceExtension ext;
        ConfigSchema schema = (ConfigSchema)this.cprops.get(name);
        if (schema == null && (ext = PluginData.getServiceExtension(name)) != null) {
            return (ConfigSchema)ext.data.cprops.get(name);
        }
        return schema;
    }

    public void addCustomPropertiesSchema(String name, ConfigSchema schema) {
        ConfigSchema cpropSchema = this.getCustomPropertiesSchema(name);
        if (cpropSchema == null) {
            cpropSchema = schema;
        } else {
            cpropSchema.addOptions(schema.getOptions());
        }
        this.cprops.put(name, cpropSchema);
    }

    public void removeCustomPropertiesSchema(String name) {
        ConfigSchema schema = (ConfigSchema)this.cprops.get(name);
        if (schema == null) {
            ServiceExtension ext = PluginData.getServiceExtension(name);
            if (ext != null) {
                ext.data.cprops.remove(name);
            }
        } else {
            this.cprops.remove(name);
        }
    }

    public static void addSharedConfigSchema(String name, ConfigSchema schema) {
        sharedConfig.put(name, schema);
    }

    public String applyFilters(String s) {
        return this.parser.applyFilters(s);
    }

    void addFilter(String key, String value) {
        this.parser.addFilter(key, value);
    }

    void addFilters(Map props) {
        this.parser.addFilters(props);
    }

    public String getFilter(String key) {
        return this.parser.getFilter(key);
    }

    public void setProperty(String key, String value) {
        if (key.equals(PLUGIN_VERSION_PROP) && value != null) {
            this.setVersion(value);
        } else {
            this.properties.setProperty(key, value);
        }
    }

    public String getProperty(String key) {
        String val = this.properties.getProperty(key);
        if (val == null) {
            return PluginData.getGlobalProperty(key);
        }
        return val;
    }

    public Properties getProperties() {
        return this.properties;
    }

    void setGlobalProperty(String key, String value) {
        this.addFilter(key, value);
        globalProperties.setProperty(key, value);
    }

    public static String getGlobalProperty(String key) {
        return globalProperties.getProperty(key);
    }

    public static Map getGlobalProperties() {
        return globalProperties;
    }

    void includeGlobalProperties(String fromType, String toType) {
        Properties props = new Properties();
        for (Map.Entry<Object, Object> entry : globalProperties.entrySet()) {
            String key = (String)entry.getKey();
            if (!key.startsWith(fromType + ".")) continue;
            String val = (String)entry.getValue();
            key = toType + key.substring(fromType.length());
            props.setProperty(key, val);
        }
        globalProperties.putAll((Map<?, ?>)props);
    }

    public List<IMonitorConfig> getMonitoredConfigs() {
        return this.monitoredConfigs;
    }

    public void setMonitoredConfigs(List<IMonitorConfig> monitoredConfigs) {
        this.monitoredConfigs = monitoredConfigs;
    }

    public void addMonitoredConfig(IMonitorConfig monitoredConfig) {
        this.monitoredConfigs.add(monitoredConfig);
    }

    public void deployed() {
        this.metricStash.clear();
        this.metricStash = new HashMap();
    }

    Map getTypeMap() {
        int i;
        HashMap map = new HashMap();
        for (i = 0; i < this.types.length; ++i) {
            int type = this.types[i].getType();
            if (type != 2 && type != 1) continue;
            map.put(this.types[i], new ArrayList());
        }
        for (i = 0; i < this.types.length; ++i) {
            if (this.types[i].getType() != 3) continue;
            ServiceTypeInfo type = (ServiceTypeInfo)this.types[i];
            List services = (List)map.get(type.getServerTypeInfo());
            services.add(type);
        }
        return map;
    }

    void dumpConfigXML(PrintStream out, TypeInfo type, String indent) {
        for (int i = 0; i < ProductPlugin.CONFIGURABLE_TYPES.length; ++i) {
            this.dumpConfigXML(out, type, i, indent);
        }
    }

    void dumpConfigXML(PrintStream out, TypeInfo type, int typeIndex, String indent) {
        ConfigSchema schema = this.getConfigSchema(type, typeIndex);
        if (schema == null) {
            return;
        }
        String typeName = ProductPlugin.CONFIGURABLE_TYPES[typeIndex];
        out.println(indent + "<config type=" + typeName + ">");
        List options = schema.getOptions();
        for (int i = 0; i < options.size(); ++i) {
            ConfigOption option = (ConfigOption)options.get(i);
            out.println(indent + "  <option name=" + option.getName());
            out.println(indent + "          description=" + option.getDescription());
            out.println(indent + "          default=" + option.getDefault() + "/>");
            if (!(option instanceof EnumerationConfigOption)) continue;
            EnumerationConfigOption eoption = (EnumerationConfigOption)option;
            List values = eoption.getValues();
            for (int j = 0; j < values.size(); ++j) {
                out.println(indent + "    <include name=" + values.get(j) + "/>");
            }
        }
        out.println(indent + "</config>");
    }

    void dumpPluginXML(PrintStream out, TypeInfo type, String indent) {
        for (int i = 0; i < ProductPlugin.TYPES.length; ++i) {
            this.dumpPluginXML(out, type, ProductPlugin.TYPES[i], indent);
        }
    }

    void dumpPluginXML(PrintStream out, TypeInfo type, String pluginType, String indent) {
        String plugin = this.getPlugin(pluginType, type);
        if (plugin == null) {
            return;
        }
        out.println("");
        out.println(indent + "<plugin type=" + pluginType);
        out.println(indent + "        class=" + plugin + "/>");
        if (!pluginType.equals("control")) {
            return;
        }
        List actions = this.getControlActions(type);
        if (actions != null) {
            out.println("\n" + indent + "<actions>");
            for (int i = 0; i < actions.size(); ++i) {
                out.println(indent + "  <include name=" + actions.get(i) + "/>");
            }
            out.println(indent + "</actions>");
        }
    }

    void dumpMetricsXML(PrintStream out, TypeInfo type, String indent) {
        List metrics = this.getMetrics(type.getName());
        if (metrics == null) {
            return;
        }
        out.println("");
        for (int i = 0; i < metrics.size(); ++i) {
            MeasurementInfo metric = (MeasurementInfo)metrics.get(i);
            out.println(metric.toXML(indent));
        }
    }

    void dumpHelpXML(PrintStream out, TypeInfo type, String indent) {
        String help = this.getHelp(type.getName());
        if (help == null) {
            return;
        }
        out.println("");
        out.println(indent + "<help>");
        out.println(help);
        out.println(indent + "</help>");
    }

    void dumpServerXML(PrintStream out, ServerTypeInfo server, List services) {
        int i;
        String[] platforms = server.getPlatformTypes();
        out.println("  <server name=" + server.getName());
        String platform = null;
        if (platforms.length == 1) {
            platform = platforms[0];
        } else if (platforms == TypeBuilder.UNIX_PLATFORM_NAMES) {
            platform = "Unix";
        }
        if (platform != null) {
            out.println("          platforms=" + platform);
        }
        out.println("          description=" + server.getDescription() + ">");
        this.dumpConfigXML(out, server, "    ");
        this.dumpPluginXML(out, server, "    ");
        this.dumpHelpXML(out, server, "    ");
        this.dumpMetricsXML(out, server, "    ");
        List fileScan = this.getFileScanIncludes(server.getName());
        if (fileScan != null) {
            out.println("    <scan type=file>");
            for (int i2 = 0; i2 < fileScan.size(); ++i2) {
                out.println("      <include name=" + fileScan.get(i2) + "/>");
            }
            out.println("    </scan>");
        }
        List rgyIncludes = this.getRegistryScanIncludes(server.getName());
        List rgyKeys = this.getRegistryScanKeys(server.getName());
        if (rgyKeys != null) {
            for (i = 0; i < rgyKeys.size(); ++i) {
                out.println("    <scan registry=" + rgyKeys.get(i) + ">");
                for (int j = 0; j < rgyIncludes.size(); ++j) {
                    out.println("      <include name=" + rgyIncludes.get(j) + "/>");
                }
                out.println("    </scan>");
            }
        }
        out.println("");
        for (i = 0; i < services.size(); ++i) {
            ServiceTypeInfo service = (ServiceTypeInfo)services.get(i);
            out.println("    <service name=" + service.getName() + ">");
            this.dumpConfigXML(out, service, "        ");
            this.dumpPluginXML(out, service, "        ");
            this.dumpHelpXML(out, service, "        ");
            this.dumpMetricsXML(out, service, "        ");
            out.println("    </service>\n");
        }
        out.println("  </server>\n");
    }

    public void dumpXML() {
        PrintStream out = System.out;
        out.println("<plugin>");
        List classpath = this.getClassPath();
        if (classpath != null) {
            out.println("  <classpath>");
            for (int i = 0; i < classpath.size(); ++i) {
                out.println("    <include name=" + classpath.get(i) + "/>");
            }
            out.println("  </classpath>");
        }
        Map typeMap = this.getTypeMap();
        for (Map.Entry entry : typeMap.entrySet()) {
            Object resource = entry.getKey();
            if (resource instanceof ServerTypeInfo) {
                ServerTypeInfo server = (ServerTypeInfo)resource;
                List services = (List)entry.getValue();
                this.dumpServerXML(out, server, services);
                continue;
            }
            PlatformTypeInfo platform = (PlatformTypeInfo)resource;
            out.println("  <platform name=" + platform.getName() + "\"/>");
        }
        out.println("</plugin>");
    }

    public class ServiceExtension {
        public ServiceTypeInfo service;
        public PluginData data;

        ServiceExtension(ServiceTypeInfo service, PluginData data) {
            this.service = service;
            this.data = data;
        }
    }

    static class PluginResolver
    implements EntityResolver {
        private PluginData data;
        private ClassLoader loader;

        PluginResolver(PluginData data) {
            this(data, null);
        }

        PluginResolver(PluginData data, ClassLoader loader) {
            this.data = data;
            this.loader = loader;
        }

        private String resolveParentFile(String name) {
            if (this.data.getFile() != null) {
                for (File dir = new File(this.data.getFile()).getParentFile(); dir != null; dir = dir.getParentFile()) {
                    File resolved = new File(dir, name);
                    if (!resolved.exists()) continue;
                    return resolved.toString();
                }
            }
            return name;
        }

        private boolean isPluginFile(String name) {
            return name.startsWith(PluginData.PLUGINS_PREFIX);
        }

        private String resolvePluginFile(String name) {
            String dir;
            String pdkDir = ProductPluginManager.getPdkDir();
            if (pdkDir != null) {
                dir = pdkDir + "/plugins";
            } else {
                dir = ProductPluginManager.getPdkPluginsDir();
                if (dir == null) {
                    return this.resolveParentFile(name);
                }
            }
            return dir + "/" + name.substring(PluginData.PLUGINS_PREFIX.length());
        }

        private String resolveFile(String name) {
            if (this.isPluginFile(name)) {
                return this.resolvePluginFile(name);
            }
            return this.resolveParentFile(name);
        }

        public InputSource resolveEntity(String publicId, String systemId) {
            log.debug((Object)("resolveEntity: public=" + publicId + ", systemId=" + systemId));
            try {
                String name = null;
                if (systemId.startsWith("/")) {
                    name = systemId;
                } else if (systemId.startsWith("file:/")) {
                    name = new URL(systemId).getFile();
                }
                if (name != null) {
                    if (name.startsWith("/")) {
                        name = name.substring(1);
                    }
                    InputStream is = null;
                    if (this.loader != null) {
                        is = PluginData.openPluginResource(this.loader, name);
                    }
                    if (is == null) {
                        String resolvedName = this.resolveFile(name);
                        log.debug((Object)("resolveEntity: " + name + "->" + resolvedName));
                        is = new FileInputStream(resolvedName);
                        this.data.includes.add(resolvedName);
                    }
                    return new InputSource(is);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return null;
        }
    }
}

