/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.product.pluginxml;

import org.hyperic.hq.product.LogTrackPlugin;
import org.hyperic.hq.product.pluginxml.BaseTag;
import org.hyperic.hq.product.pluginxml.MonitoredTag;
import org.hyperic.hq.product.pluginxml.ResourceTag;
import org.hyperic.hq.product.pluginxml.ServerTag;
import org.hyperic.util.xmlparser.XmlAttrException;
import org.hyperic.util.xmlparser.XmlEndAttrHandler;
import org.hyperic.util.xmlparser.XmlTagHandler;
import org.hyperic.util.xmlparser.XmlTagInfo;

class PluginTag
extends BaseTag
implements XmlEndAttrHandler {
    private static final String[] REQUIRED_ATTRS = new String[]{"type"};
    private static final String[] OPTIONAL_ATTRS = new String[]{"platform", "class"};
    private ResourceTag resource;

    PluginTag(BaseTag resource) {
        super(resource);
        this.resource = (ResourceTag)resource;
    }

    public String getName() {
        return "plugin";
    }

    public String[] getRequiredAttributes() {
        return REQUIRED_ATTRS;
    }

    public String[] getOptionalAttributes() {
        return OPTIONAL_ATTRS;
    }

    public void endAttributes() throws XmlAttrException {
        String type = this.getAttribute("type");
        String impl = this.getAttribute("class");
        String typeName = this.resource.getPlatformName(this);
        if (this.resource.isService()) {
            String serverType = this.resource.getServerTypeName();
            if (type.equals("autoinventory")) {
                this.data.addServiceInventoryPlugin(serverType, this.resource.typeName, impl);
                return;
            }
            if (impl == null) {
                impl = this.data.getPlugin(type, serverType);
            }
        }
        if (impl == null && type.equals("log_track")) {
            impl = LogTrackPlugin.class.getName();
        }
        if (impl == null) {
            throw new XmlAttrException("missing plugin class attribute");
        }
        if (this.resource.isServer()) {
            String oldPlugin;
            ServerTag server = (ServerTag)this.resource;
            if (server.isIncluded && (oldPlugin = this.data.getPlugin(type, typeName)) != null) {
                for (String service : server.includedServices.keySet()) {
                    String plugin = this.data.getPlugin(type, service);
                    if (!oldPlugin.equals(plugin)) continue;
                    this.data.addPlugin(type, service, impl);
                }
            }
        }
        this.data.addPlugin(type, typeName, impl);
    }

    public XmlTagInfo[] getSubTags() {
        return new XmlTagInfo[]{new XmlTagInfo((XmlTagHandler)new MonitoredTag(this), 3)};
    }
}

