/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.plugin.multilogtrack;

import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.hyperic.hq.plugin.multilogtrack.MultiLogTrackServerDetector;
import org.hyperic.hq.product.MeasurementPlugin;
import org.hyperic.hq.product.Metric;
import org.hyperic.hq.product.MetricUnreachableException;
import org.hyperic.hq.product.MetricValue;
import org.hyperic.util.TimeUtil;

public class MultiLogTrackMeasurementPlugin
extends MeasurementPlugin {
    public static final Map<String, Map<String, TimeValuePair>> numLinesPerPattern = new HashMap<String, Map<String, TimeValuePair>>();
    public static final Map<String, Map<String, TimeValuePair>> lastLinesPerPattern = new HashMap<String, Map<String, TimeValuePair>>();

    public MetricValue getValue(Metric metric) throws MetricUnreachableException {
        String pattern = metric.getObjectProperty("logfilepattern");
        String alias = metric.getAttributeName();
        String logfilePattern = pattern == null ? "" : pattern;
        String basedir = metric.getObjectProperty("basedir");
        String includepattern = metric.getObjectProperty("includepattern");
        boolean overrideChecks = Boolean.parseBoolean(metric.getObjectProperty("override_file_checks"));
        basedir = MultiLogTrackServerDetector.getBasedir(basedir);
        List<String> files = MultiLogTrackServerDetector.getFilesCached(logfilePattern, basedir, includepattern, false);
        if (metric.isAvail()) {
            if (!overrideChecks && (files == null || files.isEmpty())) {
                return new MetricValue(0.0);
            }
            return new MetricValue(1.0);
        }
        if (alias.equals("NumCapturedLogs")) {
            TimeValuePair num = MultiLogTrackMeasurementPlugin.getNumLinesAndClear("includepattern", basedir, logfilePattern, includepattern);
            MetricValue rtn = num == null ? new MetricValue(0L) : new MetricValue((Number)num.getVal());
            return rtn;
        }
        if (alias.equals("SecondaryNumCapturedLogs")) {
            TimeValuePair num = MultiLogTrackMeasurementPlugin.getNumLinesAndClear("includepattern_2", basedir, logfilePattern, includepattern);
            MetricValue rtn = num == null ? new MetricValue(0L) : new MetricValue((Number)num.getVal());
            return rtn;
        }
        if (alias.equals("DiffNumCapturedLogs")) {
            TimeValuePair tl = MultiLogTrackMeasurementPlugin.getNumLinesAndClear("includepattern", basedir, logfilePattern, includepattern);
            TimeValuePair tl2 = MultiLogTrackMeasurementPlugin.getNumLinesAndClear("includepattern_2", basedir, logfilePattern, includepattern);
            MetricValue diff = this.getDiff(tl, tl2);
            return diff;
        }
        if (basedir != null) {
            File f = new File(basedir);
            try {
                if (!f.canRead() && f.exists()) {
                    throw new MetricUnreachableException("basedir=" + basedir + " exists but is not readable by the agent user");
                }
                if (!overrideChecks) {
                    if (!f.isDirectory()) {
                        throw new MetricUnreachableException("basedir=" + basedir + " exists but is not a directory");
                    }
                    if (!f.exists()) {
                        throw new MetricUnreachableException("basedir=" + basedir + " does not exist");
                    }
                }
            }
            catch (Exception e) {
                throw new MetricUnreachableException("unexpected error while attempting to read the basedir: " + e, (Throwable)e);
            }
        }
        if (!overrideChecks && (files == null || files.isEmpty())) {
            throw new MetricUnreachableException("no files were matched from the logfilepattern");
        }
        return new MetricValue((long)files.size());
    }

    private MetricValue getDiff(TimeValuePair tl1, TimeValuePair tl2) {
        Long time1 = tl1 == null ? 0L : tl1.getTime();
        Long time2 = tl2 == null ? 0L : tl2.getTime();
        int val = time1.compareTo(time2);
        return val <= 0 ? new MetricValue(0L) : new MetricValue(1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static TimeValuePair getNumLinesAndClear(String property, String basedir, String logpattern, String includePattern) {
        String key = basedir + "," + logpattern + "," + includePattern;
        TimeValuePair last = MultiLogTrackMeasurementPlugin.getLastCachedValue(property, key);
        if (last != null) {
            return last;
        }
        Map<String, TimeValuePair> numLines = null;
        Map<String, Map<String, TimeValuePair>> map = numLinesPerPattern;
        synchronized (map) {
            numLines = numLinesPerPattern.get(property);
            if (numLines == null) {
                numLines = new HashMap<String, TimeValuePair>();
                numLinesPerPattern.put(property, numLines);
            }
        }
        TimeValuePair rtn = null;
        try {
            Map<String, TimeValuePair> map2 = numLines;
            synchronized (map2) {
                TimeValuePair timeValuePair = rtn = numLines.remove(key);
                return timeValuePair;
            }
        }
        finally {
            Map<String, Map<String, TimeValuePair>> map3 = lastLinesPerPattern;
            synchronized (map3) {
                Map<String, TimeValuePair> map4 = lastLinesPerPattern.get(property);
                if (map4 == null) {
                    map4 = new HashMap<String, TimeValuePair>();
                    lastLinesPerPattern.put(property, map4);
                }
                if (rtn != null) {
                    rtn.setLastUsed(MultiLogTrackMeasurementPlugin.now());
                }
                map4.put(key, rtn);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static TimeValuePair getLastCachedValue(String property, String key) {
        Map<String, Map<String, TimeValuePair>> map = lastLinesPerPattern;
        synchronized (map) {
            TimeValuePair rtn;
            Map<String, TimeValuePair> map2 = lastLinesPerPattern.get(property);
            if (map2 == null) {
                map2 = new HashMap<String, TimeValuePair>();
                lastLinesPerPattern.put(property, map2);
            }
            if ((rtn = map2.get(key)) == null) {
                return null;
            }
            long lastCacheUsed = rtn.getLastUsed();
            lastCacheUsed = MultiLogTrackMeasurementPlugin.roundDownTime(lastCacheUsed, 60000L);
            long now = MultiLogTrackMeasurementPlugin.now();
            long nowRounded = MultiLogTrackMeasurementPlugin.roundDownTime(now, 60000L);
            if (lastCacheUsed > 0L && lastCacheUsed + 60000L <= nowRounded) {
                map2.remove(key);
                return null;
            }
            rtn.setLastUsed(now);
            return rtn;
        }
    }

    private static long roundDownTime(long approxTime, long interval) {
        return approxTime - approxTime % interval;
    }

    private static Long now() {
        return System.currentTimeMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void incrementNumLines(String property, String basedir, String logfilepattern, String includepattern, int offset) {
        String key = basedir + "," + logfilepattern + "," + includepattern;
        Map<String, TimeValuePair> numLines = null;
        Map<String, Object> map = numLinesPerPattern;
        synchronized (map) {
            numLines = numLinesPerPattern.get(property);
            if (numLines == null) {
                numLines = new HashMap<String, TimeValuePair>();
                numLinesPerPattern.put(property, numLines);
            }
        }
        map = numLines;
        synchronized (map) {
            TimeValuePair num = numLines.get(key);
            if (num == null) {
                num = new TimeValuePair(MultiLogTrackMeasurementPlugin.now() + (long)offset, 1);
                numLines.put(key, num);
            } else {
                num.increment();
                num.setTime(MultiLogTrackMeasurementPlugin.now());
            }
        }
    }

    private static class TimeValuePair {
        private Long time;
        private AtomicInteger val;
        private long lastUsed = -1L;

        private TimeValuePair(Long time, Integer val) {
            this.time = time;
            this.val = new AtomicInteger(1);
        }

        public long getLastUsed() {
            return this.lastUsed;
        }

        public void setLastUsed(long lastUsed) {
            this.lastUsed = lastUsed;
        }

        public void setTime(Long time) {
            this.time = time;
        }

        public void increment() {
            this.val.incrementAndGet();
        }

        private Integer getVal() {
            return this.val.get();
        }

        private Long getTime() {
            return this.time;
        }

        public String toString() {
            return "time=" + TimeUtil.toString((long)this.time) + ", val=" + this.val.get();
        }
    }
}

