/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.plugin.wsmq.cmd;

import com.ibm.mq.MQException;
import com.ibm.mq.pcf.PCFMessage;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import org.hyperic.hq.plugin.wsmq.cmd.InquireDefault;
import org.hyperic.hq.product.MetricUnreachableException;

public class InquireCluster
extends InquireDefault {
    private static final int[] ATTRS = new int[]{1087};
    private static final List ATTR_NAMES = Arrays.asList("Availability");

    public double processValue(String metricName, PCFMessage[] responses) {
        assert (responses.length == 1) : responses.length;
        int attr = this.getAttributes()[this.getAttributesName().indexOf(metricName)];
        return ((Integer)responses[0].getParameterValue(attr)).intValue();
    }

    public double getAvail(PCFMessage[] responses) {
        assert (responses.length == 1) : Arrays.asList(responses);
        double res = ((Integer)responses[0].getParameterValue(1087)).intValue();
        switch ((int)res) {
            case 1: {
                res = 0.0;
                break;
            }
            case 0: {
                res = 1.0;
                break;
            }
            default: {
                assert (false) : res;
                res = 2.0;
            }
        }
        return res;
    }

    public double processPCFExceptionForAvail(MQException e1) throws MetricUnreachableException {
        assert (false) : e1;
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public int[] getAttributes() {
        return ATTRS;
    }

    public List getAttributesName() {
        return ATTR_NAMES;
    }

    public PCFMessage getRequest(Properties properties) {
        PCFMessage msg = new PCFMessage(70);
        msg.addParameter(2031, properties.getProperty("Mgr"));
        msg.addParameter(2029, properties.getProperty("Cluster"));
        msg.addParameter(1093, ATTRS);
        return msg;
    }
}

