/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.plugin.wsmq.finders;

import com.ibm.mq.MQException;
import com.ibm.mq.pcf.PCFMessage;
import com.ibm.mq.pcf.PCFMessageAgent;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.hq.plugin.wsmq.MQSeriesProductPlugin;
import org.hyperic.hq.plugin.wsmq.finders.ServiceFinder;
import org.hyperic.hq.plugin.wsmq.services.Service;
import org.hyperic.hq.product.PluginException;
import org.hyperic.util.config.ConfigResponse;

public abstract class DefaultFinder
implements ServiceFinder {
    private String qmgrName;
    private ConfigResponse serverConfig;

    public DefaultFinder(ConfigResponse serverConfig) {
        this.qmgrName = serverConfig.getValue("queue.manager.name");
        this.serverConfig = serverConfig;
    }

    public DefaultFinder(String mgrName) {
        this.qmgrName = mgrName;
        this.serverConfig = new ConfigResponse();
    }

    public String getQmgrName() {
        return this.qmgrName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final List findServices() throws PluginException {
        this.getLog().debug((Object)("(findServices) mgrName=" + this.qmgrName));
        PCFMessageAgent agent = null;
        ArrayList<Service> services = new ArrayList<Service>();
        try {
            agent = new PCFMessageAgent(this.qmgrName);
            PCFMessage request = this.getPCFMessage();
            if (MQSeriesProductPlugin.isTraceEnabled() && this.getLog().isDebugEnabled()) {
                this.getLog().debug((Object)("request = " + request));
            }
            PCFMessage[] responses = agent.send(request);
            assert (responses.length > 0) : responses.length;
            for (int i = 0; i < responses.length; ++i) {
                PCFMessage response = responses[i];
                if (MQSeriesProductPlugin.isTraceEnabled() && this.getLog().isDebugEnabled()) {
                    this.getLog().debug((Object)("response=" + response));
                }
                if (!this.isOK(response)) continue;
                Service service = this.newInstace(this.qmgrName, response);
                if (this.serverConfig.getValue("discover.SYSTEMS", "false").equals("false")) {
                    if (service.getName().startsWith("SYSTEM")) continue;
                    services.add(service);
                    continue;
                }
                services.add(service);
            }
            ArrayList<Service> arrayList = services;
            return arrayList;
        }
        catch (MQException e) {
            this.processPCFException(e);
        }
        catch (Exception e) {
            this.getLog().debug((Object)("findServices () error:" + e.getMessage()), (Throwable)e);
        }
        finally {
            if (agent != null) {
                try {
                    agent.disconnect();
                }
                catch (MQException e) {
                    this.getLog().error((Object)("agent.disconnect() : " + e.getMessage()));
                }
            }
        }
        return services;
    }

    public abstract boolean isOK(PCFMessage var1);

    public final Log getLog() {
        return LogFactory.getLog(this.getClass());
    }

    public abstract Service newInstace(String var1, PCFMessage var2);

    public abstract PCFMessage getPCFMessage();

    void processPCFException(MQException e) {
        this.getLog().debug((Object)("[processPCFException] MQ error:" + e.getMessage()), (Throwable)e);
    }
}

