/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.plugin.wsmq.track;

import com.ibm.mq.MQException;
import com.ibm.mq.MQGetMessageOptions;
import com.ibm.mq.MQMessage;
import com.ibm.mq.MQQueue;
import com.ibm.mq.MQQueueManager;
import com.ibm.mq.pcf.PCFMessage;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.hq.plugin.wsmq.MQSeriesEventsTrack;

public abstract class EventsTracker
implements Runnable {
    private String queueName;
    private String qManagerName;
    private MQSeriesEventsTrack plugin;
    private MQQueueManager mqQueueManager = null;
    private MQQueue queue = null;
    private List msgsRead = new ArrayList();
    private long lastRound;
    private static final char[] HEX_CHARS = "0123456789abcdef".toCharArray();

    public EventsTracker(String qManager, String qName, MQSeriesEventsTrack plugin) {
        this.qManagerName = qManager;
        this.queueName = qName;
        this.plugin = plugin;
        this.lastRound = System.currentTimeMillis();
    }

    public abstract String getEventType();

    public abstract int getOriginParameter();

    public abstract int getValidCommand();

    public final Log getLog() {
        return LogFactory.getLog(this.getClass());
    }

    public void setQManager(String qManagerName) {
        this.qManagerName = qManagerName;
    }

    public static int[] byteArrayToIntegerArray(byte[] b) throws IOException {
        int[] retval = new int[b.length / 4];
        DataInputStream din = new DataInputStream(new ByteArrayInputStream(b));
        for (int n = 0; n < retval.length; ++n) {
            retval[n] = din.readInt();
        }
        return retval;
    }

    public static String toString(byte[] buf) {
        char[] chars = new char[2 * buf.length];
        for (int i = 0; i < buf.length; ++i) {
            chars[2 * i] = HEX_CHARS[(buf[i] & 0xF0) >>> 4];
            chars[2 * i + 1] = HEX_CHARS[buf[i] & 0xF];
        }
        return new String(chars);
    }

    private void open() throws MQException {
        if (this.mqQueueManager == null) {
            this.getLog().debug((Object)("(" + this.plugin.getName() + ") open() qManager='" + this.qManagerName + "' qName='" + this.queueName + "'"));
            this.mqQueueManager = new MQQueueManager(this.qManagerName);
            this.queue = this.mqQueueManager.accessQueue(this.queueName, 8, null, null, null);
        }
    }

    private void close() {
        this.getLog().debug((Object)("(" + this.plugin.getName() + ") close() qManager='" + this.qManagerName + "' qName='" + this.queueName + "'"));
        if (this.queue != null) {
            try {
                this.queue.close();
            }
            catch (MQException ex1) {
                this.getLog().error((Object)"Error closing Queue", (Throwable)ex1);
            }
        }
        if (this.mqQueueManager != null) {
            try {
                this.mqQueueManager.disconnect();
                this.mqQueueManager.close();
            }
            catch (MQException ex1) {
                this.getLog().error((Object)"Error closing QueueManager", (Throwable)ex1);
            }
        }
        this.mqQueueManager = null;
    }

    public synchronized void run() {
        long start = System.currentTimeMillis();
        try {
            int events = this.browse();
            long time = (System.currentTimeMillis() - start) / 1000L;
            String msg = time + " Seg. read " + events + " events";
            if (time > 30L) {
                this.plugin.reportErrorEvent("EventsTracker", msg, start);
            } else if (time > 20L) {
                this.plugin.reportWarnEvent("EventsTracker", msg, start);
            } else if (time > 10L) {
                this.plugin.reportInfoEvent("EventsTracker", msg, start);
            } else {
                this.plugin.reportDebugEvent("EventsTracker", msg, start);
            }
        }
        catch (MQException ex) {
            this.plugin.reportErrorEvent("EventsTracker", "Error reading events. " + ex.getMessage(), start);
            this.getLog().error((Object)("Error reading events. " + ex.getMessage()), (Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private int browse() throws MQException {
        this.getLog().debug((Object)("(" + this.plugin.getName() + ") run() qManager='" + this.qManagerName + "' qName='" + this.queueName + "'"));
        if (this.getLog().isTraceEnabled()) {
            this.getLog().trace((Object)("==>" + this.plugin.getProperties()));
        }
        getMessageOptions = new MQGetMessageOptions();
        getMessageOptions.matchOptions = 0;
        getMessageOptions.options = 33;
        objSrc = null;
        mensaje = null;
        cont = 0;
        try {
            this.open();
            block12: while (true) {
                while (true) {
                    message = new MQMessage();
                    this.queue.get(message, getMessageOptions);
                    ++cont;
                    messageId = EventsTracker.toString(message.messageId);
                    this.getLog().debug((Object)("messageId=" + messageId));
                    this.getLog().debug((Object)("putDateTime=" + message.putDateTime.getTime()));
                    if (!this.msgsRead.contains(messageId) && message.putDateTime.getTimeInMillis() > this.lastRound) {
                        try {
                            msg = new PCFMessage(message);
                            if (this.getLog().isTraceEnabled()) {
                                this.getLog().trace((Object)msg);
                            }
                            if (msg.getCommand() == this.getValidCommand()) {
                                prop = "events." + this.getEventType() + "." + msg.getReason();
                                mensaje = this.plugin.getProperties().getProperty(prop);
                                if (mensaje == null) {
                                    mensaje = "BAD REASON => msg.getReason() => " + msg.getReason() + "(" + prop + ")";
                                }
                            } else {
                                mensaje = "BAD COMMAND => msg.getCommand() => " + msg.getCommand();
                            }
                            objSrc = msg.getStringParameterValue(this.getOriginParameter()).trim();
                            this.plugin.reportInfoEvent(this.qManagerName, objSrc + " " + mensaje, message.putDateTime.getTimeInMillis());
                            this.msgsRead.add(messageId);
                            continue block12;
                        }
                        catch (MQException ex) {
                            this.getLog().debug((Object)("Error: " + ex.getMessage()), (Throwable)ex);
                            continue;
                        }
                    }
                    this.getLog().debug((Object)("messageId '" + messageId + "' old"));
                }
                break;
            }
            catch (IOException ex) {
                this.getLog().debug((Object)("Error: " + ex.getMessage()), (Throwable)ex);
                this.close();
                this.lastRound = System.currentTimeMillis();
            }
        }
        catch (MQException ex) {
            switch (ex.reasonCode) {
                case 2033: 
                case 2059: {
                    this.getLog().debug((Object)("No events - reason '" + ex.reasonCode + "'"));
                    ** break;
lbl54:
                    // 1 sources

                    break;
                }
                default: {
                    throw ex;
                }
            }
        }
        finally {
            this.close();
            this.lastRound = System.currentTimeMillis();
        }
        this.getLog().debug((Object)("CONT=" + cont));
        return cont;
    }
}

