/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.bizapp.client;

import java.io.IOException;
import java.net.ConnectException;
import java.util.HashSet;
import javax.net.ssl.SSLException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.hq.agent.AgentKeystoreConfig;
import org.hyperic.hq.agent.stats.AgentStatsCollector;
import org.hyperic.hq.bizapp.agent.ProviderInfo;
import org.hyperic.hq.bizapp.client.AgentCallbackClientException;
import org.hyperic.hq.bizapp.client.ProviderFetcher;
import org.hyperic.hq.bizapp.shared.lather.CommandInfo;
import org.hyperic.hq.bizapp.shared.lather.SecureAgentLatherValue;
import org.hyperic.lather.LatherRemoteException;
import org.hyperic.lather.LatherValue;
import org.hyperic.lather.client.LatherHTTPClient;

public abstract class AgentCallbackClient {
    private static final int TIMEOUT_CONN = 30000;
    private static final int TIMEOUT_DATA = 300000;
    private static final Log log = LogFactory.getLog(AgentCallbackClient.class);
    private static final String LATHER_CMD = "LATHER_CMD";
    private ProviderFetcher fetcher;
    private HashSet<String> secureCommands;
    private static AgentStatsCollector statsCollector = AgentStatsCollector.getInstance();

    public AgentCallbackClient(ProviderFetcher fetcher, String[] secureCommands) {
        this.fetcher = fetcher;
        this.resetProvider();
        this.secureCommands = new HashSet();
        for (int i = 0; i < secureCommands.length; ++i) {
            this.secureCommands.add(secureCommands[i]);
        }
    }

    public AgentCallbackClient(ProviderFetcher fetcher) {
        this(fetcher, CommandInfo.SECURE_COMMANDS);
    }

    void resetProvider() {
    }

    protected ProviderInfo getProvider() throws AgentCallbackClientException {
        ProviderInfo val = this.fetcher.getProvider();
        if (val == null) {
            String msg = "Unable to communicate with server -- provider not yet setup";
            throw new AgentCallbackClientException("Unable to communicate with server -- provider not yet setup");
        }
        return val;
    }

    public static boolean isValidProviderURL(String provider) {
        return provider.startsWith("http:") || provider.startsWith("https:");
    }

    public static String getDefaultProviderURL(String host, int port, boolean secure) {
        if (port == -1) {
            port = secure ? 7443 : 7080;
        }
        String proto = secure ? "https" : "http";
        return proto + "://" + host + ":" + port + "/lather";
    }

    public static String getHostFromProviderURL(String providerURL) {
        int startIndex = providerURL.indexOf(58) + 3;
        int endIndex = providerURL.indexOf(58, startIndex);
        return providerURL.substring(startIndex, endIndex);
    }

    protected LatherValue invokeLatherCall(ProviderInfo provider, String methodName, LatherValue args) throws AgentCallbackClientException {
        return this.invokeLatherCall(provider, methodName, args, new AgentKeystoreConfig().isAcceptUnverifiedCert());
    }

    protected LatherValue invokeLatherCall(ProviderInfo provider, String methodName, LatherValue args, boolean acceptUnverifiedCertificates) throws AgentCallbackClientException {
        boolean debug = log.isDebugEnabled();
        String addr = provider.getProviderAddress();
        if (this.secureCommands.contains(methodName)) {
            String agentToken = provider.getAgentToken();
            ((SecureAgentLatherValue)args).setAgentToken(agentToken);
        }
        try {
            LatherHTTPClient client = new LatherHTTPClient(addr, 30000, 300000, acceptUnverifiedCertificates);
            long start = this.now();
            LatherValue rtn = client.invoke(methodName, args);
            long duration = this.now() - start;
            statsCollector.addStat(duration, LATHER_CMD);
            statsCollector.addStat(duration, "LATHER_CMD_" + methodName.toUpperCase());
            return rtn;
        }
        catch (SSLException e) {
            if (debug) {
                log.debug((Object)e, (Throwable)e);
            }
            throw new AgentCallbackClientException(e);
        }
        catch (ConnectException exc) {
            String eMsg = "Unable to contact server @ " + addr + ": " + exc;
            if (debug) {
                log.debug((Object)eMsg);
            }
            throw new AgentCallbackClientException(eMsg);
        }
        catch (IOException exc) {
            String msg = exc.getMessage();
            if (msg != null) {
                String eMsg;
                if (msg.indexOf("Service Unavailable") != -1) {
                    eMsg = "Unable to contact server -- it has no more free connections";
                    if (debug) {
                        log.debug((Object)eMsg);
                    }
                } else {
                    eMsg = "IO error: " + exc.getMessage();
                    if (debug) {
                        log.debug((Object)eMsg);
                    }
                }
                throw new AgentCallbackClientException(eMsg);
            }
            if (debug) {
                log.debug((Object)"IO error", (Throwable)exc);
            }
            throw new AgentCallbackClientException("IO error: " + exc.getMessage());
        }
        catch (LatherRemoteException exc) {
            String eMsg;
            if (exc.getMessage().indexOf("Unauthorized agent denied") != -1) {
                eMsg = "Unable to invoke '" + methodName + "':  Permission denied";
                if (debug) {
                    log.debug((Object)eMsg);
                }
            } else {
                eMsg = "Remote error while invoking '" + methodName + ": " + (Object)((Object)exc);
                if (debug) {
                    log.debug((Object)eMsg);
                }
            }
            throw new AgentCallbackClientException(eMsg, exc);
        }
        catch (IllegalStateException e) {
            if (debug) {
                log.debug((Object)"Could not create the LatherHTTPClient instance", (Throwable)e);
            }
            throw new AgentCallbackClientException(e);
        }
    }

    private long now() {
        return System.currentTimeMillis();
    }

    static {
        statsCollector.register(LATHER_CMD);
        for (String cmd : CommandInfo.ALL_COMMANDS) {
            statsCollector.register("LATHER_CMD_" + cmd.toUpperCase());
        }
    }
}

