/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.plugin.samba;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.hq.product.AutoServerDetector;
import org.hyperic.hq.product.GenericPlugin;
import org.hyperic.hq.product.PluginException;
import org.hyperic.hq.product.ServerDetector;
import org.hyperic.hq.product.ServerResource;
import org.hyperic.hq.product.ServiceResource;
import org.hyperic.util.config.ConfigResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SambaServerDetector
extends ServerDetector
implements AutoServerDetector {
    private static final String VERSION_3_x = "3.x";
    private static final String SERVER_NAME = "Samba";
    private static final String PROCESS_NAME = "smbd";
    private static final String PTQL_QUERY = "State.Name.eq=smbd,State.Name.Pne=$1";
    private static Log log = LogFactory.getLog(SambaServerDetector.class);

    public List<ServerResource> getServerResources(ConfigResponse platformConfig) throws PluginException {
        ArrayList<ServerResource> servers = new ArrayList<ServerResource>();
        List<String> paths = SambaServerDetector.getServerProcessList();
        for (int i = 0; i < paths.size(); ++i) {
            String dir = paths.get(i);
            List<ServerResource> found = this.getServerList(dir);
            if (found.isEmpty()) continue;
            servers.addAll(found);
        }
        return servers;
    }

    private static List<String> getServerProcessList() {
        ArrayList<String> servers = new ArrayList<String>();
        long[] pids = SambaServerDetector.getPids((String)PTQL_QUERY);
        for (int i = 0; i < pids.length; ++i) {
            String exe = SambaServerDetector.getProcExe((long)pids[i]);
            if (exe == null) continue;
            File binary = new File(exe);
            if (!binary.isAbsolute()) {
                String proccessFullPath = SambaServerDetector.getProcessFullPath(exe);
                if (null == proccessFullPath || proccessFullPath.equalsIgnoreCase("")) continue;
                servers.add(proccessFullPath);
                continue;
            }
            servers.add(binary.getAbsolutePath());
        }
        return servers;
    }

    private static String getProcessFullPath(String exe) {
        String[] cmd = new String[]{"which", exe, "-a"};
        try {
            String line;
            Process process = Runtime.getRuntime().exec(cmd);
            BufferedReader fp = new BufferedReader(new InputStreamReader(process.getInputStream()));
            String output = "";
            while (null != (line = fp.readLine())) {
                output = output + line;
            }
            File binary = new File(output);
            if (binary.isAbsolute()) {
                return binary.getAbsolutePath();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private String getVersion(String path) {
        String[] cmd = new String[]{path, "-V"};
        try {
            String line;
            Process process = Runtime.getRuntime().exec(cmd);
            BufferedReader fp = new BufferedReader(new InputStreamReader(process.getInputStream()));
            String output = "";
            while (null != (line = fp.readLine())) {
                output = output + line;
            }
            Pattern p_3_x = Pattern.compile("\\s+3\\.[0-9]");
            if (p_3_x.matcher(output).find()) {
                return VERSION_3_x;
            }
        }
        catch (IOException e) {
            log.warn((Object)("Cannot get version info from " + path), (Throwable)e);
        }
        return null;
    }

    public List<ServerResource> getServerList(String path) throws PluginException {
        ArrayList<ServerResource> servers = new ArrayList<ServerResource>();
        String installpath = SambaServerDetector.getParentDir((String)path, (int)1);
        ConfigResponse productConfig = new ConfigResponse();
        productConfig.setValue("installpath", installpath);
        String version = "";
        version = this.getVersion(path);
        if (null == version) {
            return servers;
        }
        if (path.indexOf(PROCESS_NAME) == -1) {
            return servers;
        }
        ServerResource server = this.createServerResource(installpath);
        ConfigResponse cprop = new ConfigResponse();
        cprop.setValue("version", version);
        server.setCustomProperties(cprop);
        this.setProductConfig(server, productConfig);
        server.setMeasurementConfig();
        server.setName("Samba " + version);
        servers.add(server);
        return servers;
    }

    protected List<String> discoverServices(ConfigResponse config) throws PluginException {
        String installpath = config.getValue("installpath");
        ArrayList<String> services = new ArrayList<String>();
        return services;
    }

    private ServiceResource getService(String name, String installpath) {
        ServiceResource service = new ServiceResource();
        service.setType((GenericPlugin)this, name);
        service.setServiceName(name);
        ConfigResponse productConfig = new ConfigResponse();
        productConfig.setValue("installpath", installpath);
        this.setProductConfig(service, productConfig);
        service.setMeasurementConfig();
        return service;
    }
}

