/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.plugin.websphere;

import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import org.hyperic.hq.plugin.websphere.WebspherePMI;
import org.hyperic.hq.plugin.websphere.WebsphereProductPlugin;
import org.hyperic.hq.product.MeasurementPlugin;
import org.hyperic.hq.product.Metric;
import org.hyperic.hq.product.MetricNotFoundException;
import org.hyperic.hq.product.MetricUnreachableException;
import org.hyperic.hq.product.MetricValue;
import org.hyperic.hq.product.PluginException;

public class WebsphereMeasurementPlugin
extends MeasurementPlugin {
    public boolean useJMX() {
        return false;
    }

    public MetricValue getValue(Metric metric) throws PluginException, MetricUnreachableException, MetricNotFoundException {
        if (!WebsphereProductPlugin.VALID_JVM) {
            throw new MetricUnreachableException("The WebSphere plugin needs a IBM JVM !!! (agent jvm=" + System.getProperty("java.vm.vendor") + ")");
        }
        if (this.useJMX()) {
            return super.getValue(metric);
        }
        MetricValue mValue = null;
        Double val = WebspherePMI.getValue(metric);
        mValue = new MetricValue((Number)val, System.currentTimeMillis());
        return mValue;
    }

    public Properties getCollectorProperties(Metric metric) {
        String domain = metric.getDomainName();
        Properties props = new Properties();
        props.putAll((Map<?, ?>)metric.getProperties());
        props.putAll((Map<?, ?>)metric.getObjectProperties());
        StringTokenizer tok = new StringTokenizer(domain, "/");
        props.setProperty("server.node", tok.nextToken());
        props.setProperty("server.name", tok.nextToken());
        if (tok.hasMoreTokens()) {
            props.setProperty("type", tok.nextToken());
            if (tok.hasMoreTokens()) {
                String module = tok.nextToken();
                props.setProperty("Module", module);
            }
        }
        return props;
    }
}

