/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.plugin.websphere;

import com.ibm.websphere.management.AdminClient;
import javax.management.ObjectName;
import javax.management.j2ee.statistics.Stats;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.hq.plugin.websphere.WebsphereCollector;
import org.hyperic.hq.plugin.websphere.WebsphereUtil;
import org.hyperic.hq.product.PluginException;

public class WebsphereServerCollector
extends WebsphereCollector {
    private static final Log log = LogFactory.getLog((String)WebsphereServerCollector.class.getName());
    private boolean isJVM;
    private static final String[][] TX_ATTRS = new String[][]{{"GlobalBegunCount", "globalTransBegun"}, {"GlobalInvolvedCount", "globalTransInvolved"}, {"LocalBegunCount", "localTransBegun"}, {"ActiveCount", "activeGlobalTrans"}, {"LocalActiveCount", "activeLocalTrans"}, {"OptimizationCount", "numOptimization"}, {"CommittedCount", "globalTransCommitted"}, {"LocalCommittedCount", "localTransCommitted"}, {"RolledbackCount", "globalTransRolledBack"}, {"LocalRolledbackCount", "localTransRolledBack"}, {"GlobalTimeoutCount", "globalTransTimeout"}, {"LocalTimeoutCount", "localTransTimeout"}, {"GlobalTranTime"}, {"LocalTranTime"}, {"GlobalBeforeCompletionTime"}, {"GlobalPrepareTime"}, {"GlobalCommitTime"}, {"LocalCommitTime"}, {"LocalRolledbackCount"}};

    protected void init(AdminClient mServer) throws PluginException {
        String name;
        String serverName = this.getProperties().getProperty("server.name");
        String module = this.getProperties().getProperty("Module");
        log.info((Object)("[init] [" + serverName + "] module=" + module));
        if (module.equals("jvmRuntimeModule")) {
            this.isJVM = true;
            name = "name=JVM,type=JVM,j2eeType=JVM";
        } else if (module.equals("transactionModule")) {
            name = "type=TransactionService,j2eeType=JTAResource";
        } else if (module.equals("adminModule")) {
            name = "name=JVM,type=JVM";
        } else {
            throw new PluginException("Unexpected module '" + module + "'");
        }
        ObjectName on = this.newObjectNamePattern(name + "," + this.getServerAttributes());
        on = this.resolve(mServer, on);
        log.debug((Object)("[init] [" + serverName + "] name=" + on));
        this.setObjectName(on);
        this.getStats(mServer, this.getObjectName());
    }

    public void collect(AdminClient mServer) throws PluginException {
        log.info((Object)("[collect] " + this.getProperties()));
        if (this.getModuleName().equalsIgnoreCase("adminModule")) {
            this.setValue("NumJVMs", this.count(mServer));
        } else {
            Stats stats = this.getStats(mServer, this.getObjectName());
            if (stats != null) {
                if (this.isJVM) {
                    this.setValue("totalMemory", this.getStatCount(stats, "HeapSize"));
                    this.setValue("usedMemory", this.getStatCount(stats, "UsedMemory"));
                    this.setValue("freeMemory", this.getStatCount(stats, "freeMemory"));
                    this.setValue("ProcessCpuUsage", this.getStatCount(stats, "ProcessCpuUsage"));
                } else {
                    this.collectStatCount(stats, TX_ATTRS);
                }
            } else {
                log.debug((Object)"no Stats");
            }
        }
    }

    private double count(AdminClient mServer) throws PluginException {
        try {
            return WebsphereUtil.getMBeanCount(mServer, this.getObjectName(), null);
        }
        catch (Exception ex) {
            throw new PluginException(ex.getMessage(), (Throwable)ex);
        }
    }
}

