/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.plugin.netservices;

import java.io.IOException;
import java.net.InetAddress;
import org.hyperic.hq.plugin.netservices.DHCPClient;
import org.hyperic.hq.plugin.netservices.NetServicesCollector;
import org.hyperic.hq.product.PluginException;
import org.hyperic.sigar.NetInterfaceConfig;
import org.hyperic.sigar.Sigar;
import org.hyperic.sigar.SigarException;

public class DHCPCollector
extends NetServicesCollector {
    private byte[] hwaddr;
    private InetAddress address;

    private String getDefaultHwaddr() throws PluginException {
        String errmsg = "Unable to determine hardware address";
        Sigar sigar = new Sigar();
        try {
            NetInterfaceConfig ifconfig = sigar.getNetInterfaceConfig();
            String hwaddr = ifconfig.getHwaddr();
            this.setSource(ifconfig.getName() + "/" + hwaddr);
            String string = hwaddr;
            return string;
        }
        catch (SigarException e) {
            throw new PluginException("Unable to determine hardware address: " + e.getMessage());
        }
        finally {
            sigar.close();
        }
    }

    protected void init() throws PluginException {
        super.init();
        String address = this.getProperties().getProperty("hwaddr");
        if (address == null) {
            address = this.getDefaultHwaddr();
        } else {
            this.setSource(address);
        }
        this.hwaddr = DHCPClient.decodeHwaddr(address);
        try {
            this.address = InetAddress.getByName(this.getHostname());
        }
        catch (IOException e) {
            throw new PluginException(e.getMessage(), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void collect() {
        DHCPClient client = null;
        try {
            DHCPClient.Packet response;
            this.startTime();
            client = new DHCPClient(this.address, this.getPort());
            client.setTimeout(this.getTimeoutMillis());
            DHCPClient.Packet request = client.getDiscoverPacket(this.hwaddr);
            client.send(request);
            do {
                response = client.receive();
            } while (response.xid != request.xid);
            this.endTime();
            String msg = "Server " + response.getSaddress() + " offered address: " + response.getYaddress();
            this.setInfoMessage(msg);
            this.setAvailability(true);
        }
        catch (IOException e) {
            this.setAvailability(false);
            this.setErrorMessage(e.getMessage());
        }
        finally {
            if (client != null) {
                client.close();
            }
        }
    }
}

