/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.plugin.netservices;

import java.util.Properties;
import javax.naming.NamingEnumeration;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.InitialLdapContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.hq.plugin.netservices.LDAPSSLSocketFactory;
import org.hyperic.hq.plugin.netservices.NetServicesCollector;

public class LDAPCollector
extends NetServicesCollector {
    private static final String PROP_BASEDN = "baseDN";
    private static final String PROP_BINDDN = "bindDN";
    private static final String PROP_BINDPW = "bindPW";
    private static final String PROP_FILTER = "filter";
    private static Log log = LogFactory.getLog((String)LDAPCollector.class.getName());

    private SearchControls getSearchControls() {
        int scope = 2;
        int timeLimit = this.getTimeoutMillis();
        long countLimit = 0L;
        String[] returnedAttributes = null;
        boolean returnObject = false;
        boolean deference = false;
        SearchControls constraints = new SearchControls(scope, countLimit, timeLimit, returnedAttributes, returnObject, deference);
        return constraints;
    }

    public void collect() {
        Properties env = new Properties();
        Properties props = this.getProperties();
        String factoryName = env.getProperty("java.naming.factory.initial");
        if (factoryName == null) {
            env.setProperty("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        }
        if (this.isSSL()) {
            env.put("java.naming.ldap.factory.socket", LDAPSSLSocketFactory.class.getName());
            env.put("java.naming.security.protocol", "ssl");
        }
        String providerUrl = "ldap://" + this.getHostname() + ":" + this.getPort();
        env.setProperty("java.naming.provider.url", providerUrl);
        this.setSource(providerUrl);
        env.setProperty("java.naming.referral", "follow");
        String baseDN = props.getProperty(PROP_BASEDN);
        if (baseDN == null) {
            this.setErrorMessage("No Base DN given, refusing login");
            this.setAvailability(false);
            return;
        }
        String filter = props.getProperty(PROP_FILTER);
        String bindDN = props.getProperty(PROP_BINDDN);
        String bindPW = props.getProperty(PROP_BINDPW);
        if (bindDN != null) {
            env.setProperty("java.naming.security.principal", bindDN);
            env.setProperty("java.naming.security.credentials", bindPW);
            env.setProperty("java.naming.security.authentication", "simple");
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Using LDAP environment: " + env));
        }
        try {
            this.startTime();
            InitialLdapContext ctx = new InitialLdapContext(env, null);
            this.endTime();
            this.setAvailability(true);
            if (filter != null) {
                log.debug((Object)("Using LDAP filter=" + filter));
                NamingEnumeration<SearchResult> answer = ctx.search(baseDN, filter, this.getSearchControls());
                long matches = 0L;
                while (answer.hasMore()) {
                    ++matches;
                    answer.next();
                }
                this.setValue("NumberofMatches", matches);
            }
        }
        catch (Exception e) {
            this.setAvailability(false);
            if (log.isDebugEnabled()) {
                log.debug((Object)("LDAP check failed: " + e), (Throwable)e);
            }
            this.setErrorMessage("LDAP check failed: " + e);
        }
    }
}

