/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.plugin.netservices;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.Socket;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SocketWrapper {
    private static Log log = LogFactory.getLog((String)SocketWrapper.class.getName());
    boolean isDebug = log.isDebugEnabled();
    public static final String CRLF = "\r\n";
    Socket socket;
    BufferedReader reader = null;
    BufferedWriter writer = null;

    public SocketWrapper(Socket socket) {
        this.socket = socket;
    }

    public Socket getSocket() {
        return this.socket;
    }

    public void close() {
        SocketWrapper.close(this.socket);
    }

    public static void close(Socket socket) {
        if (socket == null) {
            return;
        }
        try {
            socket.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public BufferedReader getReader() throws IOException {
        if (this.reader == null) {
            this.reader = SocketWrapper.getReader(this.socket);
        }
        return this.reader;
    }

    public BufferedWriter getWriter() throws IOException {
        if (this.writer == null) {
            this.writer = SocketWrapper.getWriter(this.socket);
        }
        return this.writer;
    }

    public String readLine() throws IOException {
        String line = this.getReader().readLine();
        if (this.isDebug) {
            log.debug((Object)("<<< " + line));
        }
        if (line == null) {
            throw new IOException("readLine failed");
        }
        return line;
    }

    public void writeLine(String line) throws IOException {
        this.getWriter();
        if (this.isDebug) {
            log.debug((Object)(">>> " + line));
        }
        this.writer.write(line);
        this.writer.write(CRLF);
        this.writer.flush();
    }

    public static BufferedReader getReader(Socket socket) throws IOException {
        InputStreamReader is = new InputStreamReader(socket.getInputStream());
        return new BufferedReader(is);
    }

    public static BufferedWriter getWriter(Socket socket) throws IOException {
        OutputStreamWriter os = new OutputStreamWriter(socket.getOutputStream());
        return new BufferedWriter(os);
    }
}

