/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vfabric.hyperic.plugin.vfgf;

import com.vmware.vfabric.hyperic.plugin.vfgf.cache.MemberCache;
import com.vmware.vfabric.hyperic.plugin.vfgf.detector.GF7ServerDetector;
import com.vmware.vfabric.hyperic.plugin.vfgf.util.JmxManagerFinder;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.hq.product.PluginException;
import org.hyperic.hq.product.PluginManager;
import org.hyperic.hq.product.ProductPlugin;

public class GFProductPlugin
extends ProductPlugin {
    private static final Log log = LogFactory.getLog(GF7ServerDetector.class);
    private Map<String, MemberCache> memberCaches = new HashMap<String, MemberCache>();
    private static String jmxUrl = new String();

    public MemberCache getMemberCache(String id) {
        MemberCache cache = this.memberCaches.get(id);
        if (cache == null) {
            cache = new MemberCache();
            this.memberCaches.put(id, cache);
        }
        return cache;
    }

    public void init(PluginManager manager) throws PluginException {
        super.init(manager);
    }

    public void shutdown() throws PluginException {
        for (MemberCache cache : this.memberCaches.values()) {
            cache.shutdown();
        }
        super.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void resetJmxUrl() {
        String string = jmxUrl;
        synchronized (string) {
            jmxUrl = "";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getJmxUrl(String locators) {
        if (jmxUrl == null) {
            jmxUrl = new String();
        }
        String string = jmxUrl;
        synchronized (string) {
            if (!jmxUrl.isEmpty()) {
                return jmxUrl;
            }
            jmxUrl = JmxManagerFinder.getJmxUrl(locators);
            if (jmxUrl != null) {
                return jmxUrl;
            }
            return "";
        }
    }
}

