/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vfabric.hyperic.plugin.vfgf.cache;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.vmware.vfabric.hyperic.plugin.vfgf.MemberUpdater;
import com.vmware.vfabric.hyperic.plugin.vfgf.cache.MemberInfo;
import com.vmware.vfabric.hyperic.plugin.vfgf.mx.GFJmxConnection;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.util.config.ConfigResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MemberCache {
    private static final Log log = LogFactory.getLog(MemberCache.class);
    private BiMap<String, MemberInfo> cacheVMMap = HashBiMap.create();
    MemberUpdater memberUpdater = new MemberUpdater(this);

    public String getGfid(String workingDirectory, String host, String name) {
        MemberInfo tmp = new MemberInfo(null, name, host, workingDirectory);
        return (String)this.cacheVMMap.inverse().get((Object)tmp);
    }

    public MemberInfo getMember(String workingDirectory, String host, String name) {
        MemberInfo tmp = new MemberInfo(null, name, host, workingDirectory);
        return (MemberInfo)this.cacheVMMap.get(this.cacheVMMap.inverse().get((Object)tmp));
    }

    public Set<MemberInfo> getMembers() {
        return this.cacheVMMap.values();
    }

    public MemberInfo getMember(String id) {
        return (MemberInfo)this.cacheVMMap.get((Object)id);
    }

    public void refreshCacheVMs(ConfigResponse config) {
        MemberInfo[] members;
        GFJmxConnection gf = new GFJmxConnection(config);
        for (MemberInfo memberInfo : members = gf.getCacheVmMembers()) {
            this.cacheVMMap.forcePut((Object)memberInfo.getGfid(), (Object)memberInfo);
        }
    }

    public void refresh(Properties config) {
        this.memberUpdater.refreshCacheVMs(config);
    }

    public void refreshPeers(ConfigResponse config) {
        MemberInfo[] members;
        GFJmxConnection gf = new GFJmxConnection(config);
        for (MemberInfo memberInfo : members = gf.getSystemMemberApplications()) {
            this.cacheVMMap.forcePut((Object)memberInfo.getGfid(), (Object)memberInfo);
        }
    }

    public BiMap<String, MemberInfo> getCacheVMMap() {
        return this.cacheVMMap;
    }

    public void shutdown() {
        this.memberUpdater.stop();
    }
}

