/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.plugin.rabbitmq.collect;

import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.hq.plugin.rabbitmq.collect.RabbitMQDefaultCollector;
import org.hyperic.hq.plugin.rabbitmq.core.HypericRabbitAdmin;
import org.hyperic.hq.plugin.rabbitmq.core.RabbitConnection;

public class ConnectionCollector
extends RabbitMQDefaultCollector {
    private static final Log logger = LogFactory.getLog(ConnectionCollector.class);

    public void collect(HypericRabbitAdmin rabbitAdmin) {
        Properties props = this.getProperties();
        String cName = props.getProperty("connection");
        logger.debug((Object)("[collect] ConnectionName=" + cName));
        try {
            logger.debug((Object)("[collect] RabbitConnection=" + cName));
            RabbitConnection conn = rabbitAdmin.getConnection(cName);
            this.setValue("Availability", 1.0);
            this.setValue("packetsReceived", conn.getRecvCnt());
            this.setValue("packetsSent", conn.getSendCnt());
            this.setValue("channelCount", conn.getChannels());
            this.setValue("octetsReceived", conn.getRecvOct());
            this.setValue("octetsSent", conn.getSendOct());
            this.setValue("pendingSends", conn.getSendPend());
        }
        catch (Exception ex) {
            this.setAvailability(false);
            logger.debug((Object)ex.getMessage(), (Throwable)ex);
        }
    }

    public Log getLog() {
        return logger;
    }
}

