/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.springsource.hyperic.plugin.gemfire.detectors;

import com.vmware.springsource.hyperic.plugin.gemfire.GemFireUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.management.MBeanServerConnection;
import org.apache.commons.logging.Log;
import org.hyperic.hq.product.AutoServerDetector;
import org.hyperic.hq.product.PluginException;
import org.hyperic.hq.product.ServerDetector;
import org.hyperic.hq.product.ServerResource;
import org.hyperic.hq.product.ServiceResource;
import org.hyperic.hq.product.jmx.MxUtil;
import org.hyperic.util.config.ConfigResponse;

public abstract class MemberDetector
extends ServerDetector
implements AutoServerDetector {
    Log log = this.getLog();

    public List getServerResources(ConfigResponse pc) throws PluginException {
        this.log.debug((Object)("[getServerResources] pc=" + pc));
        ArrayList<ServerResource> servers = new ArrayList<ServerResource>();
        HashMap<String, String> names = new HashMap<String, String>();
        try {
            MBeanServerConnection mServer = MxUtil.getMBeanServer((Properties)pc.toProperties());
            List<String> members = GemFireUtils.getMembers(mServer);
            this.log.debug((Object)("[getServerResources] members=" + Arrays.asList(members)));
            for (String memberID : members) {
                Map<String, Object> memberDetails = GemFireUtils.getMemberDetails(memberID, mServer);
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("[getServerResources] memberDetails=" + memberDetails));
                }
                if (!this.isValidMember(memberDetails)) continue;
                String name = (String)memberDetails.get("gemfire.member.name.string");
                if (names.get(name) != null) {
                    this.log.error((Object)("[getServerResources] There is 2 of more '" + this.getTypeInfo().getName() + "' with the same name '" + name + "'"));
                }
                names.put(name, name);
                ServerResource server = this.createServerResource("");
                server.setName(this.getTypeInfo().getName() + " " + name);
                server.setIdentifier("GFDS server.name " + name);
                ConfigResponse c = new ConfigResponse();
                c.setValue("member.name", name);
                this.setMeasurementConfig(server, c);
                this.setProductConfig(server, new ConfigResponse());
                this.setCustomProperties(server, this.getAtributtes(memberDetails));
                servers.add(server);
            }
        }
        catch (Exception ex) {
            throw new PluginException(ex.getMessage(), (Throwable)ex);
        }
        return servers;
    }

    protected List discoverServices(ConfigResponse config) throws PluginException {
        this.log.debug((Object)("[discoverServices] config=" + config));
        ArrayList<ServiceResource> services = new ArrayList<ServiceResource>();
        try {
            List gateways;
            MBeanServerConnection mServer = MxUtil.getMBeanServer((Properties)config.toProperties());
            String memberID = GemFireUtils.memberNameToMemberID(config.getValue("member.name"), mServer);
            Map<String, Object> memberDetails = GemFireUtils.getMemberDetails(memberID, mServer);
            Map regions = (Map)memberDetails.get("gemfire.member.regions.map");
            if (regions != null) {
                for (Map region : regions.values()) {
                    String name = (String)region.get("gemfire.region.name.string");
                    ServiceResource service = this.createServiceResource("Region");
                    service.setName(memberDetails.get("gemfire.member.name.string") + " Region " + name);
                    ConfigResponse c = new ConfigResponse();
                    c.setValue("regionID", name);
                    this.log.debug((Object)("[discoverServices] region -> c=" + c));
                    ConfigResponse attr = new ConfigResponse();
                    attr.setValue("name", (String)region.get("gemfire.region.name.string"));
                    attr.setValue("path", (String)region.get("gemfire.region.path.string"));
                    attr.setValue("scope", (String)region.get("gemfire.region.scope.string"));
                    attr.setValue("datapolicy", (String)region.get("gemfire.region.datapolicy.string"));
                    attr.setValue("interestpolicy", (String)region.get("gemfire.region.interestpolicy.string"));
                    attr.setValue("diskattrs", (String)region.get("gemfire.region.diskattrs.string"));
                    this.setMeasurementConfig(service, c);
                    service.setCustomProperties(attr);
                    services.add(service);
                }
            }
            if ((gateways = (List)memberDetails.get("gemfire.member.gatewayhub.gateways.collection")) != null) {
                for (Map gateway : gateways) {
                    String id = (String)gateway.get("gemfire.member.gateway.id.string");
                    ServiceResource service = this.createServiceResource("Gateway");
                    service.setName(memberDetails.get("gemfire.member.name.string") + " Gateway " + id);
                    ConfigResponse c = new ConfigResponse();
                    c.setValue("gatewayID", id);
                    this.log.debug((Object)("[discoverServices] gateway -> c=" + c));
                    this.setProductConfig(service, new ConfigResponse());
                    this.setMeasurementConfig(service, c);
                    services.add(service);
                }
            }
        }
        catch (Exception ex) {
            throw new PluginException(ex.getMessage(), (Throwable)ex);
        }
        return services;
    }

    abstract boolean isValidMember(Map var1);

    abstract ConfigResponse getAtributtes(Map var1);
}

