/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.plugin.netdevice;

import java.util.Map;
import org.hyperic.hq.plugin.netdevice.SNMPCollector;
import org.hyperic.snmp.SNMPSession;
import org.hyperic.snmp.SNMPValue;

public class HrStorageCollector
extends SNMPCollector {
    private static final String SIZE = "hrStorageSize";
    private static final String USED = "hrStorageUsed";
    private static final String UNITS = "hrStorageAllocationUnits";

    public void collect() {
        String columnName = this.getColumnName();
        if (columnName.equals(SIZE) || columnName.equals(USED)) {
            try {
                SNMPSession session = this.getSession();
                Map units = this.getIndexedColumn(session, UNITS, false);
                this.collectIndexedColumn(new HrUnitsConverter(units));
            }
            catch (Exception e) {
                return;
            }
        } else {
            this.collectIndexedColumn();
        }
    }

    public static class HrUnitsConverter
    implements SNMPCollector.ColumnValueConverter {
        private Map _units;

        public HrUnitsConverter(Map units) {
            this._units = units;
        }

        public double convert(String index, SNMPValue value) throws Exception {
            double val = value.toLong();
            SNMPValue unit = (SNMPValue)this._units.get(index);
            if (unit != null) {
                val *= (double)unit.toLong();
            }
            return val;
        }
    }
}

