/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.plugin.netdevice;

import java.io.IOException;
import java.net.InetAddress;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.hq.product.LogTrackPlugin;
import org.hyperic.hq.product.LogTrackPluginManager;
import org.hyperic.snmp.SNMPClient;
import org.snmp4j.CommandResponder;
import org.snmp4j.CommandResponderEvent;
import org.snmp4j.MessageDispatcher;
import org.snmp4j.MessageDispatcherImpl;
import org.snmp4j.Snmp;
import org.snmp4j.TransportMapping;
import org.snmp4j.mp.MPv1;
import org.snmp4j.mp.MPv2c;
import org.snmp4j.mp.MPv3;
import org.snmp4j.mp.MessageProcessingModel;
import org.snmp4j.security.SecurityModel;
import org.snmp4j.security.SecurityModels;
import org.snmp4j.security.SecurityProtocols;
import org.snmp4j.security.USM;
import org.snmp4j.smi.Address;
import org.snmp4j.smi.GenericAddress;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.TcpAddress;
import org.snmp4j.smi.UdpAddress;
import org.snmp4j.smi.VariableBinding;
import org.snmp4j.transport.DefaultTcpTransportMapping;
import org.snmp4j.transport.DefaultUdpTransportMapping;
import org.snmp4j.util.MultiThreadedMessageDispatcher;
import org.snmp4j.util.ThreadPool;
import org.snmp4j.util.WorkerPool;

public class SNMPTrapReceiver
implements CommandResponder {
    static final String PROP_LISTEN_ADDRESS = "snmpTrapReceiver.listenAddress";
    static final String DEFAULT_LISTEN_ADDRESS = "udp:0.0.0.0/162";
    private static SNMPTrapReceiver instance = null;
    private static final Log log = LogFactory.getLog((String)SNMPTrapReceiver.class.getName());
    private MultiThreadedMessageDispatcher _dispatcher;
    private Snmp _snmp;
    private Address _listenAddress;
    private ThreadPool _threadPool;
    private Map _plugins = new HashMap();
    LogTrackPluginManager _manager;
    private int _received = 0;

    static boolean hasInstance() {
        return instance != null;
    }

    public static SNMPTrapReceiver getInstance(Properties props) throws IOException {
        if (!SNMPTrapReceiver.hasInstance()) {
            instance = new SNMPTrapReceiver();
            instance.init(props);
        }
        return instance;
    }

    public static void start(Properties props) throws IOException {
        SNMPTrapReceiver.getInstance(props);
    }

    public static void shutdown() throws IOException {
        if (SNMPTrapReceiver.hasInstance()) {
            log.debug((Object)"Shutdown instance");
            SNMPTrapReceiver.instance._threadPool.cancel();
            SNMPTrapReceiver.instance._snmp.close();
            instance = null;
        }
    }

    private static String getPluginKey(String address, String community) {
        return address + "-" + community;
    }

    private static String getConfig(LogTrackPlugin plugin, String key, String def) {
        String value = plugin.getConfig(key);
        if (value == null) {
            return plugin.getManager().getProperty(key, def);
        }
        return value;
    }

    private static String getPluginKey(LogTrackPlugin plugin) {
        String address = SNMPTrapReceiver.getConfig(plugin, "snmpIp", "127.0.0.1");
        String community = SNMPTrapReceiver.getConfig(plugin, "snmpCommunity", SNMPClient.DEFAULT_COMMUNITY);
        return SNMPTrapReceiver.getPluginKey(address, community);
    }

    private LogTrackPlugin getPlugin(String address, String community) {
        String key = SNMPTrapReceiver.getPluginKey(address, community);
        return (LogTrackPlugin)this._plugins.get(key);
    }

    public void add(LogTrackPlugin plugin) throws IOException {
        String key = SNMPTrapReceiver.getPluginKey(plugin);
        log.debug((Object)("Add " + plugin.getName() + " for " + key));
        this._plugins.put(key, plugin);
    }

    public static void remove(LogTrackPlugin plugin) {
        if (!SNMPTrapReceiver.hasInstance()) {
            return;
        }
        String key = SNMPTrapReceiver.getPluginKey(plugin);
        log.debug((Object)("Remove " + plugin.getName() + " for " + key));
        SNMPTrapReceiver.instance._plugins.remove(key);
    }

    private SNMPTrapReceiver() {
    }

    private void init(Properties props) throws IOException {
        String address = props.getProperty(PROP_LISTEN_ADDRESS, DEFAULT_LISTEN_ADDRESS).trim();
        String numThreads = props.getProperty("snmpTrapReceiver.numThreads", "1");
        this._threadPool = ThreadPool.create((String)"SNMPTrapReceiver", (int)Integer.parseInt(numThreads));
        this._dispatcher = new MultiThreadedMessageDispatcher((WorkerPool)this._threadPool, (MessageDispatcher)new MessageDispatcherImpl());
        try {
            this._listenAddress = GenericAddress.parse((String)address);
            if (!this._listenAddress.isValid()) {
                throw new IllegalArgumentException();
            }
        }
        catch (Exception e) {
            throw new IOException("Invalid snmpTrapReceiver.listenAddress=" + address);
        }
        log.debug((Object)("snmpTrapReceiver.listenAddress=" + address));
        Object transport = this._listenAddress instanceof UdpAddress ? new DefaultUdpTransportMapping((UdpAddress)this._listenAddress) : new DefaultTcpTransportMapping((TcpAddress)this._listenAddress);
        this._snmp = new Snmp((MessageDispatcher)this._dispatcher, (TransportMapping)transport);
        this._snmp.getMessageDispatcher().addMessageProcessingModel((MessageProcessingModel)new MPv1());
        this._snmp.getMessageDispatcher().addMessageProcessingModel((MessageProcessingModel)new MPv2c());
        this._snmp.getMessageDispatcher().addMessageProcessingModel((MessageProcessingModel)new MPv3());
        USM usm = new USM(SecurityProtocols.getInstance(), new OctetString(MPv3.createLocalEngineID()), 0);
        SecurityModels.getInstance().addSecurityModel((SecurityModel)usm);
        this._snmp.addCommandResponder((CommandResponder)this);
        this._snmp.listen();
    }

    public int getTrapsReceived() {
        return this._received;
    }

    private String getMessage(CommandResponderEvent event) {
        StringBuffer msg = new StringBuffer();
        Vector vars = event.getPDU().getVariableBindings();
        int size = vars.size();
        for (int i = 0; i < size; ++i) {
            VariableBinding var = (VariableBinding)vars.get(i);
            msg.append(var.getVariable().toString().trim());
            if (i >= size - 1) continue;
            msg.append(", ");
        }
        return msg.toString();
    }

    private LogTrackPlugin getPlatformPlugin() {
        String prop = "platform.log_track.default";
        String name = this._manager.getProperty("platform.log_track.default");
        return this._manager.getLogTrackPlugin(name);
    }

    void setPluginManager(LogTrackPluginManager manager) {
        this._manager = manager;
    }

    public void processPdu(CommandResponderEvent event) {
        InetAddress peerAddress;
        ++this._received;
        Address peer = event.getPeerAddress();
        if (peer instanceof UdpAddress) {
            peerAddress = ((UdpAddress)peer).getInetAddress();
        } else if (peer instanceof TcpAddress) {
            peerAddress = ((TcpAddress)peer).getInetAddress();
        } else {
            log.debug((Object)("Unsupported transport: " + peer.getClass().getName()));
            return;
        }
        String address = peerAddress.getHostAddress();
        String community = new OctetString(event.getSecurityName()).toString();
        LogTrackPlugin plugin = this.getPlugin(address, community);
        if (plugin == null && (plugin = this.getPlatformPlugin()) != null && log.isDebugEnabled()) {
            log.debug((Object)("No plugin for '" + address + "', '" + community + "', routing to default platform: " + plugin.getName()));
        }
        if (plugin == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("No plugin for " + address + ", msg=" + this.getMessage(event)));
            }
        } else {
            String msg = this.getMessage(event);
            if (log.isDebugEnabled()) {
                log.debug((Object)("plugin=" + plugin.getName() + ", trapsReceived=" + this.getTrapsReceived() + ", pduType=" + event.getPDU().getType() + ", address=" + address + ", community=" + community + ", msg=" + msg));
            }
            plugin.reportEvent(System.currentTimeMillis(), 3, address, msg);
        }
    }

    public static void main(String[] args) throws Exception {
        SNMPTrapReceiver.start(System.getProperties());
        System.out.println("Ready");
        System.in.read();
        System.out.print("Shutting down...");
        SNMPTrapReceiver.shutdown();
        System.out.println("done");
    }
}

