/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.lather;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.hyperic.lather.LatherKeyNotFoundException;
import org.hyperic.lather.LatherRemoteException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class LatherValue {
    private Map stringVals;
    private Map intVals;
    private Map doubleVals;
    private Map longVals;
    private Map byteaVals;
    private Map objectVals;
    private Map javaObjectVals;
    private Map stringLists;
    private Map intLists;
    private Map doubleLists;
    private Map byteaLists;
    private Map objectLists;
    private final Map<String, Serializable> serializableMap = new HashMap<String, Serializable>();
    private boolean ensureOrder;

    private Map createStorageMap() {
        if (this.ensureOrder) {
            return new TreeMap();
        }
        return new HashMap();
    }

    private void setup(boolean ensureOrder) {
        this.ensureOrder = ensureOrder;
        this.stringVals = this.createStorageMap();
        this.intVals = this.createStorageMap();
        this.doubleVals = this.createStorageMap();
        this.longVals = this.createStorageMap();
        this.byteaVals = this.createStorageMap();
        this.objectVals = this.createStorageMap();
        this.stringLists = this.createStorageMap();
        this.intLists = this.createStorageMap();
        this.doubleLists = this.createStorageMap();
        this.byteaLists = this.createStorageMap();
        this.objectLists = this.createStorageMap();
    }

    public LatherValue() {
        this.setup(false);
    }

    public LatherValue(boolean ensureOrder) {
        this.setup(ensureOrder);
    }

    private void checkArg(Object arg) {
        if (arg == null) {
            throw new IllegalArgumentException("Argument cannot be null");
        }
    }

    protected String getStringValue(String key) {
        String res = (String)this.stringVals.get(key);
        if (res == null) {
            throw new LatherKeyNotFoundException(key);
        }
        return res;
    }

    protected void setStringValue(String key, String value) {
        this.checkArg(value);
        this.stringVals.put(key, value);
    }

    protected int getIntValue(String key) {
        Integer res = (Integer)this.intVals.get(key);
        if (res == null) {
            throw new LatherKeyNotFoundException(key);
        }
        return res;
    }

    protected void setIntValue(String key, int value) {
        this.intVals.put(key, new Integer(value));
    }

    protected double getDoubleValue(String key) {
        Double res = (Double)this.doubleVals.get(key);
        if (res == null) {
            throw new LatherKeyNotFoundException(key);
        }
        return res;
    }

    protected void setDoubleValue(String key, double value) {
        this.doubleVals.put(key, new Double(value));
    }

    protected long getLongValue(String key) {
        Long res = (Long)this.longVals.get(key);
        if (res == null) {
            throw new LatherKeyNotFoundException(key);
        }
        return res;
    }

    protected void setLongValue(String key, long value) {
        this.longVals.put(key, new Long(value));
    }

    protected byte[] getByteAValue(String key) {
        byte[] res = (byte[])this.byteaVals.get(key);
        if (res == null) {
            throw new LatherKeyNotFoundException(key);
        }
        return res;
    }

    protected void setObjectValue(String key, LatherValue value) {
        this.checkArg(value);
        this.objectVals.put(key, value);
    }

    protected LatherValue getObjectValue(String key) {
        LatherValue res = (LatherValue)this.objectVals.get(key);
        if (res == null) {
            throw new LatherKeyNotFoundException(key);
        }
        return res;
    }

    protected void setByteAValue(String key, byte[] value) {
        this.checkArg(value);
        this.byteaVals.put(key, value);
    }

    private List getListValueForAdd(Map map, String listName) {
        ArrayList res = (ArrayList)map.get(listName);
        if (res == null) {
            res = new ArrayList();
            map.put(listName, res);
        }
        return res;
    }

    private List getListValueForGet(Map map, String listName) {
        List res = (List)map.get(listName);
        if (res == null) {
            throw new LatherKeyNotFoundException(listName);
        }
        return res;
    }

    protected void addStringToList(String listName, String value) {
        List list = this.getListValueForAdd(this.stringLists, listName);
        this.checkArg(value);
        list.add(value);
    }

    protected String[] getStringList(String listName) {
        List list = this.getListValueForGet(this.stringLists, listName);
        return list.toArray(new String[0]);
    }

    protected void addIntToList(String listName, int value) {
        List list = this.getListValueForAdd(this.intLists, listName);
        list.add(new Integer(value));
    }

    protected int[] getIntList(String listName) {
        List list = this.getListValueForGet(this.intLists, listName);
        int[] res = new int[list.size()];
        int idx = 0;
        for (Integer val : list) {
            res[idx++] = val;
        }
        return res;
    }

    protected void addDoubleToList(String listName, double value) {
        List list = this.getListValueForAdd(this.doubleLists, listName);
        list.add(new Double(value));
    }

    protected double[] getDoubleList(String listName) {
        List list = this.getListValueForGet(this.doubleLists, listName);
        double[] res = new double[list.size()];
        int idx = 0;
        for (Double val : list) {
            res[idx++] = val;
        }
        return res;
    }

    protected void addByteAToList(String listName, byte[] value) {
        List list = this.getListValueForAdd(this.byteaLists, listName);
        this.checkArg(value);
        list.add(value);
    }

    protected byte[][] getByteAList(String listName) {
        List list = this.getListValueForGet(this.byteaLists, listName);
        return (byte[][])list.toArray((T[])new byte[0][]);
    }

    protected void addObjectToList(String listName, Object value) {
        List list = this.getListValueForAdd(this.objectLists, listName);
        this.checkArg(value);
        list.add(value);
    }

    protected Object[] getObjectList(String listName) {
        List list = this.getListValueForGet(this.objectLists, listName);
        return list.toArray(new LatherValue[0]);
    }

    protected Serializable getObject(String objectName) {
        return this.serializableMap.get(objectName);
    }

    protected void addObject(String objectName, Serializable object) {
        this.serializableMap.put(objectName, object);
    }

    public Map getStringVals() {
        return this.stringVals;
    }

    public Map getIntVals() {
        return this.intVals;
    }

    public Map getDoubleVals() {
        return this.doubleVals;
    }

    public Map getLongVals() {
        return this.longVals;
    }

    public Map getByteAVals() {
        return this.byteaVals;
    }

    public Map getObjectVals() {
        return this.objectVals;
    }

    public Map getStringLists() {
        return this.stringLists;
    }

    public Map getIntLists() {
        return this.intLists;
    }

    public Map getDoubleLists() {
        return this.doubleLists;
    }

    public Map getByteALists() {
        return this.byteaLists;
    }

    public Map getObjectLists() {
        return this.objectLists;
    }

    public Map<String, Serializable> getSerializableMap() {
        return this.serializableMap;
    }

    public abstract void validate() throws LatherRemoteException;
}

