/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.product;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.hyperic.hq.product.MeasurementPlugin;
import org.hyperic.hq.product.Metric;
import org.hyperic.hq.product.MetricInvalidException;
import org.hyperic.hq.product.MetricNotFoundException;
import org.hyperic.hq.product.MetricUnreachableException;
import org.hyperic.hq.product.MetricValue;
import org.hyperic.hq.product.PluginException;
import org.hyperic.sigar.Sigar;
import org.hyperic.sigar.SigarException;
import org.hyperic.sigar.SigarNotImplementedException;
import org.hyperic.sigar.SigarProxy;
import org.hyperic.sigar.SigarProxyCache;
import org.hyperic.sigar.jmx.SigarInvokerJMX;
import org.hyperic.sigar.ptql.MalformedQueryException;
import org.hyperic.sigar.ptql.ProcessFinder;
import org.hyperic.sigar.ptql.ProcessQuery;
import org.hyperic.sigar.ptql.ProcessQueryFactory;
import org.hyperic.sigar.ptql.QueryLoadException;
import org.hyperic.util.StringUtil;
import org.hyperic.util.config.ConfigResponse;

public class SigarMeasurementPlugin
extends MeasurementPlugin {
    public static final String DOMAIN = "sigar";
    public static final String PTQL_DOMAIN = "sigar.ptql";
    public static final String PTQL_CONFIG = "process.query";
    private Sigar sigar = null;
    private SigarProxy sigarProxy = null;
    private ProcessFinder processFinder = null;
    private static final Map AVAIL_ATTRS = new HashMap();

    protected Sigar getSigar() throws PluginException {
        if (this.sigar != null) {
            return this.sigar;
        }
        try {
            this.sigar = new Sigar();
            this.sigarProxy = SigarProxyCache.newInstance((Sigar)this.sigar);
        }
        catch (UnsatisfiedLinkError le) {
            this.getLog().warn((Object)("unable to load sigar: " + le.getMessage()));
            return null;
        }
        return this.sigar;
    }

    public void shutdown() throws PluginException {
        if (this.sigar != null) {
            this.sigar.close();
        }
        super.shutdown();
    }

    public String translate(String template, ConfigResponse config) {
        String newTemplate;
        if (template.indexOf("sigar.ptql:") > 0 && (newTemplate = StringUtil.replace((String)template, (String)"%process.query%", (String)config.getValue(PTQL_CONFIG))) != template) {
            return newTemplate;
        }
        return super.translate(template, config);
    }

    private String translatePTQL(Metric jdsn) throws MetricNotFoundException {
        long pid;
        ProcessQuery query;
        String qs = jdsn.getPropString();
        if (this.processFinder == null) {
            this.processFinder = new ProcessFinder(this.sigarProxy);
        }
        try {
            query = ProcessQueryFactory.getInstance((String)qs);
        }
        catch (MalformedQueryException e) {
            throw new MetricInvalidException(e.getMessage(), e);
        }
        catch (QueryLoadException e) {
            throw new MetricInvalidException(e.getMessage(), e);
        }
        try {
            pid = this.processFinder.findSingleProcess(query);
        }
        catch (SigarNotImplementedException e) {
            throw new MetricInvalidException(e.getMessage(), e);
        }
        catch (MalformedQueryException e) {
            throw new MetricNotFoundException(e.getMessage(), e);
        }
        catch (SigarException e) {
            throw new MetricNotFoundException(e.getMessage(), e);
        }
        String type = "Type";
        String arg = "Arg";
        return new StringBuffer().append("Type").append('=').append(jdsn.getObjectProperty("Type")).append(',').append("Arg").append('=').append(pid).toString();
    }

    private boolean isProcessState(String attr) {
        return attr.equals("State");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MetricValue getSwapPercentage(Metric m) throws MetricNotFoundException {
        Double returnVal;
        Object used;
        Object free;
        Object total;
        String attribute = m.getAttributeName();
        SigarInvokerJMX invoker = SigarInvokerJMX.getInstance((SigarProxy)this.sigarProxy, (String)m.getObjectName());
        Sigar sigar = this.sigar;
        synchronized (sigar) {
            try {
                total = invoker.invoke("Total");
                free = invoker.invoke("Free");
                used = invoker.invoke("Used");
            }
            catch (SigarNotImplementedException e) {
                throw new MetricInvalidException("Unable to gather swap metrics", e);
            }
            catch (SigarException e) {
                throw new MetricInvalidException("Unable to gather swap metrics", e);
            }
        }
        if (this.convertToDouble(total, false) == 0.0) {
            returnVal = Double.NaN;
        } else if (attribute.equals("UsedPercent")) {
            returnVal = this.convertToDouble(used, false) / this.convertToDouble(total, false);
        } else if (attribute.equals("FreePercent")) {
            returnVal = this.convertToDouble(free, false) / this.convertToDouble(total, false);
        } else {
            throw new MetricNotFoundException("Unhandled attribute " + attribute);
        }
        return new MetricValue(returnVal, System.currentTimeMillis());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MetricValue getTimeSinceMetrics(Metric m) throws MetricNotFoundException {
        Double returnVal;
        Object atime;
        Object ctime;
        Object mtime;
        String attribute = m.getAttributeName();
        SigarInvokerJMX invoker = SigarInvokerJMX.getInstance((SigarProxy)this.sigarProxy, (String)m.getObjectName());
        Sigar sigar = this.sigar;
        synchronized (sigar) {
            try {
                mtime = invoker.invoke("Mtime");
                ctime = invoker.invoke("Ctime");
                atime = invoker.invoke("Atime");
            }
            catch (SigarNotImplementedException e) {
                throw new MetricInvalidException("Unable to gather FileInfo metrics", e);
            }
            catch (SigarException e) {
                throw new MetricInvalidException("Unable to gather FileInfo metrics", e);
            }
        }
        Long now = System.currentTimeMillis();
        if (attribute.equals("SMtime")) {
            returnVal = (double)now.longValue() - this.convertToDouble(mtime, false);
        } else if (attribute.equals("SAtime")) {
            returnVal = (double)now.longValue() - this.convertToDouble(atime, false);
        } else if (attribute.equals("SCtime")) {
            returnVal = (double)now.longValue() - this.convertToDouble(ctime, false);
        } else {
            throw new MetricNotFoundException("Unhandled attribute " + attribute);
        }
        return new MetricValue(returnVal, System.currentTimeMillis());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MetricValue getValue(Metric metric) throws PluginException, MetricNotFoundException, MetricUnreachableException {
        Object systemValue;
        String alias;
        Properties props;
        String mType;
        String domain = metric.getDomainName();
        String name = metric.getObjectName();
        String attr = metric.getAttributeName();
        if (this.sigar == null) {
            this.getSigar();
        }
        if ((mType = (props = metric.getObjectProperties()).getProperty("Type")).equals("Swap") && (attr.equals("UsedPercent") || attr.equals("FreePercent"))) {
            return this.getSwapPercentage(metric);
        }
        if (mType.equals("FileInfo") && attr.equals("SMtime") || attr.equals("SCtime") || attr.equals("SAtime")) {
            return this.getTimeSinceMetrics(metric);
        }
        name = domain.equals(PTQL_DOMAIN) ? this.translatePTQL(metric) : StringUtil.replace((String)name, (String)"Type=FileSystemUsage", (String)"Type=MountedFileSystemUsage");
        boolean isAvailabilityAttribute = false;
        boolean isStateAttribute = false;
        if (attr.equals("Availability")) {
            String type = metric.getObjectProperty("Type");
            alias = (String)AVAIL_ATTRS.get(type);
            if (alias != null) {
                attr = alias;
                isAvailabilityAttribute = true;
            }
        } else {
            isAvailabilityAttribute = isStateAttribute = this.isProcessState(attr);
        }
        SigarInvokerJMX invoker = SigarInvokerJMX.getInstance((SigarProxy)this.sigarProxy, (String)name);
        try {
            alias = this.sigar;
            synchronized (alias) {
                systemValue = invoker.invoke(attr);
            }
        }
        catch (SigarNotImplementedException e) {
            return MetricValue.NONE;
        }
        catch (SigarException e) {
            if (isAvailabilityAttribute) {
                return new MetricValue(0.0);
            }
            throw new MetricNotFoundException(e.getMessage(), e);
        }
        Double useVal = isAvailabilityAttribute && !isStateAttribute ? (systemValue instanceof Number && ((Number)systemValue).intValue() > 0 ? new Double(1.0) : new Double(0.0)) : this.convertToDouble(systemValue, isStateAttribute);
        if (useVal == -1.0) {
            return MetricValue.NONE;
        }
        return new MetricValue(useVal, System.currentTimeMillis());
    }

    private Double convertToDouble(Object systemValue, boolean isProcessState) throws MetricNotFoundException {
        Double useVal;
        if (systemValue instanceof Double) {
            useVal = (Double)systemValue;
        } else if (systemValue instanceof Long) {
            useVal = new Double(((Long)systemValue).longValue());
        } else if (systemValue instanceof Integer) {
            useVal = new Double(((Integer)systemValue).intValue());
        } else if (systemValue instanceof Character) {
            char c = ((Character)systemValue).charValue();
            if (isProcessState) {
                double avail;
                switch (c) {
                    case 'Z': {
                        avail = 0.0;
                        break;
                    }
                    case 'T': {
                        avail = -0.01;
                        break;
                    }
                    default: {
                        avail = 1.0;
                    }
                }
                useVal = new Double(avail);
            } else {
                useVal = new Double(c);
            }
        } else {
            throw new MetricNotFoundException("System plugin returned a " + systemValue.getClass() + " object, which could not " + " be handled");
        }
        return useVal;
    }

    static {
        AVAIL_ATTRS.put("DirUsage", "Total");
        AVAIL_ATTRS.put("FileInfo", "Type");
        AVAIL_ATTRS.put("MultiProcCpu", "Processes");
        AVAIL_ATTRS.put("MultiProcMem", "Size");
    }
}

