/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.product.pluginxml;

import org.hyperic.hq.product.pluginxml.BaseTag;
import org.hyperic.hq.product.pluginxml.ConfigTag;
import org.hyperic.hq.product.pluginxml.ContainerTag;
import org.hyperic.util.config.BooleanConfigOption;
import org.hyperic.util.config.ConfigOption;
import org.hyperic.util.config.ConfigSchema;
import org.hyperic.util.config.HiddenConfigOption;
import org.hyperic.util.config.IpAddressConfigOption;
import org.hyperic.util.config.MacAddressConfigOption;
import org.hyperic.util.config.SchemaBuilder;
import org.hyperic.util.xmlparser.XmlTagException;

class ConfigOptionTag
extends ContainerTag {
    static final String ATTR_DEFAULT = "default";
    static final String ATTR_OPTIONAL = "optional";
    static final String ATTR_CATEGORY = "category";
    private static final String[] REQUIRED_ATTRS = new String[]{"name", "description"};
    private static final String[] OPTIONAL_ATTRS = new String[]{"default", "type", "optional", "category"};
    private ConfigTag config;
    protected SchemaBuilder schema;

    ConfigOptionTag(BaseTag config) {
        super(config);
        this.config = (ConfigTag)config;
    }

    public String getName() {
        return "option";
    }

    public String[] getOptionalAttributes() {
        return OPTIONAL_ATTRS;
    }

    public String[] getRequiredAttributes() {
        return REQUIRED_ATTRS;
    }

    public void startTag() {
        super.startTag();
        this.schema = this.config.schema;
    }

    private Integer integerValueOf(String val) {
        if (val == null) {
            return null;
        }
        return Integer.valueOf(val);
    }

    private Double doubleValueOf(String val) {
        if (val == null) {
            return null;
        }
        return Double.valueOf(val);
    }

    private String[] getIncludeOptions() {
        String[] options = new String[this.includes.size()];
        this.includes.toArray(options);
        this.includes.clear();
        return options;
    }

    private String getIncludeOptionsAsString(char delim) {
        StringBuffer buffer = new StringBuffer();
        int size = this.includes.size();
        for (int i = 0; i < size; ++i) {
            buffer.append(this.includes.get(i));
            if (i >= size - 1) continue;
            buffer.append(delim);
        }
        this.includes.clear();
        return buffer.toString();
    }

    void endTag() throws XmlTagException {
        ConfigOption option;
        String type = this.getAttribute("type", "string");
        String name = this.getAttribute("name");
        String dval = this.getAttribute(ATTR_DEFAULT);
        String desc = this.getAttribute("description", name);
        if (type.equals("string")) {
            option = this.schema.add(name, desc, dval);
        } else if (type.equals("int")) {
            option = this.schema.add(name, desc, this.integerValueOf(dval));
        } else if (type.equals("double")) {
            option = this.schema.add(name, desc, this.doubleValueOf(dval));
        } else if (type.equals("secret")) {
            ConfigSchema.addSecret((String)name);
            option = this.schema.addSecret(name, desc);
        } else if (type.equals("hidden")) {
            option = new HiddenConfigOption(name, dval);
            this.schema.getSchema().addOption(option);
        } else if (type.equals("port")) {
            option = this.schema.addPort(name, desc, this.integerValueOf(dval));
        } else if (type.equals("boolean")) {
            if (dval == null) {
                dval = "true";
            }
            option = new BooleanConfigOption(name, desc, dval.equals("true"));
            option.setOptional(true);
            this.schema.getSchema().addOption(option);
        } else if (type.equals("ipaddress")) {
            option = new IpAddressConfigOption(name, desc, dval);
            this.schema.getSchema().addOption(option);
        } else if (type.equals("macaddress")) {
            option = new MacAddressConfigOption(name, desc, dval);
            this.schema.getSchema().addOption(option);
        } else if (type.equals("enum")) {
            option = this.schema.addEnum(name, desc, this.getIncludeOptions(), dval);
        } else if (type.equals("stringarray")) {
            option = this.schema.addStringArray(name, desc, this.getIncludeOptionsAsString(' '));
        } else {
            throw new XmlTagException("Unsupported config type: " + type);
        }
        if (this.includes.size() > 0) {
            throw new XmlTagException("option type=" + type + " does support <include>");
        }
        if ("true".equals(this.getAttribute(ATTR_OPTIONAL))) {
            option.setOptional(true);
        }
        option.setCategory(this.getAttribute(ATTR_CATEGORY));
        super.endTag();
    }
}

