/*
 * Decompiled with CFR 0.152.
 */
package org.novadeck.jxla.data;

import java.util.ArrayList;
import java.util.Collections;
import org.apache.oro.text.regex.MalformedPatternException;
import org.apache.oro.text.regex.MatchResult;
import org.apache.oro.text.regex.Pattern;
import org.novadeck.jxla.data.Line;
import org.novadeck.jxla.data.SimpleData;
import org.novadeck.jxla.tools.Constants;
import org.novadeck.jxla.tools.Utils;

public class RegexpData
extends SimpleData {
    public static final String HOSTNAME = "host";
    public static final String REMOTE_IP = "remote_ip";
    public static final String REMOTE_HOST = "remote_host";
    public static final String USER = "user";
    public static final String URI = "uri";
    public static final String QUERY = "query";
    public static final String STATUS = "status";
    public static final String REFERER = "referer";
    public static final String USER_AGENT = "agent";
    public static final String LANGUAGE = "lang";
    public static final String SIZE = "size";
    public static final String TIME_TAKEN = "time_taken";
    public static final String DATE_MSEC = "date_msec";
    public static final char YEAR = 'y';
    public static final char MONTH = 'm';
    public static final char DAY = 'd';
    public static final char HOUR = 'h';
    public static final char OFFSET = 'o';
    public static final char WILDCARD = '*';
    public static final char IDENTIFIER = '$';
    public static final char DELIMITER = '\"';
    public static final char SPACE = ' ';
    public static final char SLASH = '/';
    public static final char DOUBLEPOINT = ':';
    public static final char CROCHET_O = '[';
    public static final char CROCHET_F = ']';
    public static final char TIRET = '-';
    private static RegexpData _lastMatched = null;
    private int _host;
    private int _ip;
    private int _user;
    private int _uri;
    private int _query;
    private int _status;
    private int _referer;
    private int _agent;
    private int _lang;
    private int _size;
    private int _time_taken;
    private int _date_msec;
    private int _year;
    private int _month;
    private int _day;
    private int _hour;
    private int _offset;
    private Pattern _pattern = null;
    private MatchResult _res;
    public String initialRegexp = null;
    public String compiledRegexp = null;
    private static ArrayList _availableRegexp = new ArrayList();
    private static int _globalCounter = 0;
    private static RegexpData[] _arrayRe = null;

    private RegexpData() {
    }

    public RegexpData(String s) {
        this.initialRegexp = s;
        this._host = -1;
        this._ip = -1;
        this._user = -1;
        this._uri = -1;
        this._query = -1;
        this._status = -1;
        this._referer = -1;
        this._agent = -1;
        this._lang = -1;
        this._size = -1;
        this._time_taken = -1;
        this._date_msec = -1;
        this._year = -1;
        this._month = -1;
        this._day = -1;
        this._hour = -1;
        this._offset = -1;
        int length = s.length();
        int current = 0;
        char[] arr = s.toCharArray();
        int pos = 1;
        StringBuffer regexp = new StringBuffer();
        while (current < length) {
            switch (arr[current]) {
                case 'y': {
                    regexp.append("([0-9]{2,4})");
                    ++current;
                    this._year = pos++;
                    break;
                }
                case 'm': {
                    regexp.append("([0-9a-zA-Z]{1,3})");
                    ++current;
                    this._month = pos++;
                    break;
                }
                case 'd': {
                    regexp.append("([ 0-9]{1,2})");
                    ++current;
                    this._day = pos++;
                    break;
                }
                case 'h': {
                    regexp.append("([0-9]{1,2}:[0-9]{1,2}:[0-9]{1,2})");
                    ++current;
                    this._hour = pos++;
                    break;
                }
                case 'o': {
                    regexp.append("([-+][0-9]{1,4})");
                    ++current;
                    this._offset = pos++;
                    break;
                }
                case '$': {
                    ++current;
                    StringBuffer sb = new StringBuffer();
                    boolean found = false;
                    while (current < length && !found) {
                        sb.append(arr[current]);
                        ++current;
                        found = true;
                        if (HOSTNAME.equals(sb.toString())) {
                            regexp.append("([a-zA-Z0-9\\.\\-_]*)");
                            this._host = pos++;
                            continue;
                        }
                        if (REMOTE_IP.equals(sb.toString())) {
                            regexp.append("([0-9\\.]*)");
                            this._ip = pos++;
                            continue;
                        }
                        if (REMOTE_HOST.equals(sb.toString())) {
                            regexp.append("([a-zA-Z0-9\\-\\.]*)");
                            this._ip = pos++;
                            continue;
                        }
                        if (USER.equals(sb.toString())) {
                            regexp.append("([^ ]*)");
                            this._user = pos++;
                            continue;
                        }
                        if (URI.equals(sb.toString())) {
                            regexp.append("(http://[^/]*)?(\\/[^ ]*)");
                            int n = ++pos;
                            ++pos;
                            this._uri = n;
                            continue;
                        }
                        if (QUERY.equals(sb.toString())) {
                            regexp.append("([^ ]*)");
                            this._query = pos++;
                            continue;
                        }
                        if (STATUS.equals(sb.toString())) {
                            regexp.append("([0-9]*)");
                            this._status = pos++;
                            continue;
                        }
                        if (REFERER.equals(sb.toString())) {
                            regexp.append("\"([^\"]*)\"");
                            this._referer = pos++;
                            continue;
                        }
                        if (USER_AGENT.equals(sb.toString())) {
                            regexp.append("\"([^\"]*)\"");
                            this._agent = pos++;
                            continue;
                        }
                        if (LANGUAGE.equals(sb.toString())) {
                            regexp.append("\"([^\"]*)\"");
                            this._lang = pos++;
                            continue;
                        }
                        if (SIZE.equals(sb.toString())) {
                            regexp.append("([0-9\\-][0-9]*)");
                            this._size = pos++;
                            continue;
                        }
                        if (TIME_TAKEN.equals(sb.toString())) {
                            regexp.append("([0-9\\-][0-9]*)");
                            this._time_taken = pos++;
                            continue;
                        }
                        if (DATE_MSEC.equals(sb.toString())) {
                            regexp.append("([0-9][0-9]*)");
                            this._date_msec = pos++;
                            continue;
                        }
                        found = false;
                    }
                    break;
                }
                case '*': {
                    ++current;
                    regexp.append("[^ ]*");
                    break;
                }
                case '\"': {
                    regexp.append('\"');
                    ++current;
                    break;
                }
                case ' ': {
                    regexp.append(' ');
                    ++current;
                    break;
                }
                case '/': {
                    regexp.append('/');
                    ++current;
                    break;
                }
                case ':': {
                    regexp.append(':');
                    ++current;
                    break;
                }
                case '[': {
                    regexp.append('\\');
                    regexp.append('[');
                    ++current;
                    break;
                }
                case ']': {
                    regexp.append('\\');
                    regexp.append(']');
                    ++current;
                    break;
                }
                case '-': {
                    regexp.append('-');
                    ++current;
                    break;
                }
            }
        }
        regexp.append('$');
        this.compiledRegexp = regexp.toString();
        try {
            this._pattern = Constants.COMPILER.compile(this.compiledRegexp);
        }
        catch (MalformedPatternException e) {
            // empty catch block
        }
    }

    public String getCompiledRegexp() {
        return this.compiledRegexp;
    }

    public boolean match(String s) {
        ++_globalCounter;
        this._res = null;
        if (Constants.MATCHER.matches(s, this._pattern)) {
            this.inc();
            _lastMatched = this;
            this._res = Constants.MATCHER.getMatch();
            return true;
        }
        return false;
    }

    private String getExpr(int rank) {
        if (this._res == null || rank <= 0) {
            return null;
        }
        return this._res.group(rank);
    }

    public String getHost() {
        return this.getExpr(this._host);
    }

    public String getRemoteIP() {
        String ip = this.getExpr(this._ip);
        return ip;
    }

    public String getUser() {
        return this.getExpr(this._user);
    }

    public String getURI() {
        String uri = this.getExpr(this._uri);
        String query = this.getExpr(this._query);
        if (query != null && !query.equals("-")) {
            return uri + "?" + query;
        }
        return uri;
    }

    public String getStatus() {
        return this.getExpr(this._status);
    }

    public String getReferer() {
        return this.getExpr(this._referer);
    }

    public String getAgent() {
        return this.getExpr(this._agent);
    }

    public String getLanguage() {
        return this.getExpr(this._lang);
    }

    public long getSize() {
        if (this._res == null || this._size <= 0) {
            return 0L;
        }
        String s = this.getExpr(this._size);
        if (Utils.isEmpty(s) || "-".equals(s)) {
            return 0L;
        }
        return Long.parseLong(s);
    }

    public long getTimeTaken() {
        String s = this.getExpr(this._time_taken);
        if (Utils.isEmpty(s)) {
            return 0L;
        }
        return Long.parseLong(s.trim());
    }

    public long getDateMSec() {
        String s = this.getExpr(this._date_msec);
        if (Utils.isEmpty(s)) {
            return -1L;
        }
        return Long.parseLong(s.trim());
    }

    public int getHour() {
        int firstcolon;
        String s = this.getExpr(this._hour);
        if (Utils.isEmpty(s)) {
            return 0;
        }
        String hourStr = s.trim();
        if (Utils.isEmpty(s = hourStr.substring(0, firstcolon = hourStr.indexOf(58)))) {
            return 0;
        }
        return Integer.parseInt(s);
    }

    public String getOffset() {
        if (this._offset != -1) {
            return this.getExpr(this._offset).trim();
        }
        return null;
    }

    public int getMinute() {
        String s = this.getExpr(this._hour);
        if (Utils.isEmpty(s)) {
            return 0;
        }
        String hourStr = s.trim();
        int firstcolon = hourStr.indexOf(58);
        int secondcolon = hourStr.indexOf(58, firstcolon + 1);
        s = hourStr.substring(firstcolon + 1, secondcolon);
        return Integer.parseInt(s);
    }

    public int getSecond() {
        int firstcolon;
        int secondcolon;
        String s = this.getExpr(this._hour);
        if (Utils.isEmpty(s)) {
            return 0;
        }
        String hourStr = s.trim();
        if (Utils.isEmpty(s = hourStr.substring((secondcolon = hourStr.indexOf(58, (firstcolon = hourStr.indexOf(58)) + 1)) + 1))) {
            return 0;
        }
        return Integer.parseInt(s);
    }

    public int getDay() {
        String s = this.getExpr(this._day);
        if (Utils.isEmpty(s)) {
            return 0;
        }
        return Integer.parseInt(s.trim());
    }

    public int getMonth() {
        String s = this.getExpr(this._month);
        if (Utils.isEmpty(s)) {
            return -1;
        }
        String month = s.toLowerCase();
        char c = month.charAt(0);
        if (Character.isDigit(c)) {
            return Integer.parseInt(month) - 1;
        }
        switch (c) {
            case 'j': {
                if ("jan".equals(month)) {
                    return 0;
                }
                if ("jun".equals(month)) {
                    return 5;
                }
                return 6;
            }
            case 'f': {
                return 1;
            }
            case 'm': {
                if ("mar".equals(month)) {
                    return 2;
                }
                return 4;
            }
            case 'a': {
                if ("apr".equals(month)) {
                    return 3;
                }
                return 7;
            }
            case 's': {
                return 8;
            }
            case 'o': {
                return 9;
            }
            case 'n': {
                return 10;
            }
        }
        return 11;
    }

    public int getYear() {
        String s = this.getExpr(this._year);
        if (Utils.isEmpty(s)) {
            return 0;
        }
        return Integer.parseInt(s.trim());
    }

    public static void addRegexp(RegexpData re) {
        if (_lastMatched == null) {
            _lastMatched = re;
        }
        if (!_availableRegexp.contains(re)) {
            _availableRegexp.add(re);
        }
        _arrayRe = _availableRegexp.toArray(new RegexpData[0]);
    }

    public static RegexpData[] getRegexps() {
        return _arrayRe;
    }

    public static void updateList() {
        if (_availableRegexp.size() == 1) {
            return;
        }
        Collections.sort(_availableRegexp);
        _arrayRe = _availableRegexp.toArray(new RegexpData[0]);
    }

    public static Line getLine(String s) {
        int i;
        if (Utils.isComment(s)) {
            return null;
        }
        s = s.trim();
        if (_globalCounter % 1000 == 0) {
            RegexpData.updateList();
            _globalCounter = 1;
        }
        Line l = null;
        if (_lastMatched.match(s)) {
            RegexpData re = _lastMatched;
            l = Line.getLine(re.getHost(), re.getDay(), re.getMonth(), re.getYear(), re.getHour(), re.getMinute(), re.getSecond(), re.getRemoteIP(), re.getURI(), re.getReferer(), re.getAgent(), re.getStatus(), re.getSize(), re.getUser(), re.getTimeTaken(), re.getOffset(), re.getDateMSec());
            return l;
        }
        for (i = 0; i < _arrayRe.length && !_arrayRe[i].match(s); ++i) {
        }
        if (i < _arrayRe.length) {
            RegexpData re = _arrayRe[i];
            l = Line.getLine(re.getHost(), re.getDay(), re.getMonth(), re.getYear(), re.getHour(), re.getMinute(), re.getSecond(), re.getRemoteIP(), re.getURI(), re.getReferer(), re.getAgent(), re.getStatus(), re.getSize(), re.getUser(), re.getTimeTaken(), re.getOffset(), re.getDateMSec());
            _lastMatched = re;
        }
        return l;
    }
}

