/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.plugin.jboss;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.HashMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.util.StringUtil;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class JBossConfig {
    private static final Log log = LogFactory.getLog((String)JBossConfig.class.getName());
    private static final String NAMING_MBEAN = "jboss:service=Naming";
    private static final String BINDING_MBEAN = "jboss.system:service=ServiceBindingManager";
    private static final String WEBSERVER_MBEAN = "jboss.web:service=WebServer";
    private static HashMap cache = null;
    private File serviceXML;
    private File bindingXML;
    private String jnpPort;
    private String jnpPortBinding;
    private String jnpAddress;
    private String jnpAddressBinding;
    private String httpPort;
    private String serverBinding;
    private long lastModified;
    private long lastModifiedBinding;

    private JBossConfig(File serviceXML) {
        this.serviceXML = serviceXML;
        this.lastModified = this.serviceXML.lastModified();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized JBossConfig getConfig(File configXML) {
        JBossConfig cfg;
        if (cache == null) {
            cache = new HashMap();
        }
        if ((cfg = (JBossConfig)cache.get(configXML)) == null || cfg.hasChanged()) {
            if (cfg == null) {
                log.debug((Object)("Parsing unseen: " + configXML));
            } else {
                log.debug((Object)("Parsing modified: " + configXML));
            }
            cfg = new JBossConfig(configXML);
            cache.put(configXML, cfg);
            Document doc = null;
            try {
                doc = cfg.parse(cfg.serviceXML);
                cfg.findJnpPort(doc);
            }
            catch (IOException e) {
                log.error((Object)("Error parsing " + cfg.serviceXML), (Throwable)e);
            }
            finally {
                doc = null;
            }
        } else {
            log.debug((Object)("Unchanged: " + configXML));
        }
        return cfg;
    }

    private boolean hasChanged() {
        long lastModified = this.serviceXML.lastModified();
        if (lastModified != this.lastModified) {
            this.lastModified = lastModified;
            return true;
        }
        return this.bindingXML != null && (lastModified = this.bindingXML.lastModified()) != this.lastModifiedBinding;
    }

    public String getHttpPort() {
        return this.httpPort;
    }

    public String getJnpPort() {
        String port;
        String string = port = this.jnpPortBinding == null ? this.jnpPort : this.jnpPortBinding;
        if (port == null) {
            return "1099";
        }
        return port;
    }

    public String getJnpAddress() {
        String addr;
        String string = addr = this.jnpAddressBinding == null ? this.jnpAddress : this.jnpAddressBinding;
        if (addr == null || addr.equals("${jboss.bind.address}")) {
            return "127.0.0.1";
        }
        return addr;
    }

    private String getAttribute(Node node, String name) {
        NamedNodeMap attrs = node.getAttributes();
        if (attrs == null) {
            return null;
        }
        Node item = attrs.getNamedItem(name);
        if (item == null) {
            return null;
        }
        return item.getNodeValue();
    }

    private String getText(Node node) {
        return node.getFirstChild().getNodeValue().trim();
    }

    private static boolean hasValue(String val) {
        return val != null && val.length() != 0;
    }

    public File getJBossHome() {
        File home;
        for (home = this.serviceXML.getParentFile(); home != null; home = home.getParentFile()) {
            boolean isServer = home.getName().equals("server");
            if (!isServer) continue;
            break;
        }
        return home;
    }

    private boolean findJnpPortBinding(Document doc) {
        boolean foundPort = false;
        NodeList servers = doc.getDocumentElement().getElementsByTagName("server");
        for (int i = 0; i < servers.getLength(); ++i) {
            String name;
            Node server = servers.item(i);
            if (!server.hasAttributes() || !(name = this.getAttribute(server, "name")).equals(this.serverBinding)) continue;
            NodeList configs = server.getChildNodes();
            block1: for (int j = 0; j < configs.getLength(); ++j) {
                Node config = configs.item(j);
                if (!config.hasAttributes() || !"service-config".equals(config.getNodeName())) continue;
                name = this.getAttribute(config, "name");
                boolean isNaming = false;
                boolean isWebserver = false;
                isNaming = name.equals(NAMING_MBEAN);
                if (!isNaming && !(isWebserver = name.equals(WEBSERVER_MBEAN))) continue;
                NodeList bindings = config.getChildNodes();
                for (int k = 0; k < bindings.getLength(); ++k) {
                    Node binding = bindings.item(k);
                    if (!"binding".equals(binding.getNodeName())) continue;
                    if (!binding.hasAttributes()) continue block1;
                    String val = this.getAttribute(binding, "port");
                    log.debug((Object)(this.serverBinding + " " + name + "=" + val));
                    if (JBossConfig.hasValue(val)) {
                        if (isNaming) {
                            this.jnpPortBinding = val;
                            foundPort = true;
                        } else if (isWebserver) {
                            this.httpPort = val;
                        }
                    }
                    if (!JBossConfig.hasValue(val = this.getAttribute(binding, "host")) || !isNaming) continue block1;
                    this.jnpAddressBinding = val;
                    continue block1;
                }
            }
        }
        return foundPort;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean findJnpPortBinding(Node mbean) throws IOException {
        NodeList attrs = mbean.getChildNodes();
        for (int i = 0; i < attrs.getLength(); ++i) {
            Document bindingDoc;
            Node attr = attrs.item(i);
            if (!attr.hasAttributes()) continue;
            String attrName = this.getAttribute(attr, "name");
            if ("ServerName".equals(attrName)) {
                this.serverBinding = this.getText(attr);
                log.debug((Object)("ServerName=" + this.serverBinding));
                continue;
            }
            if (!"StoreURL".equals(attrName)) continue;
            String url = this.getText(attr);
            File home = this.getJBossHome();
            if (home != null) {
                log.debug((Object)("jboss.home.url=" + home));
                url = StringUtil.replace((String)url, (String)"${jboss.home.url}", (String)home.toString());
            }
            url = StringUtil.replace((String)url, (String)"${jboss.server.config.url}", (String)this.serviceXML.getParentFile().toString());
            File bindings = new File(url);
            boolean exists = bindings.exists();
            log.debug((Object)("StoreURL exists=" + exists + " (" + url + ")"));
            if (!exists) continue;
            this.bindingXML = bindings;
            this.lastModifiedBinding = bindings.lastModified();
            try {
                bindingDoc = this.parse(bindings);
                boolean bl = this.findJnpPortBinding(bindingDoc);
                return bl;
            }
            finally {
                bindingDoc = null;
            }
        }
        return false;
    }

    private boolean findJnpPort(Node mbean) {
        NodeList attrs = mbean.getChildNodes();
        boolean foundPort = false;
        for (int i = 0; i < attrs.getLength(); ++i) {
            String val;
            Node attr = attrs.item(i);
            if (!attr.hasAttributes()) continue;
            String attrName = this.getAttribute(attr, "name");
            if ("Port".equals(attrName)) {
                val = this.getText(attr);
                if (!JBossConfig.hasValue(val)) continue;
                this.jnpPort = val;
                foundPort = true;
                continue;
            }
            if (!"BindAddress".equals(attrName) || !JBossConfig.hasValue(val = this.getText(attr))) continue;
            this.jnpAddress = val;
        }
        return foundPort;
    }

    private void findJnpPort(Document doc) throws IOException {
        NodeList mbeans = doc.getDocumentElement().getElementsByTagName("mbean");
        for (int i = 0; i < mbeans.getLength(); ++i) {
            Node mbean = mbeans.item(i);
            if (!mbean.hasAttributes()) continue;
            String name = this.getAttribute(mbean, "name");
            if (NAMING_MBEAN.equals(name)) {
                this.findJnpPort(mbean);
                log.debug((Object)("jboss:service=Naming port=" + this.jnpPort + ", host=" + this.jnpAddress));
                continue;
            }
            if (!BINDING_MBEAN.equals(name)) continue;
            this.findJnpPortBinding(mbean);
            log.debug((Object)("jboss.system:service=ServiceBindingManager port=" + this.jnpPortBinding + ", host=" + this.jnpAddressBinding));
        }
        log.debug((Object)("JNP port=" + this.getJnpPort()));
    }

    private Document parse(File file) throws IOException {
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(file);
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder parser = factory.newDocumentBuilder();
            Document document = parser.parse(new InputSource(fis));
            return document;
        }
        catch (ParserConfigurationException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
        catch (SAXException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e) {}
            }
        }
    }

    public static void main(String[] args) throws Exception {
        if (args.length != 1) {
            System.out.println("Usage: <config file>");
            System.exit(1);
        }
        JBossConfig cfg = JBossConfig.getConfig(new File(args[0]));
        System.out.println("JNP url: jnp://" + cfg.getJnpAddress() + ":" + cfg.getJnpPort());
        if (cfg.getHttpPort() != null) {
            System.out.println("HTTP port: " + cfg.getHttpPort());
        }
    }
}

