/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.plugin.jboss;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.hq.product.PluginException;

public class MBeanUtil {
    private static Log log = LogFactory.getLog(MBeanUtil.class);
    private static Map converters = new HashMap();

    public static void addConverter(Class type, Converter converter) {
        converters.put(type.getName(), converter);
    }

    public static void addConverter(Class type, ListConverter converter) {
        converters.put(type.getName(), converter);
    }

    private static void addConverter(Class addType, Class fromType) {
        converters.put(addType.getName(), converters.get(fromType.getName()));
    }

    private static IllegalArgumentException invalid(String param, Exception e) {
        return new IllegalArgumentException("'" + param + "': " + e.getMessage());
    }

    private static void initConverters() {
        MBeanUtil.addConverter(Object.class, new Converter(){

            public Object convert(String param) {
                return param;
            }
        });
        MBeanUtil.addConverter(Short.class, new Converter(){

            public Object convert(String param) {
                return Short.valueOf(param);
            }
        });
        MBeanUtil.addConverter(Integer.class, new Converter(){

            public Object convert(String param) {
                return Integer.valueOf(param);
            }
        });
        MBeanUtil.addConverter(Long.class, new Converter(){

            public Object convert(String param) {
                return Long.valueOf(param);
            }
        });
        MBeanUtil.addConverter(Double.class, new Converter(){

            public Object convert(String param) {
                return Double.valueOf(param);
            }
        });
        MBeanUtil.addConverter(Boolean.class, new Converter(){

            public Object convert(String param) {
                return Boolean.valueOf(param);
            }
        });
        MBeanUtil.addConverter(File.class, new Converter(){

            public Object convert(String param) {
                return new File(param);
            }
        });
        MBeanUtil.addConverter(URL.class, new Converter(){

            public Object convert(String param) {
                try {
                    return new URL(param);
                }
                catch (MalformedURLException e) {
                    throw MBeanUtil.invalid(param, e);
                }
            }
        });
        MBeanUtil.addConverter(ObjectName.class, new Converter(){

            public Object convert(String param) {
                try {
                    return new ObjectName(param);
                }
                catch (MalformedObjectNameException e) {
                    throw MBeanUtil.invalid(param, e);
                }
            }
        });
        MBeanUtil.addConverter(List.class, new ListConverter(){

            public Object convert(String[] params) {
                return Arrays.asList(params);
            }
        });
        MBeanUtil.addConverter(String[].class, new ListConverter(){

            public Object convert(String[] params) {
                return params;
            }
        });
        Class[][] aliases = new Class[][]{{String.class, Object.class}, {Short.TYPE, Short.class}, {Integer.TYPE, Integer.class}, {Long.TYPE, Long.class}, {Double.TYPE, Double.class}, {Boolean.TYPE, Boolean.class}};
        for (int i = 0; i < aliases.length; ++i) {
            MBeanUtil.addConverter(aliases[i][0], aliases[i][1]);
        }
    }

    private static Object getConverter(String type) {
        Object converter = converters.get(type);
        if (converter == null) {
            converter = converters.get(Object.class.getName());
        }
        return converter;
    }

    private static boolean hasConverter(String type) {
        return converters.get(type) != null;
    }

    private static Object convert(String type, String param) {
        return ((Converter)MBeanUtil.getConverter(type)).convert(param);
    }

    private static Object convert(String type, String[] params) {
        return ((ListConverter)MBeanUtil.getConverter(type)).convert(params);
    }

    private static boolean isListType(String type) {
        return MBeanUtil.getConverter(type) instanceof ListConverter;
    }

    private static PluginException invalidParams(String method, HashMap sigs, Object[] args) {
        String msg = "operation '" + method + "' takes " + sigs.keySet() + " arguments, [" + args.length + "] given";
        return new PluginException(msg);
    }

    public static OperationParams getAttributeParams(MBeanInfo info, String method, Object[] args) throws PluginException {
        if (method.startsWith("set")) {
            method = method.substring(3);
        }
        MBeanAttributeInfo[] attrs = info.getAttributes();
        for (int i = 0; i < attrs.length; ++i) {
            Object value;
            MBeanAttributeInfo attr = attrs[i];
            if (!attr.getName().equals(method)) continue;
            if (!attr.isWritable()) {
                throw new PluginException("Attribute '" + method + "' is not writable");
            }
            String sig = attr.getType();
            if (!MBeanUtil.hasConverter(sig)) {
                String msg = "Cannot convert String argument to " + sig;
                throw new PluginException(msg);
            }
            if (args.length != 1) {
                String msg = "setAttribute(" + method + ") takes [1] argument, [" + args.length + "] given";
                throw new PluginException(msg);
            }
            OperationParams params = new OperationParams();
            try {
                value = MBeanUtil.convert(sig, (String)args[0]);
            }
            catch (Exception e) {
                String msg = "Exception converting param '" + args[0] + "' to type '" + sig + "'";
                throw new PluginException(msg + ": " + e);
            }
            params.arguments = new Object[]{value};
            params.isAttribute = true;
            return params;
        }
        return null;
    }

    public static OperationParams getOperationParams(MBeanInfo info, String method, Object[] args) throws PluginException {
        Object o;
        boolean isDebug = log.isDebugEnabled();
        MBeanOperationInfo[] ops = info.getOperations();
        MBeanParameterInfo[] pinfo = null;
        HashMap<Integer, MBeanParameterInfo[]> sigs = new HashMap<Integer, MBeanParameterInfo[]>();
        if (isDebug) {
            log.debug((Object)("Converting params for: " + method + Arrays.asList(args)));
        }
        for (int i = 0; i < ops.length; ++i) {
            if (!ops[i].getName().equals(method)) continue;
            pinfo = ops[i].getSignature();
            sigs.put(new Integer(pinfo.length), pinfo);
        }
        if (sigs.size() == 0) {
            OperationParams op = MBeanUtil.getAttributeParams(info, method, args);
            if (op != null) {
                return op;
            }
            String msg = "No MBean Operation or Attribute Info found for: " + method;
            throw new PluginException(msg);
        }
        if (sigs.size() > 1 && (o = sigs.get(new Integer(args.length))) != null) {
            pinfo = (MBeanParameterInfo[])o;
        }
        int len = pinfo.length;
        int nargs = args.length;
        String[] signature = new String[len];
        ArrayList<Object> arguments = new ArrayList<Object>();
        for (int i = 0; i < len; ++i) {
            String sig;
            signature[i] = sig = pinfo[i].getType();
            if (!MBeanUtil.hasConverter(sig)) {
                String msg = "Cannot convert String argument to " + sig;
                throw new PluginException(msg);
            }
            if (i >= args.length) {
                throw MBeanUtil.invalidParams(method, sigs, args);
            }
            if (MBeanUtil.isListType(sig)) {
                String[] listArgs;
                if (i != 0) {
                    int diff = args.length - i;
                    listArgs = new String[diff];
                    System.arraycopy(args, i, listArgs, 0, diff);
                } else {
                    listArgs = (String[])args;
                }
                nargs -= listArgs.length;
                arguments.add(MBeanUtil.convert(sig, listArgs));
                if (i != len - 1) {
                    String msg = sig + " must be the last argument";
                    throw new PluginException(msg);
                }
            } else {
                --nargs;
                try {
                    arguments.add(MBeanUtil.convert(sig, (String)args[i]));
                }
                catch (Exception e) {
                    String msg = "Exception converting param[" + i + "] '" + args[i] + "' to type '" + sig + "'";
                    throw new PluginException(msg + ": " + e);
                }
            }
            if (!isDebug) continue;
            log.debug((Object)(method + "() arg " + i + "=" + arguments.get(i) + ", type=" + sig));
        }
        if (nargs != 0) {
            throw MBeanUtil.invalidParams(method, sigs, args);
        }
        OperationParams params = new OperationParams();
        params.signature = signature;
        params.arguments = arguments.toArray();
        return params;
    }

    static {
        MBeanUtil.initConverters();
    }

    public static class OperationParams {
        public Object[] arguments;
        public String[] signature;
        public boolean isAttribute = false;
    }

    public static interface ListConverter {
        public Object convert(String[] var1);
    }

    public static interface Converter {
        public Object convert(String var1);
    }
}

