/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.plugin.jboss.jmx;

import java.io.IOException;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import org.hyperic.hq.product.PluginException;
import org.hyperic.hq.product.ServerDetector;

public abstract class JBossQuery {
    public static final String PROP_OBJECT_NAME = "OBJECT_NAME";
    public static final String PROP_ATTRIBUTE_NAME = "ATTRIBUTE_NAME";
    protected static final Properties EMPTY_PROPERTIES = new Properties();
    private Map attrs = new HashMap();
    private String name;
    private String url = null;
    private ServerDetector detector = null;

    public void initialize() {
    }

    public abstract void getAttributes(MBeanServerConnection var1) throws PluginException;

    public void setURL(String url) {
        this.url = url;
    }

    public String getURL() {
        if (this.url == null) {
            return this.getParent().getURL();
        }
        return this.url;
    }

    public void setServerDetector(ServerDetector detector) {
        this.detector = detector;
    }

    public ServerDetector getServerDetector() {
        if (this.detector == null) {
            return this.getParent().getServerDetector();
        }
        return this.detector;
    }

    public void getAttributes(MBeanServerConnection mServer, ObjectName name, String[] attrs) throws PluginException {
        AttributeList mBeanAttrs;
        if (attrs.length == 0) {
            return;
        }
        try {
            mBeanAttrs = mServer.getAttributes(name, attrs);
        }
        catch (RemoteException e) {
            throw new PluginException("Cannot connect to server", (Throwable)e);
        }
        catch (InstanceNotFoundException e) {
            throw new PluginException("Cannot find MBean [" + name + "]", (Throwable)e);
        }
        catch (ReflectionException e) {
            throw new PluginException("MBean reflection exception", (Throwable)e);
        }
        catch (IOException e) {
            throw new PluginException("Cannot connect to server", (Throwable)e);
        }
        for (Attribute attr : mBeanAttrs) {
            Object value = attr.getValue();
            if (value == null) continue;
            this.setAttribute(attr.getName(), value.toString());
        }
    }

    public String getAttribute(String name) {
        return (String)this.attrs.get(name);
    }

    public String getAttribute(String name, String defval) {
        String attr = this.getAttribute(name);
        if (attr == null) {
            return defval;
        }
        return attr;
    }

    public void setAttribute(String name, String val) {
        this.attrs.put(name, val);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public abstract String getQualifiedName();

    public abstract String getResourceType();

    public abstract String getIdentifier();

    public JBossQuery getParent() {
        return null;
    }

    public boolean hasControl() {
        return true;
    }

    public Properties getResourceConfig() {
        return EMPTY_PROPERTIES;
    }

    public Properties getControlConfig() {
        return EMPTY_PROPERTIES;
    }

    public Properties getCustomProperties() {
        return EMPTY_PROPERTIES;
    }
}

