/*
 * Decompiled with CFR 0.152.
 */
package com.springsource.hq.plugin.tcserver.plugin;

import com.springsource.hq.plugin.tcserver.plugin.ControlCommand;
import com.springsource.hq.plugin.tcserver.plugin.ControlCommandConverter;
import java.io.File;
import java.util.ArrayList;

final class NonRootAgentControlCommandConverter
implements ControlCommandConverter {
    private static final String SUDO_NON_INTERACTIVE_SWITCH = "-n";
    private static final String SUDO_USER_SWITCH = "-u";
    private static final File CONTROL_PROGRAM = new File("/usr/bin/sudo");
    private final String instanceUserName;

    NonRootAgentControlCommandConverter(String instanceUserName) {
        this.instanceUserName = instanceUserName;
    }

    public ControlCommand convert(ControlCommand controlCommand) {
        ArrayList<String> convertedArguments = new ArrayList<String>();
        convertedArguments.add(SUDO_NON_INTERACTIVE_SWITCH);
        convertedArguments.add(SUDO_USER_SWITCH);
        convertedArguments.add(this.instanceUserName);
        convertedArguments.add(controlCommand.getControlProgram().getAbsolutePath());
        convertedArguments.addAll(controlCommand.getArguments());
        return new ControlCommand(CONTROL_PROGRAM, convertedArguments);
    }
}

