/*
 * Decompiled with CFR 0.152.
 */
package com.springsource.hq.plugin.tcserver.plugin;

import com.springsource.hq.plugin.tcserver.plugin.appmgmt.ApplicationManager;
import com.springsource.hq.plugin.tcserver.plugin.appmgmt.FileOwnershipChanger;
import com.springsource.hq.plugin.tcserver.plugin.appmgmt.FilePermissionsChanger;
import com.springsource.hq.plugin.tcserver.plugin.appmgmt.ScriptingApplicationManager;
import com.springsource.hq.plugin.tcserver.plugin.appmgmt.StandardFileOwnershipChangerFactory;
import com.springsource.hq.plugin.tcserver.plugin.appmgmt.StandardFilePermissionsChangerFactory;
import com.springsource.hq.plugin.tcserver.plugin.appmgmt.TomcatJmxApplicationManager;
import com.springsource.hq.plugin.tcserver.plugin.appmgmt.TomcatJmxScriptingApplicationManager;
import com.springsource.hq.plugin.tcserver.plugin.serverconfig.DefaultServerConfigManager;
import com.springsource.hq.plugin.tcserver.plugin.serverconfig.ServerConfigManager;
import com.springsource.hq.plugin.tcserver.plugin.wrapper.MxUtilJmxUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.hq.product.LiveDataPlugin;
import org.hyperic.hq.product.PluginException;
import org.hyperic.hq.product.PluginManager;
import org.hyperic.hq.product.ProductPluginManager;
import org.hyperic.util.config.ConfigResponse;

public class TomcatLiveDataPlugin
extends LiveDataPlugin {
    private static final String CMD_DEPLOY = "deployApp";
    private static final String CMD_RELOAD_APPLICATIONS = "reloadApplications";
    private static final String CMD_START_APPLICATIONS = "startApplications";
    private static final String CMD_STOP_APPLICATIONS = "stopApplications";
    private static final String CMD_UNDEPLOY_APPLICATIONS = "undeployApplications";
    private static final String CMD_DEPLOY_APPLICATION = "deployApplication";
    private static final String CMD_LIST_APPLICATIONS = "listApplications";
    private static final String CMD_RELOAD = "reloadApps";
    private static final String CMD_START = "startApps";
    private static final String CMD_STOP = "stopApps";
    private static final String CMD_UNDEPLOY = "undeployApps";
    private static final String CMD_LIST = "listApps";
    private static final String CMD_GET_CONFIG = "getConfiguration";
    private static final String CMD_SAVE_CONFIG = "saveConfiguration";
    private static final String CMD_PREPARE_FILE = "prepareFile";
    private static final String CMD_PUT_FILE = "putFile";
    private static final String CMD_GET_FILE = "getFile";
    private static final String CMD_COPY_FILE = "copyFile";
    private static final String CMD_FILE_EXISTS = "fileExists";
    private static final String CMD_PUT_JVM_OPTIONS = "putJvmOptions";
    private static final String CMD_GET_JVM_OPTIONS = "getJvmOptions";
    private static final String CMD_GET_TEMP_DIR = "getTemporaryWebAppDirectory";
    private static final String CMD_GET_SERVICE_HOST_MAPPINGS = "getServiceHostMappings";
    private static final String CMD_REMOVE_TEMP_WAR_FILE = "removeTemporaryWarFile";
    private static final String CMD_GET_APPBASE = "getAppBase";
    private static final String CMD_REVERT_PREVIOUS_CONFIGURATION = "revertToPreviousConfiguration";
    private static final String CMD_CHANGE_FILE_PERMISSIONS_AND_OWNERSHIP = "changeFilePermissionsAndOwnership";
    private static final String CONFIG_FILE_LOCATION = "FILE_LOCATION";
    private static final List<String> COMMANDS = new ArrayList<String>();
    private ApplicationManager applicationManager;
    private ScriptingApplicationManager scriptingApplicationManager;
    private ServerConfigManager serverConfigManager;
    private volatile FileOwnershipChanger fileOwnershipChanger;
    private volatile FilePermissionsChanger filePermissionsChanger;
    private final Log logger = LogFactory.getLog(TomcatLiveDataPlugin.class);

    static {
        COMMANDS.add(CMD_DEPLOY);
        COMMANDS.add(CMD_GET_TEMP_DIR);
        COMMANDS.add(CMD_LIST);
        COMMANDS.add(CMD_UNDEPLOY);
        COMMANDS.add(CMD_STOP);
        COMMANDS.add(CMD_START);
        COMMANDS.add(CMD_RELOAD);
        COMMANDS.add(CMD_GET_CONFIG);
        COMMANDS.add(CMD_SAVE_CONFIG);
        COMMANDS.add(CMD_PUT_FILE);
        COMMANDS.add(CMD_PREPARE_FILE);
        COMMANDS.add(CMD_GET_FILE);
        COMMANDS.add(CMD_COPY_FILE);
        COMMANDS.add(CMD_FILE_EXISTS);
        COMMANDS.add(CMD_PUT_JVM_OPTIONS);
        COMMANDS.add(CMD_GET_JVM_OPTIONS);
        COMMANDS.add(CMD_GET_SERVICE_HOST_MAPPINGS);
        COMMANDS.add(CMD_LIST_APPLICATIONS);
        COMMANDS.add(CMD_RELOAD_APPLICATIONS);
        COMMANDS.add(CMD_START_APPLICATIONS);
        COMMANDS.add(CMD_STOP_APPLICATIONS);
        COMMANDS.add(CMD_UNDEPLOY_APPLICATIONS);
        COMMANDS.add(CMD_DEPLOY_APPLICATION);
        COMMANDS.add(CMD_REMOVE_TEMP_WAR_FILE);
        COMMANDS.add(CMD_GET_APPBASE);
        COMMANDS.add(CMD_REVERT_PREVIOUS_CONFIGURATION);
        COMMANDS.add(CMD_CHANGE_FILE_PERMISSIONS_AND_OWNERSHIP);
    }

    public TomcatLiveDataPlugin() {
    }

    TomcatLiveDataPlugin(ApplicationManager applicationManager, ServerConfigManager serverConfigManager) {
        this.applicationManager = applicationManager;
        this.serverConfigManager = serverConfigManager;
    }

    public void init(PluginManager pluginManager) throws PluginException {
        super.init(pluginManager);
        if (((ProductPluginManager)pluginManager.getParent()).isClient()) {
            MxUtilJmxUtils jmxUtils = new MxUtilJmxUtils();
            FilePermissionsChanger filePermissionsChanger = new StandardFilePermissionsChangerFactory().getFilePermissionsChanger();
            FileOwnershipChanger fileOwnershipChanger = new StandardFileOwnershipChangerFactory().getFileOwnershipChanger();
            this.applicationManager = new TomcatJmxApplicationManager(jmxUtils, filePermissionsChanger, fileOwnershipChanger);
            this.scriptingApplicationManager = new TomcatJmxScriptingApplicationManager(jmxUtils, filePermissionsChanger, fileOwnershipChanger);
            this.serverConfigManager = new DefaultServerConfigManager();
            this.filePermissionsChanger = filePermissionsChanger;
            this.fileOwnershipChanger = fileOwnershipChanger;
        }
    }

    public String[] getCommands() {
        return COMMANDS.toArray(new String[COMMANDS.size()]);
    }

    public Object getData(String command, ConfigResponse config) throws PluginException {
        this.logger.debug((Object)("COMMAND = " + command));
        this.logger.debug((Object)("CONFIG = " + config));
        if (CMD_LIST.equals(command)) {
            return this.applicationManager.list(config);
        }
        if (CMD_LIST_APPLICATIONS.equals(command)) {
            return this.scriptingApplicationManager.list(config);
        }
        if (CMD_START_APPLICATIONS.equals(command)) {
            return this.scriptingApplicationManager.start(config);
        }
        if (CMD_STOP_APPLICATIONS.equals(command)) {
            return this.scriptingApplicationManager.stop(config);
        }
        if (CMD_RELOAD_APPLICATIONS.equals(command)) {
            return this.scriptingApplicationManager.reload(config);
        }
        if (CMD_UNDEPLOY_APPLICATIONS.equals(command)) {
            return this.scriptingApplicationManager.undeploy(config);
        }
        if (CMD_DEPLOY_APPLICATION.equals(command)) {
            return this.scriptingApplicationManager.deploy(config);
        }
        if (CMD_GET_SERVICE_HOST_MAPPINGS.equals(command)) {
            return this.applicationManager.getServiceHostMappings(config);
        }
        if (CMD_GET_TEMP_DIR.equals(command)) {
            return this.getTemporaryWebAppDirectory();
        }
        if (CMD_DEPLOY.equals(command)) {
            HashMap<String, Object> resultMap = new HashMap<String, Object>();
            resultMap.put(CMD_DEPLOY, this.applicationManager.deploy(config));
            return resultMap;
        }
        if (CMD_UNDEPLOY.equals(command)) {
            return this.applicationManager.undeploy(config);
        }
        if (CMD_START.equals(command)) {
            return this.applicationManager.start(config);
        }
        if (CMD_STOP.equals(command)) {
            return this.applicationManager.stop(config);
        }
        if (CMD_RELOAD.equals(command)) {
            return this.applicationManager.reload(config);
        }
        if (CMD_GET_CONFIG.equals(command)) {
            return this.serverConfigManager.getConfiguration(config);
        }
        if (CMD_SAVE_CONFIG.equals(command)) {
            this.serverConfigManager.saveConfiguration(config);
            return null;
        }
        if (CMD_PUT_FILE.equals(command)) {
            this.serverConfigManager.putFile(config);
            return null;
        }
        if (CMD_PREPARE_FILE.equals(command)) {
            this.serverConfigManager.prepareFile(config);
            return null;
        }
        if (CMD_GET_FILE.equals(command)) {
            return this.serverConfigManager.getFile(config);
        }
        if (CMD_COPY_FILE.equals(command)) {
            this.serverConfigManager.copyFile(config);
            return null;
        }
        if (CMD_FILE_EXISTS.equals(command)) {
            return this.serverConfigManager.fileExists(config);
        }
        if (CMD_PUT_JVM_OPTIONS.equals(command)) {
            this.serverConfigManager.putJvmOpts(config);
            return null;
        }
        if (CMD_GET_JVM_OPTIONS.equals(command)) {
            return this.serverConfigManager.getJvmOpts(config);
        }
        if (CMD_REMOVE_TEMP_WAR_FILE.equals(command)) {
            this.applicationManager.removeTemporaryWarFile(config);
            return null;
        }
        if (CMD_GET_APPBASE.equals(command)) {
            return this.applicationManager.getAppBase(config);
        }
        if (CMD_REVERT_PREVIOUS_CONFIGURATION.equals(command)) {
            this.serverConfigManager.revertToPreviousConfiguration(config);
            return null;
        }
        if (CMD_CHANGE_FILE_PERMISSIONS_AND_OWNERSHIP.equals(command)) {
            this.changeFilePermissionsAndOwnership(config);
            return null;
        }
        String exceptionMessage = "Unknown command: " + command;
        throw new PluginException(exceptionMessage);
    }

    private void changeFilePermissionsAndOwnership(ConfigResponse configResponse) throws PluginException {
        File file = new File(configResponse.getValue(CONFIG_FILE_LOCATION));
        this.filePermissionsChanger.changeFilePermissions(file);
        this.fileOwnershipChanger.changeFileOwnership(file, configResponse.getValue("process.username"), configResponse.getValue("process.group"));
    }

    private String getTemporaryWebAppDirectory() {
        String tempDir = System.getProperty("java.io.tmpdir");
        String userDir = System.getProperty("user.dir");
        userDir = userDir.replace("\\", "/");
        if (tempDir.startsWith(".") && !tempDir.startsWith("..")) {
            tempDir = tempDir.replaceFirst("\\.", userDir);
        } else if (tempDir.startsWith("..")) {
            int index = userDir.lastIndexOf("/");
            if (index == 0) {
                index = 0;
            } else if (index == userDir.length()) {
                index = userDir.substring(0, index - 1).lastIndexOf("/");
            }
            userDir = userDir.substring(0, index);
            tempDir = tempDir.replaceFirst("..", userDir);
        }
        return tempDir.replace("\\", "/");
    }
}

