/*
 * Decompiled with CFR 0.152.
 */
package com.springsource.hq.plugin.tcserver.plugin;

import com.springsource.hq.plugin.tcserver.plugin.ControlCommand;
import com.springsource.hq.plugin.tcserver.plugin.ControlCommandConverterFactory;
import com.springsource.hq.plugin.tcserver.plugin.StandardControlCommandConverterFactory;
import java.io.File;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.hq.product.Metric;
import org.hyperic.hq.product.PluginException;
import org.hyperic.hq.product.jmx.MxServerControlPlugin;
import org.hyperic.sigar.Sigar;
import org.hyperic.sigar.SigarException;
import org.hyperic.sigar.ptql.ProcessFinder;
import org.hyperic.util.config.ConfigResponse;

public class TomcatServerControlPlugin
extends MxServerControlPlugin {
    private static final int DEFAULT_TIMEOUT = 60;
    public static final String STATE_ERROR_MULTIPLE_PROCESS = "error-multiple-process";
    public static final String STATE_ERROR_FINDING_PROCESS = "error-finding-process";
    private final Log logger = LogFactory.getLog(TomcatServerControlPlugin.class);
    private ControlCommandConverterFactory controlCommandConverterFactory = new StandardControlCommandConverterFactory();
    private volatile Sigar sigar;

    public TomcatServerControlPlugin() throws PluginException {
        this.setTimeout(60);
    }

    public void configure(ConfigResponse config) throws PluginException {
        this.sigar = new Sigar();
        super.configure(config);
    }

    public void doAction(String action, String[] args) throws PluginException {
        if ("start".equals(action)) {
            int status = this.startWithArgs(args);
            this.setResult(status);
        } else if ("restart".equals(action)) {
            int status = this.restartWithArgs(args);
            this.setResult(status);
        } else if ("stop".equals(action)) {
            int status = this.stopWithArgs(args);
            this.setResult(status);
        } else {
            super.doAction(action, args);
        }
    }

    private int doMyCommand(String action, String[] args) throws PluginException {
        ArrayList<String> arguments = new ArrayList<String>();
        File instanceDirectory = this.getInstanceDirectory();
        arguments.add(instanceDirectory.getName());
        arguments.add(action);
        String[] stringArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            String arg = stringArray[n2];
            arguments.add(arg);
            ++n2;
        }
        arguments.add("-n");
        arguments.add(instanceDirectory.getParentFile().getAbsolutePath());
        ControlCommand controlCommand = this.controlCommandConverterFactory.getControlCommandConverter(this.getConfig("process.username")).convert(new ControlCommand(new File(this.getControlProgram()), arguments));
        String[] argumentArray = controlCommand.getArguments().toArray(new String[controlCommand.getArguments().size()]);
        return super.doCommand(controlCommand.getControlProgram().getAbsolutePath(), argumentArray);
    }

    private File getInstanceDirectory() {
        return new File(this.getConfig("catalina.base"));
    }

    private int getPid() {
        try {
            String ptql = Metric.decode((String)Metric.translate((String)this.config.getValue("ptql"), (ConfigResponse)this.config));
            long[] pids = ProcessFinder.find((Sigar)this.sigar, (String)ptql);
            if (pids.length == 1) {
                return (int)pids[0];
            }
            if (pids.length > 1) {
                return -2;
            }
        }
        catch (SigarException sigarException) {
            return -3;
        }
        return -1;
    }

    protected String waitForState(String wantedState) {
        int timeout = this.getTimeoutMillis();
        long timeStart = System.currentTimeMillis();
        String state = this.detectState();
        if (!state.equals(STATE_ERROR_MULTIPLE_PROCESS) && !state.equals(STATE_ERROR_FINDING_PROCESS)) {
            while (!state.equals(wantedState) && System.currentTimeMillis() - timeStart < (long)timeout) {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {}
                state = this.detectState();
            }
        }
        return state;
    }

    protected String detectState() {
        String state = "unknown";
        int pid = this.getPid();
        if (pid >= 0) {
            state = "started";
        } else if (pid == -1) {
            state = "stopped";
        } else if (pid == -2) {
            state = STATE_ERROR_MULTIPLE_PROCESS;
        } else if (pid == -3) {
            state = STATE_ERROR_FINDING_PROCESS;
        }
        return state;
    }

    private int kill(int signal) {
        int pid = this.getPid();
        if (pid >= 0) {
            try {
                this.sigar.kill((long)pid, signal);
                if (this.waitForState("stopped").equals("stopped")) {
                    return 0;
                }
            }
            catch (SigarException e) {
                this.logger.warn((Object)("Error terminating tc Runtime process.  Cause: " + e.getMessage()));
            }
            this.setMessage("Stop failed.  Unable to kill process");
        }
        return -1;
    }

    private int restartWithArgs(String[] args) throws PluginException {
        int stopStatus = this.stopWithArgs(args);
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {}
        int startStatus = this.startWithArgs(args);
        if (startStatus == 0 && stopStatus == 0) {
            this.setMessage("Restart executed successfully");
            return 0;
        }
        if (startStatus != 0 && stopStatus != 0) {
            if (this.getMessage() != null) {
                this.setMessage("Restart failed.  " + this.getMessage());
            } else {
                this.setMessage("Restart failed");
            }
        } else if (startStatus == 0 && stopStatus != 0) {
            if (this.getMessage() != null) {
                this.setMessage("Stop failed but start succeeded.  " + this.getMessage());
            } else {
                this.setMessage("Stop failed but start succeeded");
            }
        } else if (startStatus != 0 && stopStatus == 0) {
            if (this.getMessage() != null) {
                this.setMessage("Stop succeeded but start failed.  " + this.getMessage());
            } else {
                this.setMessage("Stop succeeded but start failed");
            }
        }
        return -1;
    }

    public void shutdown() throws PluginException {
        super.shutdown();
        if (this.sigar != null) {
            this.sigar.close();
        }
    }

    public int startWithArgs(String[] args) throws PluginException {
        int status = this.doMyCommand("start", args);
        if (status == -1) {
            return status;
        }
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException interruptedException) {
            this.logger.debug((Object)"Interrupted while waiting for tc Runtime to start.  The start operation may report a false success.");
        }
        String state = this.waitForState("started");
        if (state.equals(STATE_ERROR_FINDING_PROCESS)) {
            this.setMessage("Unable to determine process ID for tc Runtime instance prior to start operation. Cannot verify that start executed correctly");
            return -1;
        }
        if (state.equals(STATE_ERROR_MULTIPLE_PROCESS)) {
            this.setMessage("Multiple Process IDs found for installpath: " + this.config.getValue("installpath") + ".  Cannot verify that start operation executed correctly.");
            return -1;
        }
        if (!state.equals("started")) {
            this.setMessage("Unable to find Process ID of tc Runtime instance.  If instance is running, try increasing control timeout.");
            return -1;
        }
        this.setMessage("Start executed successfully");
        return 0;
    }

    private int stopWithArgs(String[] args) throws PluginException {
        int sig;
        if (this.detectState().equals("stopped")) {
            this.setMessage("Stop executed successfully");
            return 0;
        }
        int status = this.doMyCommand("stop", args);
        if (status == 0) {
            String state = this.waitForState("stopped");
            if (state.equals("stopped")) {
                this.setMessage("Stop executed successfully");
                return 0;
            }
            if (state.equals(STATE_ERROR_FINDING_PROCESS)) {
                this.setMessage("Unable to determine process ID for tc Runtime instance prior to stop operation. Cannot verify that stop executed correctly");
                return -1;
            }
            if (state.equals(STATE_ERROR_MULTIPLE_PROCESS)) {
                this.setMessage("Multiple Process IDs found for installpath: " + this.config.getValue("installpath") + ".  Cannot verify that stop operation executed correctly.");
                return -1;
            }
        }
        if (this.kill(sig = Sigar.getSigNum((String)"TERM")) == -1) {
            return this.kill(9);
        }
        this.setMessage("Stop executed successfully");
        return 0;
    }
}

