/*
 * Decompiled with CFR 0.152.
 */
package com.springsource.hq.plugin.tcserver.plugin.appmgmt;

import com.springsource.hq.plugin.tcserver.plugin.appmgmt.domain.Application;
import com.springsource.hq.plugin.tcserver.util.application.ApplicationUtils;
import com.springsource.hq.plugin.tcserver.util.tomcat.TomcatNameUtils;

final class ObjectNameUtils {
    private ObjectNameUtils() {
    }

    static String getManagerMBeanObjectNameForApplication(String host, Application application, boolean tomcat7) {
        String applicationIdentifier = TomcatNameUtils.convertNameToPath((String)application.getName());
        if (applicationIdentifier.equals("")) {
            applicationIdentifier = "/";
        } else if (!applicationIdentifier.startsWith("/")) {
            applicationIdentifier = "/" + applicationIdentifier;
        }
        if (tomcat7 && application.getVersion() > 0) {
            applicationIdentifier = String.valueOf(applicationIdentifier) + "##" + ApplicationUtils.convertVersionToPaddedString((int)application.getVersion());
        }
        String pathOrContext = tomcat7 ? "context" : "path";
        return "Catalina:type=Manager," + pathOrContext + "=" + applicationIdentifier + ",host=" + host;
    }
}

