/*
 * Decompiled with CFR 0.152.
 */
package com.springsource.hq.plugin.tcserver.plugin.serverconfig;

import com.springsource.hq.plugin.tcserver.plugin.serverconfig.FileUtilityException;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileUtility {
    private static final String BACKUP_SUB_DIR_FORMAT = "yyyy-MM-dd_HH-mm-ss";
    private static final Log LOGGER = LogFactory.getLog(FileUtility.class);

    public String copyBackupFile(String baseDirectory, String fromBaseDirFilePath) throws IOException {
        String fromBaseDir = "";
        String filePath = "";
        String p = fromBaseDirFilePath.replace("\\", "/");
        if (p != null && p.contains("/")) {
            int index = p.lastIndexOf("/");
            fromBaseDir = p.substring(0, index);
            filePath = p.substring(index + 1, p.length());
        }
        return this.copyBackupFile(baseDirectory, fromBaseDir, filePath, new Date());
    }

    public String copyBackupFile(String baseDirectory, String fromBaseDir, String sourceFileName, Date date) throws IOException {
        String separator = System.getProperty("file.separator");
        StringBuilder src = new StringBuilder(baseDirectory);
        src.append(separator).append(fromBaseDir).append(separator).append(sourceFileName);
        String sourceFilePath = src.toString();
        StringBuilder dest = new StringBuilder(baseDirectory);
        dest.append(separator).append("backup").append(separator).append(new SimpleDateFormat(BACKUP_SUB_DIR_FORMAT).format(date)).append(separator).append(fromBaseDir);
        String destinationDirName = dest.toString();
        File destinationDirectory = new File(destinationDirName);
        if (!destinationDirectory.isDirectory() && !destinationDirectory.mkdirs()) {
            LOGGER.warn((Object)("Unable to create directory '" + destinationDirName + "' for backup files." + " Using '" + baseDirectory + separator + fromBaseDir + "' directory instead."));
            destinationDirName = String.valueOf(baseDirectory) + separator + fromBaseDir;
        }
        String destinationFile = String.valueOf(destinationDirName) + separator + sourceFileName;
        LOGGER.debug((Object)("Backing up source file [" + sourceFilePath + "] to destination file [" + destinationFile + "], "));
        InputStream in = null;
        FileOutputStream out = null;
        try {
            File source = new File(sourceFilePath);
            File destination = new File(destinationFile);
            if (!source.exists()) {
                return null;
            }
            in = new FileInputStream(source);
            out = new FileOutputStream(destination);
            this.copyFiles(in, out);
            out.flush();
            out.getFD().sync();
            LOGGER.debug((Object)("DESTINATION FILE- " + destination.getAbsolutePath() + " -Exists: " + destination.isFile()));
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    LOGGER.warn((Object)("Error closing input stream from file: " + sourceFileName + ".  Cause: " + e.getMessage()));
                }
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    LOGGER.warn((Object)("Error closing output stream to file: " + destinationFile + ".  Cause: " + e.getMessage()));
                }
            }
        }
        return destinationFile;
    }

    public void copyFiles(InputStream in, OutputStream out) throws IOException {
        int len;
        byte[] buf = new byte[1024];
        while ((len = in.read(buf)) > 0) {
            out.write(buf, 0, len);
        }
    }

    public Set<String> getLatestBackupDirectories(String baseDirectory) {
        TreeSet<String> fileSet = new TreeSet<String>();
        File fileDirectory = new File(String.valueOf(baseDirectory) + "/backup");
        if (fileDirectory.isDirectory()) {
            File[] backupDirectories;
            File[] fileArray = backupDirectories = fileDirectory.listFiles(new FileFilter(){

                public boolean accept(File file) {
                    return file.isDirectory();
                }
            });
            int n = backupDirectories.length;
            int n2 = 0;
            while (n2 < n) {
                File directory = fileArray[n2];
                fileSet.add(directory.getName());
                ++n2;
            }
        }
        return fileSet;
    }

    private void printArray(String[] array) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[");
        String[] stringArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            String element = stringArray[n2];
            buffer.append(String.valueOf(element) + ", ");
            ++n2;
        }
        buffer.append("]");
        buffer.substring(0, buffer.length() - 3);
        LOGGER.debug((Object)buffer.toString());
    }

    private void recursiveFileCopy(String destinationDirectory, File source) throws IOException {
        LOGGER.debug((Object)("DestinationDirectory - " + destinationDirectory));
        LOGGER.debug((Object)("File Listing for " + source.getAbsolutePath() + " - "));
        this.printArray(source.list());
        File[] fileArray = source.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File subFile = fileArray[n2];
            if (subFile.isDirectory()) {
                File destinationDir = new File(String.valueOf(destinationDirectory.endsWith("/") ? destinationDirectory : String.valueOf(destinationDirectory) + "/") + subFile.getName());
                if (!destinationDir.isDirectory() && !destinationDir.mkdir()) {
                    throw new IOException(String.format("Unable to create directory '%s'", destinationDir));
                }
                this.recursiveFileCopy(destinationDir.getAbsolutePath(), subFile);
            } else {
                FileInputStream fileIn = null;
                FileOutputStream fileOut = null;
                try {
                    fileIn = new FileInputStream(subFile);
                    fileOut = new FileOutputStream(new File(String.valueOf(destinationDirectory) + "/" + subFile.getName()));
                    this.copyFiles(fileIn, fileOut);
                    fileOut.flush();
                    fileOut.getFD().sync();
                }
                catch (Throwable throwable) {
                    if (fileIn != null) {
                        try {
                            fileIn.close();
                        }
                        catch (Exception exception) {}
                    }
                    if (fileOut != null) {
                        try {
                            fileOut.close();
                        }
                        catch (Exception exception) {}
                    }
                    throw throwable;
                }
                if (fileIn != null) {
                    try {
                        fileIn.close();
                    }
                    catch (Exception exception) {}
                }
                if (fileOut != null) {
                    try {
                        fileOut.close();
                    }
                    catch (Exception exception) {}
                }
            }
            ++n2;
        }
    }

    public void revertToBackupFiles(String baseDirectory, String backupDirectoryName) throws FileUtilityException {
        Set<String> allBackupDirectories = this.getLatestBackupDirectories(baseDirectory);
        if (allBackupDirectories.isEmpty()) {
            throw new FileUtilityException("Unable to revert to backup files: No backup directories found in " + baseDirectory + "/backup");
        }
        LOGGER.debug((Object)("ALLBACKUPS = " + allBackupDirectories));
        baseDirectory = baseDirectory.replace("\\", "/");
        for (String directoryName : allBackupDirectories) {
            if (!directoryName.equals(backupDirectoryName)) continue;
            String fileDirectoryString = String.valueOf(baseDirectory.endsWith("/") ? baseDirectory : String.valueOf(baseDirectory) + "/") + "backup/" + backupDirectoryName;
            File fileDirectory = new File(fileDirectoryString);
            LOGGER.debug((Object)("BackupDirectory - " + fileDirectory.getAbsolutePath() + " - Exists: " + fileDirectory.isDirectory()));
            try {
                this.recursiveFileCopy(baseDirectory, fileDirectory);
            }
            catch (IOException e) {
                throw new FileUtilityException("Unable to revert backup files: " + e.getMessage(), e);
            }
        }
    }
}

