/*
 * Decompiled with CFR 0.152.
 */
package com.springsource.hq.plugin.tcserver.plugin.serverconfig.serverdefaults;

import com.springsource.hq.plugin.tcserver.plugin.serverconfig.AbstractXmlElementConverter;
import com.springsource.hq.plugin.tcserver.plugin.serverconfig.XmlElementConverter;
import com.springsource.hq.plugin.tcserver.serverconfig.configuration.serverdefaults.JspDefaults;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JspDefaultsConverter
extends AbstractXmlElementConverter
implements XmlElementConverter<JspDefaults> {
    private static final String JSP_DEFAULTS = "JSP Defaults";
    private static final int CHECK_INTERVAL = 0;
    private static final int CLASS_DEBUG_INFO = 1;
    private static final int COMPILER = 2;
    private static final int COMPILER_SOURCE_VM = 3;
    private static final int COMPILER_TARGET_VM = 4;
    private static final int DEVELOPMENT = 5;
    private static final int DISPLAY_SOURCE_FRAGMENT = 6;
    private static final int DUMP_SMAP = 7;
    private static final int ENABLE_POOLING = 8;
    private static final int ENGINE_OPTIONS_CLASS = 9;
    private static final int ERROR_ON_USE_BEAN_INVALID_CLASS = 10;
    private static final int FORK = 11;
    private static final int GEN_STR_AS_CHAR_ARRAY = 12;
    private static final int IE_CLASS_ID = 13;
    private static final int JAVA_ENCODING = 14;
    private static final int KEEP_GENERATED = 15;
    private static final int MAPPED_FILE = 16;
    private static final int MODIFICATION_TEST_INTERVAL = 17;
    private static final List<String> PARAM_NAMES;
    private static final String[] PARAM_NAMES_ARRAY;
    private static final int SCRATCH_DIR = 18;
    private static final int SUPPRESS_SMAP = 19;
    private static final int TRIM_SPACES = 20;
    private static final int X_POWERED_BY = 21;

    static {
        PARAM_NAMES_ARRAY = new String[]{"checkInterval", "classdebuginfo", "compiler", "compilerSourceVM", "compilerTargetVM", "development", "displaySourceFragment", "dumpSmap", "enablePooling", "engineOptionsClass", "errorOnUseBeanInvalidClassAttribute", "fork", "genStrAsCharArray", "ieClassId", "javaEncoding", "keepgenerated", "mappedfile", "modificationTestInterval", "scratchdir", "suppressSmap", "trimSpaces", "xpoweredBy"};
        PARAM_NAMES = new ArrayList<String>((Collection)Arrays.asList(PARAM_NAMES_ARRAY));
    }

    @Override
    public JspDefaults convert(Element servlet, Properties catalinaProperties) {
        JspDefaults jspDefaults = new JspDefaults();
        List<Element> initParams = this.getChildElements(servlet, "init-param");
        for (Element initParam : initParams) {
            String paramName = this.getChildElements(initParam, "param-name").get(0).getTextContent();
            this.updateParameter(jspDefaults, paramName, initParam, catalinaProperties);
        }
        return jspDefaults;
    }

    @Override
    public void convert(Document document, Element servlet, JspDefaults from, Properties catalinaProperties) {
        this.updateServletInitParam(document, servlet, PARAM_NAMES_ARRAY[0], from.getCheckInterval(), catalinaProperties);
        this.updateServletInitParam(document, servlet, PARAM_NAMES_ARRAY[1], from.getClassdebuginfo(), catalinaProperties);
        this.updateServletInitParam(document, servlet, PARAM_NAMES_ARRAY[2], from.getCompiler(), catalinaProperties);
        this.updateServletInitParam(document, servlet, PARAM_NAMES_ARRAY[3], from.getCompilerSourceVM(), catalinaProperties);
        this.updateServletInitParam(document, servlet, PARAM_NAMES_ARRAY[4], from.getCompilerTargetVM(), catalinaProperties);
        this.updateServletInitParam(document, servlet, PARAM_NAMES_ARRAY[5], from.getDevelopment(), catalinaProperties);
        this.updateServletInitParam(document, servlet, PARAM_NAMES_ARRAY[6], from.getDisplaySourceFragment(), catalinaProperties);
        this.updateServletInitParam(document, servlet, PARAM_NAMES_ARRAY[7], from.getDumpSmap(), catalinaProperties);
        this.updateServletInitParam(document, servlet, PARAM_NAMES_ARRAY[8], from.getEnablePooling(), catalinaProperties);
        this.updateServletInitParam(document, servlet, PARAM_NAMES_ARRAY[9], from.getEngineOptionsClass(), catalinaProperties);
        this.updateServletInitParam(document, servlet, PARAM_NAMES_ARRAY[10], from.getErrorOnUseBeanInvalidClassAttribute(), catalinaProperties);
        this.updateServletInitParam(document, servlet, PARAM_NAMES_ARRAY[11], from.getFork(), catalinaProperties);
        this.updateServletInitParam(document, servlet, PARAM_NAMES_ARRAY[12], from.getGenStrAsCharArray(), catalinaProperties);
        this.updateServletInitParam(document, servlet, PARAM_NAMES_ARRAY[13], from.getIeClassId(), catalinaProperties);
        this.updateServletInitParam(document, servlet, PARAM_NAMES_ARRAY[14], from.getJavaEncoding(), catalinaProperties);
        this.updateServletInitParam(document, servlet, PARAM_NAMES_ARRAY[15], from.getKeepgenerated(), catalinaProperties);
        this.updateServletInitParam(document, servlet, PARAM_NAMES_ARRAY[16], from.getMappedfile(), catalinaProperties);
        this.updateServletInitParam(document, servlet, PARAM_NAMES_ARRAY[17], from.getModificationTestInterval(), catalinaProperties);
        this.updateServletInitParam(document, servlet, PARAM_NAMES_ARRAY[18], from.getScratchdir(), catalinaProperties);
        this.updateServletInitParam(document, servlet, PARAM_NAMES_ARRAY[19], from.getSuppressSmap(), catalinaProperties);
        this.updateServletInitParam(document, servlet, PARAM_NAMES_ARRAY[20], from.getTrimSpaces(), catalinaProperties);
        this.updateServletInitParam(document, servlet, PARAM_NAMES_ARRAY[21], from.getXpoweredBy(), catalinaProperties);
    }

    private void updateParameter(JspDefaults jspDefaults, String paramName, Element initParam, Properties catalinaProperties) {
        String paramValue;
        int index = PARAM_NAMES.indexOf(paramName);
        if (index != -1 && !"".equals(paramValue = this.parseProperties(this.getChildElements(initParam, "param-value").get(0).getTextContent(), catalinaProperties))) {
            switch (index) {
                case 0: {
                    try {
                        jspDefaults.setCheckInterval(Long.valueOf(paramValue));
                    }
                    catch (NumberFormatException numberFormatException) {
                        this.logNonNumericValue(JSP_DEFAULTS, PARAM_NAMES_ARRAY[0], paramValue);
                    }
                    break;
                }
                case 1: {
                    jspDefaults.setClassdebuginfo(Boolean.valueOf(paramValue));
                    break;
                }
                case 2: {
                    jspDefaults.setCompiler(paramValue);
                    break;
                }
                case 3: {
                    jspDefaults.setCompilerSourceVM(paramValue);
                    break;
                }
                case 4: {
                    jspDefaults.setCompilerTargetVM(paramValue);
                    break;
                }
                case 5: {
                    jspDefaults.setDevelopment(Boolean.valueOf(paramValue));
                    break;
                }
                case 6: {
                    jspDefaults.setDisplaySourceFragment(Boolean.valueOf(paramValue));
                    break;
                }
                case 7: {
                    jspDefaults.setDumpSmap(Boolean.valueOf(paramValue));
                    break;
                }
                case 8: {
                    jspDefaults.setEnablePooling(Boolean.valueOf(paramValue));
                    break;
                }
                case 9: {
                    jspDefaults.setEngineOptionsClass(paramValue);
                    break;
                }
                case 10: {
                    jspDefaults.setErrorOnUseBeanInvalidClassAttribute(Boolean.valueOf(paramValue));
                    break;
                }
                case 11: {
                    jspDefaults.setFork(Boolean.valueOf(paramValue));
                    break;
                }
                case 12: {
                    jspDefaults.setGenStrAsCharArray(Boolean.valueOf(paramValue));
                    break;
                }
                case 13: {
                    jspDefaults.setIeClassId(paramValue);
                    break;
                }
                case 14: {
                    jspDefaults.setJavaEncoding(paramValue);
                    break;
                }
                case 15: {
                    jspDefaults.setKeepgenerated(Boolean.valueOf(paramValue));
                    break;
                }
                case 16: {
                    jspDefaults.setMappedfile(Boolean.valueOf(paramValue));
                    break;
                }
                case 17: {
                    try {
                        jspDefaults.setModificationTestInterval(Long.valueOf(paramValue));
                    }
                    catch (NumberFormatException numberFormatException) {
                        this.logNonNumericValue(JSP_DEFAULTS, PARAM_NAMES_ARRAY[17], paramValue);
                    }
                    break;
                }
                case 18: {
                    jspDefaults.setScratchdir(paramValue);
                    break;
                }
                case 19: {
                    jspDefaults.setSuppressSmap(Boolean.valueOf(paramValue));
                    break;
                }
                case 20: {
                    jspDefaults.setTrimSpaces(Boolean.valueOf(paramValue));
                    break;
                }
                case 21: {
                    jspDefaults.setXpoweredBy(Boolean.valueOf(paramValue));
                    break;
                }
            }
        }
    }
}

