/*
 * Decompiled with CFR 0.152.
 */
package com.springsource.hq.plugin.tcserver.plugin.serverconfig.services;

import com.springsource.hq.plugin.tcserver.plugin.serverconfig.AbstractXmlElementConverter;
import com.springsource.hq.plugin.tcserver.plugin.serverconfig.AttributeNotFoundException;
import com.springsource.hq.plugin.tcserver.plugin.serverconfig.InvalidNodeException;
import com.springsource.hq.plugin.tcserver.plugin.serverconfig.XmlElementConverter;
import com.springsource.hq.plugin.tcserver.plugin.serverconfig.services.connector.AjpConnectorConverter;
import com.springsource.hq.plugin.tcserver.plugin.serverconfig.services.connector.HttpConnectorConverter;
import com.springsource.hq.plugin.tcserver.plugin.serverconfig.services.engine.EngineConverter;
import com.springsource.hq.plugin.tcserver.serverconfig.services.Service;
import com.springsource.hq.plugin.tcserver.serverconfig.services.connector.AjpConnector;
import com.springsource.hq.plugin.tcserver.serverconfig.services.connector.Connector;
import com.springsource.hq.plugin.tcserver.serverconfig.services.connector.HttpConnector;
import com.springsource.hq.plugin.tcserver.serverconfig.services.engine.Engine;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceConverter
extends AbstractXmlElementConverter
implements XmlElementConverter<Service> {
    private XmlElementConverter<AjpConnector> ajpConnectorConverter = new AjpConnectorConverter();
    private XmlElementConverter<Engine> engineConverter = new EngineConverter();
    private XmlElementConverter<HttpConnector> httpConnectorConverter = new HttpConnectorConverter();

    @Override
    public Service convert(Element serviceNode, Properties catalinaProperties) {
        Service service = new Service();
        String name = this.parseProperties(serviceNode.getAttribute("name"), catalinaProperties);
        if ("".equals(name)) {
            throw new AttributeNotFoundException("name", "Service");
        }
        service.setName(name);
        service.setId(name);
        service.setEngine(this.createEngine(serviceNode, catalinaProperties));
        service.setConnectors(this.createConnectors(serviceNode, catalinaProperties));
        return service;
    }

    @Override
    public void convert(Document document, Element service, Service from, Properties catalinaProperties) {
        this.setAttribute(service, "name", from.getName(), catalinaProperties, true);
        this.convertEngine(document, service, from, catalinaProperties);
        this.convertConnectors(document, service, from.getConnectors(), catalinaProperties);
    }

    private void convertConnectors(Document document, Element service, Set<Connector> connectors, Properties catalinaProperties) {
        HashSet<String> connectorIds = new HashSet<String>(connectors.size());
        for (Connector connector : connectors) {
            connectorIds.add(connector.getId());
        }
        HashMap<String, Element> connectorElements = new HashMap<String, Element>();
        List<Element> connectorNodes = this.getChildElements(service, "Connector");
        int i = 0;
        while (i < connectorNodes.size()) {
            String address = this.parseProperties(connectorNodes.get(i).getAttribute("address"), catalinaProperties);
            String port = this.parseProperties(connectorNodes.get(i).getAttribute("port"), catalinaProperties);
            if (connectorIds.contains(String.valueOf(address) + ":" + port)) {
                connectorElements.put(String.valueOf(address) + ":" + port, connectorNodes.get(i));
            } else if (this.isAjpConnector(connectorNodes.get(i).getAttribute("protocol")) || this.isHttpConnector(connectorNodes.get(i).getAttribute("protocol"))) {
                service.removeChild(connectorNodes.get(i));
            }
            ++i;
        }
        for (Connector connector : connectors) {
            Element connectorElement = (Element)connectorElements.get(connector.getId());
            if (connectorElement == null) {
                connectorElement = document.createElement("Connector");
                service.appendChild(connectorElement);
            }
            if (connector instanceof HttpConnector) {
                this.httpConnectorConverter.convert(document, connectorElement, (HttpConnector)connector, catalinaProperties);
                continue;
            }
            if (!(connector instanceof AjpConnector)) continue;
            this.ajpConnectorConverter.convert(document, connectorElement, (AjpConnector)connector, catalinaProperties);
        }
    }

    private boolean isHttpConnector(String protocol) {
        return "HTTP/1.1".equals(protocol) || "org.apache.coyote.http11.Http11NioProtocol".equals(protocol) || "org.apache.coyote.http11.Http11Protocol".equals(protocol) || "org.apache.coyote.http11.Http11AprProtocol".equals(protocol);
    }

    private boolean isAjpConnector(String protocol) {
        return "AJP/1.3".equals(protocol) || "org.apache.jk.server.JkCoyoteHandler".equals(protocol) || "org.apache.coyote.ajp.AjpAprProtocol".equals(protocol) || "org.apache.coyote.ajp.AjpProtocol".equals(protocol);
    }

    private void convertEngine(Document document, Element service, Service from, Properties catalinaProperties) {
        Element engineElement = null;
        List<Element> engines = this.getChildElements(service, "Engine");
        if (engines.size() != 1) {
            engineElement = document.createElement("Engine");
            service.appendChild(engineElement);
        } else {
            engineElement = engines.get(0);
        }
        this.engineConverter.convert(document, engineElement, from.getEngine(), catalinaProperties);
    }

    private Set<Connector> createConnectors(Element service, Properties catalinaProperties) {
        HashSet<Connector> connectors = new HashSet<Connector>();
        List<Element> connectorNodes = this.getChildElements(service, "Connector");
        int i = 0;
        while (i < connectorNodes.size()) {
            Element connectorNode = connectorNodes.get(i);
            String protocol = this.parseProperties(connectorNode.getAttribute("protocol"), catalinaProperties);
            if (this.isHttpConnector(protocol)) {
                HttpConnector httpConnector = this.httpConnectorConverter.convert(connectorNode, catalinaProperties);
                connectors.add((Connector)httpConnector);
            } else if (this.isAjpConnector(protocol)) {
                AjpConnector ajpConnector = this.ajpConnectorConverter.convert(connectorNode, catalinaProperties);
                connectors.add((Connector)ajpConnector);
            }
            ++i;
        }
        return connectors;
    }

    private Engine createEngine(Element service, Properties catalinaProperties) {
        List<Element> engines = this.getChildElements(service, "Engine");
        if (engines.size() != 1) {
            throw new InvalidNodeException("Found 0 or multiple Engine elements under Service " + service.getAttribute("name"));
        }
        Element engineNode = engines.get(0);
        return this.engineConverter.convert(engineNode, catalinaProperties);
    }
}

