/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.junit;

import java.io.File;
import java.lang.reflect.Method;
import java.net.URISyntaxException;
import java.net.URL;
import org.eclipse.jgit.util.RawParseUtils;
import org.junit.Assert;
import org.junit.Test;

public abstract class JGitTestUtil {
    public static final String CLASSPATH_TO_RESOURCES = "org/eclipse/jgit/test/resources/";

    private JGitTestUtil() {
        throw new UnsupportedOperationException();
    }

    public static String getName() {
        try {
            throw new GatherStackTrace();
        }
        catch (GatherStackTrace wanted) {
            GatherStackTrace stack = wanted;
            try {
                for (StackTraceElement stackTrace : stack.getStackTrace()) {
                    Method method;
                    String className = stackTrace.getClassName();
                    String methodName = stackTrace.getMethodName();
                    try {
                        method = Class.forName(className).getMethod(methodName, null);
                    }
                    catch (NoSuchMethodException e) {
                        continue;
                    }
                    Test annotation = method.getAnnotation(Test.class);
                    if (annotation == null) continue;
                    return methodName;
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            throw new AssertionError((Object)"Cannot determine name of current test");
        }
    }

    public static void assertEquals(byte[] exp, byte[] act) {
        Assert.assertEquals((Object)JGitTestUtil.s(exp), (Object)JGitTestUtil.s(act));
    }

    private static String s(byte[] raw) {
        return RawParseUtils.decode((byte[])raw);
    }

    public static File getTestResourceFile(String fileName) {
        if (fileName == null || fileName.length() <= 0) {
            return null;
        }
        URL url = JGitTestUtil.cl().getResource(CLASSPATH_TO_RESOURCES + fileName);
        if (url == null) {
            return new File("tst", fileName);
        }
        try {
            return new File(url.toURI());
        }
        catch (URISyntaxException e) {
            return new File(url.getPath());
        }
    }

    private static ClassLoader cl() {
        return JGitTestUtil.class.getClassLoader();
    }

    private static class GatherStackTrace
    extends Exception {
        private GatherStackTrace() {
        }
    }
}

