/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.plugin.hyper_v;

import java.util.Collections;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.hq.product.Collector;
import org.hyperic.hq.product.DetectionUtil;
import org.hyperic.hq.product.MeasurementPlugin;
import org.hyperic.hq.product.Metric;
import org.hyperic.hq.product.MetricNotFoundException;
import org.hyperic.hq.product.MetricUnreachableException;
import org.hyperic.hq.product.MetricValue;
import org.hyperic.hq.product.PluginException;
import org.hyperic.hq.product.Win32MeasurementPlugin;
import org.hyperic.sigar.win32.Pdh;
import org.hyperic.sigar.win32.Win32Exception;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HyperVMeasurementPlugin
extends Win32MeasurementPlugin {
    private static Log log = LogFactory.getLog(HyperVMeasurementPlugin.class);

    protected Set<String> getWMIObj(Metric metric) throws PluginException {
        return DetectionUtil.getWMIObj((String)metric.getObjectProperty("namespace"), (String)metric.getObjectProperty("object"), Collections.singletonMap(metric.getAttributeName(), "="), (String)metric.getObjectProperty("column"), (String)metric.getObjectName());
    }

    public MetricValue getValue(Metric metric) throws PluginException, MetricNotFoundException, MetricUnreachableException {
        String metricDomain = metric.getDomainName();
        if ("wmic".equals(metricDomain)) {
            Set<String> obj = this.getWMIObj(metric);
            String state = null;
            if (!obj.isEmpty()) {
                state = obj.iterator().next();
            }
            if ("2".equals(state)) {
                return new MetricValue(1.0);
            }
            return new MetricValue(0.0);
        }
        if (metric.isAvail()) {
            return this.getAvailMetric(metric);
        }
        if ("pdh".equals(metricDomain) || "pdh_formatted".equals(metricDomain)) {
            return this.getPdhMetric(metric);
        }
        if ("collector".equals(metricDomain)) {
            return Collector.getValue((MeasurementPlugin)this, (Metric)metric);
        }
        try {
            MetricValue metricVal = super.getValue(metric);
            return metricVal;
        }
        catch (MetricNotFoundException e) {
            return MetricValue.NONE;
        }
    }

    private MetricValue getAvailMetric(Metric metric) throws PluginException, MetricNotFoundException, MetricUnreachableException {
        try {
            String[] instances = Pdh.getInstances((String)metric.getDomainName());
            String serviceName = metric.getObjectPropString();
            serviceName = serviceName.replaceAll("%3A", ":");
            log.debug((Object)("avail of: " + metric.getDomainName() + " service=" + serviceName));
            for (String instance : instances) {
                log.debug((Object)("avail: instance=" + instance));
                if (!serviceName.equals(instance)) continue;
                log.debug((Object)("avail is up for:" + metric.getDomainName() + ":" + serviceName));
                return new MetricValue(1.0);
            }
            return new MetricValue(0.0);
        }
        catch (Win32Exception e) {
            log.debug((Object)("avail is down for:" + metric.getDomainName() + e.getMessage()));
            return new MetricValue(0.0);
        }
    }

    protected static String getPath(Metric metric) {
        String obj = "\\" + metric.getObjectPropString() + "\\" + metric.getAttributeName();
        obj = obj.replaceAll("%3A", ":");
        return obj;
    }

    private MetricValue getPdhMetric(Metric metric) throws PluginException, MetricNotFoundException, MetricUnreachableException {
        String obj = HyperVMeasurementPlugin.getPath(metric);
        try {
            Double val = "pdh".equals(metric.getDomainName()) ? Double.valueOf(new Pdh().getRawValue(obj)) : Double.valueOf(new Pdh().getFormattedValue(obj));
            return new MetricValue((Number)val);
        }
        catch (Win32Exception e) {
            log.warn((Object)("got exception: metric=\\" + metric.getObjectPropString() + "\\" + metric.getAttributeName() + "  " + e.getMessage()));
            return MetricValue.NONE;
        }
    }
}

