/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.plugin.postgresql;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.hq.plugin.postgresql.PostgreSQL;
import org.hyperic.hq.product.Collector;
import org.hyperic.hq.product.MeasurementPlugin;
import org.hyperic.hq.product.Metric;
import org.hyperic.hq.product.MetricNotFoundException;
import org.hyperic.hq.product.MetricUnreachableException;
import org.hyperic.hq.product.MetricValue;
import org.hyperic.hq.product.PluginException;
import org.hyperic.hq.product.SigarMeasurementPlugin;
import org.hyperic.sigar.Sigar;
import org.hyperic.sigar.SigarException;
import org.hyperic.sigar.SigarNotImplementedException;
import org.hyperic.sigar.SigarProxy;
import org.hyperic.sigar.SigarProxyCache;
import org.hyperic.sigar.jmx.SigarInvokerJMX;
import org.hyperic.util.jdbc.DBUtil;

public class ServerMeasurement
extends SigarMeasurementPlugin {
    private Log log = LogFactory.getLog(ServerMeasurement.class);
    private long pid = -1L;
    private Sigar sigar = null;
    private SigarProxy sigarProxy = null;
    private String actualConfig = "";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MetricValue getValue(Metric metric) throws PluginException, MetricNotFoundException, MetricUnreachableException {
        MetricValue res;
        block15: {
            if (metric.getDomainName().equals("collector")) {
                return Collector.getValue((MeasurementPlugin)this, (Metric)metric);
            }
            this.initSigar();
            this.log.debug((Object)("[getValue] metric=" + metric));
            try {
                this.findPid(metric);
            }
            catch (PluginException ex) {
                if (metric.isAvail()) {
                    this.log.debug((Object)ex, (Throwable)ex);
                    return new MetricValue(0.0);
                }
                throw ex;
            }
            if (metric.isAvail()) {
                res = new MetricValue(1.0);
            } else {
                String oName = "sigar:Type=" + metric.getObjectProperty("Type") + ",Arg=State.Ppid.eq=" + this.pid;
                this.log.debug((Object)("[getValue] oName=" + oName));
                String attr = metric.getAttributeName();
                SigarInvokerJMX invoker = SigarInvokerJMX.getInstance((SigarProxy)this.sigarProxy, (String)oName);
                try {
                    Object systemValue;
                    Sigar sigar = this.sigar;
                    synchronized (sigar) {
                        systemValue = invoker.invoke(attr);
                    }
                    if (systemValue instanceof Double) {
                        res = new MetricValue((Number)((Double)systemValue));
                        break block15;
                    }
                    if (systemValue instanceof Long) {
                        res = new MetricValue((Number)new Double(((Long)systemValue).longValue()));
                        break block15;
                    }
                    if (systemValue instanceof Integer) {
                        res = new MetricValue((Number)new Double(((Integer)systemValue).intValue()));
                        break block15;
                    }
                    PluginException ex = new PluginException("Error on systemValue '" + systemValue + "' (" + systemValue.getClass() + ")");
                    this.log.debug((Object)ex, (Throwable)ex);
                    throw ex;
                }
                catch (SigarNotImplementedException e) {
                    this.pid = -1L;
                    throw new MetricUnreachableException(e.getMessage(), (Throwable)e);
                }
                catch (SigarException e) {
                    this.pid = -1L;
                    throw new MetricNotFoundException(e.getMessage(), (Throwable)e);
                }
            }
        }
        return res;
    }

    protected void initSigar() throws PluginException {
        if (this.sigar == null) {
            try {
                this.sigar = new Sigar();
                this.sigarProxy = SigarProxyCache.newInstance((Sigar)this.sigar);
            }
            catch (UnsatisfiedLinkError ex) {
                this.log.debug((Object)("unable to load sigar: " + ex.getMessage()), (Throwable)ex);
                this.sigar = null;
                this.sigarProxy = null;
                throw new PluginException(ex.getMessage(), (Throwable)ex);
            }
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void findPid(Metric metric) throws PluginException {
        boolean isNewConfig;
        Properties props = metric.getProperties();
        String user = props.getProperty("postgresql.user");
        String pass = props.getProperty("postgresql.pass");
        String url = PostgreSQL.prepareUrl(props, null);
        String newConfig = url + "-" + user + "-" + pass;
        boolean bl = isNewConfig = !newConfig.equalsIgnoreCase(this.actualConfig);
        if (isNewConfig) {
            this.log.debug((Object)"[findPid] new config detected");
            this.actualConfig = newConfig;
        }
        if (!isNewConfig && this.pid != -1L) {
            if (!metric.isAvail()) return;
        }
        Connection conn = null;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            conn = DriverManager.getConnection(url, user, pass);
            stmt = conn.createStatement();
            stmt.execute("select pg_backend_pid()");
            rs = stmt.getResultSet();
            if (rs.next()) {
                int conectionPid = rs.getInt(1);
                this.pid = new Sigar().getProcState((long)conectionPid).getPpid();
                this.log.debug((Object)("[findPid] conection PID:" + conectionPid + " ==> main Process PID:" + this.pid));
            }
        }
        catch (SQLException ex) {
            try {
                this.pid = -1L;
                throw new PluginException(ex.getMessage(), (Throwable)ex);
                catch (SigarException ex2) {
                    this.pid = -1L;
                    throw new PluginException(ex2.getMessage(), (Throwable)ex2);
                }
            }
            catch (Throwable throwable) {
                DBUtil.closeJDBCObjects((Object)this.getLog(), (Connection)conn, (Statement)stmt, rs);
                throw throwable;
            }
        }
        DBUtil.closeJDBCObjects((Object)this.getLog(), (Connection)conn, (Statement)stmt, (ResultSet)rs);
    }
}

