/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.plugin.postgresql;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.hq.plugin.postgresql.PostgreSQL;
import org.hyperic.hq.product.Collector;
import org.hyperic.hq.product.CollectorResult;
import org.hyperic.hq.product.Metric;
import org.hyperic.hq.product.MetricValue;
import org.hyperic.util.jdbc.DBUtil;

public class TableIndexCollector
extends Collector {
    private static Log log = LogFactory.getLog(TableIndexCollector.class);
    private List<String> schemas = new ArrayList<String>();
    private List<String> tables = new ArrayList<String>();
    private List<String> indexes = new ArrayList<String>();
    private String whereTable = "";
    private String whereIndex = "";
    private boolean firstCollect = true;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void collect() {
        Connection conn;
        block9: {
            Properties p = this.getProperties();
            String user = p.getProperty("postgresql.user");
            String pass = p.getProperty("postgresql.pass");
            String db = p.getProperty("db");
            String queryTable = "SELECT * FROM pg_stat_user_tables " + this.whereTable;
            String queryIndex = "SELECT * FROM pg_stat_user_indexes " + this.whereIndex;
            conn = null;
            try {
                int c;
                String schemaName;
                ResultSetMetaData md;
                ResultSet rs;
                Statement stmt;
                String url = PostgreSQL.prepareUrl(p, db);
                log.debug((Object)("[collect] url:'" + url + "'"));
                conn = DriverManager.getConnection(url, user, pass);
                if (this.firstCollect || this.tables.size() > 0) {
                    log.debug((Object)("[collect] queryTable='" + queryTable + "'"));
                    stmt = conn.createStatement();
                    rs = stmt.executeQuery(queryTable);
                    md = rs.getMetaData();
                    while (rs.next()) {
                        String tableName = rs.getString("relname");
                        schemaName = rs.getString("schemaname");
                        this.setValue("table." + schemaName + "." + tableName + "." + "Availability", 1.0);
                        for (c = 1; c <= md.getColumnCount(); ++c) {
                            this.setValue("table." + schemaName + "." + tableName + "." + md.getColumnLabel(c), rs.getString(c));
                        }
                    }
                    DBUtil.closeJDBCObjects((Object)log, null, (Statement)stmt, (ResultSet)rs);
                }
                if (!this.firstCollect && this.indexes.size() <= 0) break block9;
                log.debug((Object)("[collect] queryInex='" + queryIndex + "'"));
                stmt = conn.createStatement();
                rs = stmt.executeQuery(queryIndex);
                md = rs.getMetaData();
                while (rs.next()) {
                    String indexrelName = rs.getString("indexrelname");
                    schemaName = rs.getString("schemaname");
                    this.setValue("index." + schemaName + "." + indexrelName + "." + "Availability", 1.0);
                    for (c = 1; c <= md.getColumnCount(); ++c) {
                        this.setValue("index." + schemaName + "." + indexrelName + "." + md.getColumnLabel(c), rs.getString(c));
                    }
                }
            }
            catch (Exception e) {
                try {
                    String msg = "Error getting metrics: " + e.getMessage();
                    this.setErrorMessage(msg, e);
                    log.debug((Object)("[collect] " + msg), (Throwable)e);
                }
                catch (Throwable throwable) {
                    DBUtil.closeJDBCObjects((Object)log, conn, null, null);
                    throw throwable;
                }
                DBUtil.closeJDBCObjects((Object)log, (Connection)conn, null, null);
            }
        }
        DBUtil.closeJDBCObjects((Object)log, (Connection)conn, null, null);
        this.firstCollect = false;
    }

    public MetricValue getValue(Metric metric, CollectorResult result) {
        MetricValue res;
        String table = metric.getProperties().getProperty("table");
        String schema = metric.getProperties().getProperty("schema");
        String index = metric.getProperties().getProperty("index");
        boolean updateWhere = false;
        if (table != null && !this.tables.contains(table)) {
            this.tables.add(table);
            updateWhere = true;
        }
        if (!this.schemas.contains(schema)) {
            this.schemas.add(schema);
            updateWhere = true;
        }
        if (index != null && !this.indexes.contains(index)) {
            this.indexes.add(index);
            updateWhere = true;
        }
        if (updateWhere) {
            this.whereTable = "where relname in(" + PostgreSQL.listToString(this.tables, ",") + ") and schemaname in(" + PostgreSQL.listToString(this.schemas, ",") + ")";
            this.whereIndex = "where indexrelname in(" + PostgreSQL.listToString(this.indexes, ",") + ") and schemaname in(" + PostgreSQL.listToString(this.schemas, ",") + ")";
        }
        if ((res = super.getValue(metric, this.getResult())) == null && metric.getAttributeName().endsWith("Availability")) {
            res = new MetricValue(0.0);
        }
        return res;
    }
}

