/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.plugin.apache;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpResponse;
import org.hyperic.hq.plugin.netservices.HTTPCollector;
import org.hyperic.hq.product.MetricValue;
import org.hyperic.hq.product.PluginException;
import org.hyperic.util.StringUtil;

public class ApacheStatusCollector
extends HTTPCollector {
    private static final Log log = LogFactory.getLog((String)ApacheStatusCollector.class.getName());
    private static final String AUTO_FLAG = "?auto";
    private static final String[][] STATES = new String[][]{{"_", "Waiting"}, {"S", "Starting"}, {"R", "Reading"}, {"W", "Sending"}, {"K", "Keepalive"}, {"D", "DNS"}, {"C", "Closing"}, {"L", "Logging"}, {"G", "Finishing"}, {".", "Free"}};
    private static final Map STATE_MAP = new HashMap(STATES.length);

    protected void init() throws PluginException {
        super.init();
        this.setMethod("GET");
        String url = this.getURL();
        if (!url.endsWith(AUTO_FLAG)) {
            this.setURL(url + AUTO_FLAG);
        }
    }

    public void collect() {
        super.collect();
        MetricValue value = this.getResult().getMetricValue("ResponseCode");
        if (value != null && value.getValue() == 404.0) {
            this.setAvailability(true);
            String path = this.getProperties().getProperty("path");
            log.warn((Object)("GET " + path + ": " + this.getMessage()));
        }
    }

    private void parseScoreboard(String val) {
        int i;
        int len = val.length();
        int[] states = new int[STATES.length];
        for (i = 0; i < states.length; ++i) {
            states[i] = 0;
        }
        for (i = 0; i < len; ++i) {
            String key = val.substring(i, i + 1);
            Integer ix = (Integer)STATE_MAP.get(key);
            if (ix == null) continue;
            int n = ix;
            states[n] = states[n] + 1;
        }
        for (i = 0; i < states.length; ++i) {
            String name = STATES[i][1];
            this.setValue(name, states[i]);
        }
    }

    private void parse(HttpResponse response) throws IOException {
        String line;
        InputStream is = response.getEntity().getContent();
        BufferedReader reader = new BufferedReader(new InputStreamReader(is));
        while ((line = reader.readLine()) != null) {
            int ix = line.indexOf(": ");
            if (ix == -1) continue;
            String key = line.substring(0, ix).trim();
            String val = line.substring(ix + 2).trim();
            if (key.equals("Scoreboard")) {
                this.parseScoreboard(val);
                continue;
            }
            key = StringUtil.replace((String)key, (String)" ", (String)"");
            ix = val.indexOf("e-");
            if (ix != -1) {
                val = val.substring(0, ix);
            }
            this.setValue(key, val);
            if (key.endsWith("Workers")) {
                key = StringUtil.replace((String)key, (String)"Workers", (String)"Servers");
            }
            this.setValue(key, val);
        }
    }

    protected void parseResults(HttpResponse response) {
        try {
            this.parse(response);
        }
        catch (IOException e) {
            log.error((Object)("Exception parsing: " + this.getURL()), (Throwable)e);
        }
    }

    protected void netstat() {
    }

    static {
        for (int i = 0; i < STATES.length; ++i) {
            STATE_MAP.put(STATES[i][0], new Integer(i));
        }
    }
}

