/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.plugin.apache;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpResponse;
import org.hyperic.hq.plugin.netservices.HTTPCollector;
import org.hyperic.hq.product.PluginException;

public class JkStatusCollector
extends HTTPCollector {
    private static final Log log = LogFactory.getLog((String)JkStatusCollector.class.getName());
    private static final String MIME_FLAG = "?mime=prop";
    static final String JK_NAME = "mod_jk";
    static final String WORKER_NAME = "mod_jk Worker";
    static final String[] WORKER_PROPS = new String[]{"host", "address"};
    private static final Map _filter = new HashMap();
    private static final Map _state = new HashMap();
    private Set _lbs = new HashSet();
    private Set _workers = new HashSet();

    private static void initConstants() {
        int i;
        if (_filter.size() != 0) {
            return;
        }
        String[] keys = new String[]{"member_count", "good", "degraded", "bad", "busy", "state", "errors", "client_errors", "transferred", "read", "busy"};
        for (i = 0; i < keys.length; ++i) {
            _filter.put(keys[i], Boolean.TRUE);
        }
        for (i = 0; i < WORKER_PROPS.length; ++i) {
            _filter.put(WORKER_PROPS[i], Boolean.TRUE);
        }
        _state.put("OK", new Double(1.0));
        _state.put("N/A", new Double(-0.01));
        _state.put("REC", new Double(0.5));
        _state.put("ERR", new Double(0.0));
    }

    protected void init() throws PluginException {
        super.init();
        this.setMethod("GET");
        String url = this.getURL();
        if (!url.endsWith(MIME_FLAG)) {
            this.setURL(url + MIME_FLAG);
        }
        JkStatusCollector.initConstants();
    }

    protected void parseResults(HttpResponse response) {
        try {
            this.parse(response);
        }
        catch (IOException e) {
            log.error((Object)("Exception parsing: " + this.getURL()), (Throwable)e);
        }
    }

    Set getLoadBalancers() {
        return this._lbs;
    }

    Set getWorkers() {
        return this._workers;
    }

    private void parse(HttpResponse response) throws IOException {
        String line;
        this._lbs.clear();
        this._workers.clear();
        InputStream is = response.getEntity().getContent();
        BufferedReader bf = new BufferedReader(new InputStreamReader(is));
        String prefix = "worker.";
        String prevKey = null;
        while (null != (line = bf.readLine())) {
            int ix = line.indexOf(61);
            if (ix == -1) continue;
            String worker = line.substring(0, ix);
            String val = line.substring(ix + 1);
            if (!worker.startsWith("worker.") || (ix = (worker = worker.substring("worker.".length())).indexOf(46)) == -1) continue;
            String name = worker.substring(0, ix);
            String key = worker.substring(ix + 1);
            if (key.equals("type")) {
                if (val.equals("lb")) {
                    this._lbs.add(name);
                    continue;
                }
                if (!val.startsWith("ajp") || !"balance_workers".equals(prevKey)) continue;
                this._workers.add(name);
                continue;
            }
            prevKey = key;
            if (_filter.get(key) != Boolean.TRUE) continue;
            if (key.equals("state")) {
                Double state = (Double)_state.get(val);
                double avail = state == null ? 1.0 : state;
                this.setValue(worker, avail);
                continue;
            }
            this.setValue(worker, val);
        }
    }
}

