/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.plugin.sharepoint;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.hyperic.hq.agent.AgentKeystoreConfig;
import org.hyperic.hq.product.Metric;
import org.hyperic.hq.product.MetricNotFoundException;
import org.hyperic.hq.product.MetricUnreachableException;
import org.hyperic.hq.product.MetricValue;
import org.hyperic.hq.product.PluginException;
import org.hyperic.hq.product.Win32MeasurementPlugin;
import org.hyperic.sigar.win32.Pdh;
import org.hyperic.sigar.win32.Service;
import org.hyperic.sigar.win32.Win32Exception;
import org.hyperic.util.exec.Execute;
import org.hyperic.util.exec.ExecuteStreamHandler;
import org.hyperic.util.exec.ExecuteWatchdog;
import org.hyperic.util.exec.PumpStreamHandler;
import org.hyperic.util.http.HQHttpClient;
import org.hyperic.util.http.HttpConfig;
import org.hyperic.util.security.KeystoreConfig;

public class SharePointServerMeasurement
extends Win32MeasurementPlugin {
    private static Log log = LogFactory.getLog(SharePointServerMeasurement.class);

    public MetricValue getValue(Metric metric) throws PluginException, MetricNotFoundException, MetricUnreachableException {
        MetricValue res;
        log.debug((Object)("[getValue] metric=" + metric));
        if (metric.getDomainName().equalsIgnoreCase("server")) {
            res = this.checkServerAvail(metric);
        } else if (metric.getDomainName().equalsIgnoreCase("web")) {
            if (metric.isAvail()) {
                res = new MetricValue(this.checkWebAvail(metric.getObjectProperty("name")));
            } else {
                try {
                    long rt = System.currentTimeMillis();
                    this.testWebServer(metric.getObjectProperty("url"));
                    rt = System.currentTimeMillis() - rt;
                    res = new MetricValue(rt);
                }
                catch (PluginException ex) {
                    log.debug((Object)ex, (Throwable)ex);
                    throw ex;
                }
            }
        } else if (metric.getDomainName().equalsIgnoreCase("pdh")) {
            if (metric.getAttributeName().equalsIgnoreCase("Object Cache Hit %")) {
                double hits = this.getPDHMetric("\\" + metric.getObjectPropString() + "\\Object Cache Hit Count");
                double miss = this.getPDHMetric("\\" + metric.getObjectPropString() + "\\Object Cache Miss Count");
                res = hits >= 0.0 && miss >= 0.0 && hits + miss > 0.0 ? new MetricValue(hits / (hits + miss)) : MetricValue.NONE;
            } else {
                res = this.getPDHMetric(metric);
            }
        } else {
            throw new PluginException("incorrect domain '" + metric.getDomainName() + "'");
        }
        return res;
    }

    private MetricValue checkServerAvail(Metric metric) {
        int i;
        double res = 1.0;
        String w = metric.getObjectProperty("webs");
        List<Object> webs = w != null ? Arrays.asList(w.split(",")) : new ArrayList();
        String s = metric.getObjectProperty("services");
        List<Object> services = s != null ? Arrays.asList(s.split(",")) : new ArrayList();
        for (i = 0; i < webs.size() && res == 1.0; ++i) {
            String web = ((String)webs.get(i)).trim();
            res = this.checkWebAvail(web);
        }
        for (i = 0; i < services.size() && res == 1.0; ++i) {
            String service = ((String)services.get(i)).trim();
            res = this.checkServiceAvail(service);
        }
        return new MetricValue(res);
    }

    private double checkServiceAvail(String service) {
        log.debug((Object)("[checkServiceAvail] * service='" + service + "'"));
        double res = 0.0;
        try {
            if (service != null) {
                Service s = new Service(service);
                if (s.getStatus() == 4) {
                    res = 1.0;
                }
                log.debug((Object)("[checkServiceAvail] service='" + service + "' res=" + res));
            }
        }
        catch (Win32Exception ex) {
            log.debug((Object)("[checkServiceAvail] error. service='" + service + "'"), (Throwable)ex);
        }
        return res;
    }

    private double checkWebAvail(String webserver) {
        double res = 0.0;
        String[] cmd = new String[]{"C:/Windows/System32/inetsrv/appcmd.exe", "list", "site", webserver};
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        ExecuteWatchdog wdog = new ExecuteWatchdog(60000);
        Execute exec = new Execute((ExecuteStreamHandler)new PumpStreamHandler((OutputStream)output), wdog);
        exec.setCommandline(cmd);
        try {
            int exitStatus = exec.execute();
            log.debug((Object)("[checkWebAvail] webserver=" + webserver + ",exitStatus:" + exitStatus + ", output=" + output.toString()));
            if (exitStatus == 0 || !wdog.killedProcess()) {
                log.debug((Object)("[checkWebAvail] webserver=" + webserver + ", output=" + output));
                if (output.toString().toLowerCase().contains(":started")) {
                    res = 1.0;
                }
            }
        }
        catch (Exception e) {
            log.debug((Object)("[checkWebAvail] webserver=" + webserver + ", error=" + e.getMessage()), (Throwable)e);
        }
        return res;
    }

    private MetricValue getPDHMetric(Metric metric) {
        MetricValue res;
        String obj = "\\" + metric.getObjectPropString();
        if (!metric.isAvail()) {
            obj = obj + "\\" + metric.getAttributeName();
        }
        try {
            Double val = new Pdh().getFormattedValue(obj);
            res = new MetricValue((Number)val);
            if (metric.isAvail()) {
                res = new MetricValue(1.0);
            }
        }
        catch (Win32Exception ex) {
            if (metric.isAvail()) {
                res = new MetricValue(0.0);
                log.debug((Object)("error on mteric:'" + metric + "' :" + ex.getLocalizedMessage()), (Throwable)ex);
            }
            res = MetricValue.NONE;
            log.debug((Object)("error on metric:'" + metric + "' :" + ex.getLocalizedMessage()));
        }
        return res;
    }

    private double getPDHMetric(String obj) {
        double res = -1.0;
        try {
            res = new Pdh().getFormattedValue(obj);
        }
        catch (Win32Exception ex) {
            log.debug((Object)("error on value for object:'" + obj + "' :" + ex.getLocalizedMessage()));
        }
        return res;
    }

    private void testWebServer(String url) throws PluginException {
        HttpGet get = new HttpGet(url);
        AgentKeystoreConfig ksConfig = new AgentKeystoreConfig();
        HQHttpClient client = new HQHttpClient((KeystoreConfig)ksConfig, new HttpConfig(5000, 5000, null, 0), ksConfig.isAcceptUnverifiedCert());
        try {
            HttpResponse response = client.execute((HttpUriRequest)get, (HttpContext)new BasicHttpContext());
            int r = response.getStatusLine().getStatusCode();
            log.debug((Object)("[testWebServer] url='" + get.getURI() + "' statusCode='" + r + "' " + response.getStatusLine().getReasonPhrase()));
            if (r >= 500) {
                throw new PluginException("[testWebServer] error=" + r);
            }
        }
        catch (IOException ex) {
            throw new PluginException(ex.getMessage(), (Throwable)ex);
        }
    }
}

