/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.plugin.mssql;

import edu.emory.mathcs.backport.java.util.Arrays;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.hq.plugin.mssql.PDH;
import org.hyperic.hq.product.Collector;
import org.hyperic.hq.product.CollectorResult;
import org.hyperic.hq.product.Metric;
import org.hyperic.hq.product.MetricValue;
import org.hyperic.sigar.Sigar;

public class MsSQLCollector
extends Collector {
    private static Log log = LogFactory.getLog(MsSQLCollector.class);
    private List<String> counters = new ArrayList<String>();

    public void collect() {
        log.debug((Object)("[collect] [" + this.getProperties() + "] counters.size() = " + this.counters.size()));
        if (this.counters.size() > 0) {
            try {
                Map<String, Double> res = PDH.getFormattedValues(this.counters);
                for (Map.Entry<String, Double> entry : res.entrySet()) {
                    String obj = entry.getKey();
                    Double val = entry.getValue();
                    log.debug((Object)("[collect] " + obj + " = " + val));
                    this.setValue(obj, val);
                }
            }
            catch (Exception ex) {
                log.debug((Object)("[collect] " + ex), (Throwable)ex);
            }
        }
    }

    public MetricValue getValue(Metric metric, CollectorResult result) {
        String obj;
        String g;
        log.debug((Object)("[getValue] metirc = " + metric));
        String format = metric.getProperties().getProperty("format", "1");
        String prefix = metric.getProperties().getProperty("pref_prefix");
        if (prefix == null) {
            prefix = metric.getObjectProperty("sn");
        }
        if ((g = metric.getProperties().getProperty("g")).equals("process")) {
            obj = this.prepareProcessMetric(metric);
        } else if (format.equals("2")) {
            obj = "\\" + g + "\\" + metric.getAttributeName();
        } else {
            if ("MSSQLSERVER".equalsIgnoreCase(prefix)) {
                prefix = "SQLServer";
            }
            obj = "\\" + prefix + ":" + g + "\\" + metric.getAttributeName();
        }
        MetricValue res = MetricValue.NONE;
        if (obj != null) {
            if (this.counters.contains(obj)) {
                res = result.getMetricValue(obj);
            } else {
                this.counters.add(obj);
            }
        }
        log.debug((Object)("[getValue] obj:'" + obj + "' res:'" + res.getValue() + "'"));
        return res;
    }

    private String prepareProcessMetric(Metric metric) {
        String obj = null;
        try {
            log.debug((Object)("[ppm] metric='" + metric + "'"));
            String serviceName = metric.getProperties().getProperty("service_name");
            if (serviceName == null) {
                throw new IllegalArgumentException("'service_name' is null. Metric:" + metric);
            }
            Sigar sigar = new Sigar();
            long servicePID = sigar.getServicePid(serviceName);
            log.debug((Object)("[ppm] serviceName='" + serviceName + "' servicePID='" + servicePID + "'"));
            List instances = Arrays.asList((Object[])PDH.getInstances("Process"));
            String serviceInstance = null;
            for (int i = 0; i < instances.size() && serviceInstance == null; ++i) {
                String instance = (String)instances.get(i);
                if (!instance.startsWith("sqlservr")) continue;
                String idp_obj = "\\Process(" + instance + ")\\ID Process";
                log.debug((Object)("[ppm] idp_obj='" + idp_obj + "'"));
                double idp = PDH.getValue(idp_obj);
                if (idp != (double)servicePID) continue;
                serviceInstance = instance;
                log.debug((Object)("[ppm] serviceName='" + serviceName + "' serviceInstance='" + serviceInstance + "'"));
            }
            if (serviceInstance != null) {
                obj = "\\Process(" + serviceInstance + ")\\" + metric.getAttributeName();
                log.debug((Object)("[ppm] obj = '" + obj + "'"));
            } else {
                log.debug((Object)("[ppm] Process for serviceName='" + serviceName + "' not found, returning " + null));
            }
        }
        catch (Exception ex) {
            log.debug((Object)("[ppm] " + ex), (Throwable)ex);
        }
        return obj;
    }
}

