/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.plugin.mssql;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.hq.plugin.mssql.MsSQLCollector;
import org.hyperic.hq.product.CollectorResult;
import org.hyperic.hq.product.Metric;
import org.hyperic.hq.product.MetricValue;
import org.hyperic.hq.product.ProductPluginManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MsSQLDataBaseCollector
extends MsSQLCollector {
    private static final String MSSQL_LOGIN_TIMEOUT = "mssql.login_timeout";
    private static final String MDF_FREE_SPACE_PCT2005_SQL = "MDF_FreeSpacePct2005.sql";
    private static final String MDF_FREE_SPACE_PCT2000_SQL = "MDF_FreeSpacePct2000.sql";
    private static Log log = LogFactory.getLog(MsSQLDataBaseCollector.class);

    @Override
    public void collect() {
        Properties properties = this.getProperties();
        log.debug((Object)("[collect] props:" + properties));
        super.collect();
        List<String> scriptPropertiesList = MsSQLDataBaseCollector.getScript(properties);
        try {
            ProcessBuilder process = new ProcessBuilder(scriptPropertiesList.toArray(new String[scriptPropertiesList.size()]));
            Process proc = process.start();
            StreamHandler stdout = new StreamHandler("StreamHandler-Input", proc.getInputStream(), log.isDebugEnabled()){

                protected void processString(String line) {
                    String[] lineSplit = line.split(",");
                    if (lineSplit.length == 4) {
                        String db = lineSplit[0].trim();
                        String val = lineSplit[3].trim();
                        log.debug((Object)("Database:'" + db + "' Value='" + val + "'"));
                        MsSQLDataBaseCollector.this.setValue(db, val);
                    } else {
                        log.debug((Object)("Unknown formatting from script output:" + line));
                    }
                }
            };
            StreamHandler stderr = new StreamHandler("StreamHandler-Error", proc.getErrorStream(), log.isDebugEnabled());
            stdout.start();
            stderr.start();
            proc.waitFor();
            if (!((String)stderr.getResult()).equals("")) {
                log.debug((Object)("Unable to exec process: " + stderr.getResult()));
            }
            if (stdout.hasError()) {
                log.debug((Object)("Error processing metric script output:" + stdout.getErrorString()));
            }
        }
        catch (IOException e) {
            log.debug((Object)"Unable to exec process:", (Throwable)e);
        }
        catch (InterruptedException e) {
            log.debug((Object)"Unable to exec process:", (Throwable)e);
        }
    }

    @Override
    public MetricValue getValue(Metric metric, CollectorResult result) {
        log.debug((Object)("==> " + metric));
        if (metric.getDomainName().equalsIgnoreCase("dfp")) {
            return result.getMetricValue(metric.getAttributeName());
        }
        return super.getValue(metric, result);
    }

    private static List<String> getScript(Properties props) {
        File sqlScript;
        ArrayList<String> scriptPropertiesList = new ArrayList<String>();
        String serverName = MsSQLDataBaseCollector.getServerName(props);
        String instance = props.getProperty("instance");
        if (instance != null && !instance.equals("MSSQLSERVER")) {
            serverName = serverName + "\\" + instance;
        }
        String username = props.getProperty("User");
        String password = props.getProperty("Password");
        File pdkWorkDir = new File(ProductPluginManager.getPdkWorkDir());
        if ("2005".equals(props.getProperty("v"))) {
            scriptPropertiesList.add("sqlcmd");
            sqlScript = new File(pdkWorkDir, "/scripts/mssql/MDF_FreeSpacePct2005.sql");
        } else {
            scriptPropertiesList.add("osql");
            scriptPropertiesList.add("-n");
            sqlScript = new File(pdkWorkDir, "/scripts/mssql/MDF_FreeSpacePct2000.sql");
        }
        scriptPropertiesList.add("-S");
        scriptPropertiesList.add(serverName);
        scriptPropertiesList.add("-s");
        scriptPropertiesList.add(",");
        scriptPropertiesList.add("-i");
        try {
            scriptPropertiesList.add(sqlScript.getCanonicalPath());
        }
        catch (IOException ex) {
            scriptPropertiesList.add(sqlScript.getAbsolutePath());
        }
        scriptPropertiesList.add("-l");
        scriptPropertiesList.add(System.getProperty(MSSQL_LOGIN_TIMEOUT, "3"));
        scriptPropertiesList.add("-h-1");
        scriptPropertiesList.add("-w");
        scriptPropertiesList.add("300");
        if (log.isDebugEnabled()) {
            log.debug((Object)("Script Properties = " + scriptPropertiesList));
        }
        if (username != null && !"%user%".equals(username) && password != null && !"%password%".equals(password)) {
            log.debug((Object)("Adding username to script properties: -U " + username));
            scriptPropertiesList.add("-U");
            scriptPropertiesList.add(username);
            log.debug((Object)"Adding password to script properties: -P *******");
            scriptPropertiesList.add("-P");
            scriptPropertiesList.add(password);
        } else {
            log.debug((Object)"Setting as trusted connection on script properties: -E");
            scriptPropertiesList.add("-E");
        }
        return scriptPropertiesList;
    }

    private static String getServerName(Properties props) {
        String serverName = props.getProperty("ServerName");
        log.debug((Object)("ServerName from config=" + serverName));
        if (serverName == null || "".equals(serverName) || "%sqlserver_name%".equals(serverName)) {
            serverName = "localhost";
            log.debug((Object)("Setting serverName to default=" + serverName));
        }
        return serverName;
    }

    private class StreamHandler
    extends Thread {
        private InputStream inputStream;
        private boolean verbose;
        private StringBuilder stringBuilder;
        private boolean hasError;
        private String errorString;

        public StreamHandler(String threadName, InputStream inputStream, boolean verbose) {
            super(threadName);
            this.stringBuilder = new StringBuilder();
            this.hasError = false;
            this.errorString = null;
            this.inputStream = inputStream;
            this.verbose = verbose;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            BufferedReader br = null;
            try {
                br = new BufferedReader(new InputStreamReader(this.inputStream));
                String line = br.readLine();
                while (line != null) {
                    if (this.verbose) {
                        log.debug((Object)line);
                    }
                    this.processString(line);
                    line = br.readLine();
                }
            }
            catch (IOException e) {
                log.debug((Object)"Exception reading stream: ", (Throwable)e);
                this.errorString = e.getMessage();
                this.hasError = true;
            }
            finally {
                if (br != null) {
                    try {
                        br.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }

        protected void processString(String line) {
            this.stringBuilder.append(line).append("\n");
        }

        public String getErrorString() {
            return this.errorString;
        }

        public boolean hasError() {
            return this.hasError;
        }

        public Object getResult() {
            return this.stringBuilder.toString();
        }
    }
}

