/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.util;

import java.io.File;
import java.io.FilenameFilter;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.jar.Attributes;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.util.PluginLoaderException;
import org.hyperic.util.StringUtil;

public class PluginLoader
extends URLClassLoader {
    private static Log _log = LogFactory.getLog((String)PluginLoader.class.getName());
    private static final boolean ESCAPE_SPACES = !"false".equals(System.getProperty("PluginLoader.ESCAPE_SPACES"));
    private Map addedURLs = new HashMap();
    private String pluginClassName = null;
    private String pluginName;
    private ThreadLocal<ClassLoader> previousClassLoader = new ThreadLocal();

    private static String toFileURL(String file) {
        if (ESCAPE_SPACES) {
            file = StringUtil.replace(file, " ", "%20");
        }
        return "file:" + file;
    }

    private static URL toJarURL(String file) throws MalformedURLException {
        return new URL("jar", "", PluginLoader.toFileURL(file) + "!/");
    }

    private static URL toURL(String file) throws MalformedURLException {
        return new URL(PluginLoader.toFileURL(file));
    }

    public static String getPluginMainClass(URL url) throws Exception {
        JarURLConnection jarConn = (JarURLConnection)url.openConnection();
        Attributes attrs = jarConn.getMainAttributes();
        String pluginName = attrs.getValue(Attributes.Name.MAIN_CLASS);
        return pluginName;
    }

    public static PluginLoader create(String pluginName, ClassLoader parent) throws PluginLoaderException {
        URL[] classpath;
        String pluginClassName = null;
        if (pluginName.endsWith(".jar")) {
            ArrayList<URL> urls = new ArrayList<URL>();
            try {
                URL jarUrl = PluginLoader.toJarURL(pluginName);
                urls.add(jarUrl);
                pluginClassName = PluginLoader.getPluginMainClass(jarUrl);
            }
            catch (Exception e) {
                String msg = "failed to configure plugin jar=" + pluginName;
                throw new PluginLoaderException(msg, e);
            }
            classpath = urls.toArray(new URL[0]);
        } else {
            classpath = new URL[]{};
        }
        PluginLoader loader = new PluginLoader(classpath, parent, pluginClassName);
        loader.pluginName = new File(pluginName).getName();
        return loader;
    }

    public static ClassLoader getClassLoader() {
        return Thread.currentThread().getContextClassLoader();
    }

    public static void resetClassLoader(Object obj) {
        ClassLoader cl = obj.getClass().getClassLoader();
        if (cl instanceof PluginLoader) {
            PluginLoader pl = (PluginLoader)cl;
            PluginLoader.setClassLoader(pl.previousClassLoader.get());
            pl.previousClassLoader.set(null);
        }
    }

    public static boolean setClassLoader(Object obj) {
        ClassLoader current = PluginLoader.getClassLoader();
        ClassLoader cl = obj.getClass().getClassLoader();
        if (cl == current || !(cl instanceof PluginLoader)) {
            return false;
        }
        PluginLoader pl = (PluginLoader)cl;
        pl.previousClassLoader.set(current);
        PluginLoader.setClassLoader(pl);
        return true;
    }

    public static void setClassLoader(ClassLoader loader) {
        Thread.currentThread().setContextClassLoader(loader);
    }

    public Class loadPlugin() throws ClassNotFoundException, PluginLoaderException {
        if (this.pluginClassName == null) {
            String msg = "No Main-Class attribute found in MANIFEST";
            throw new PluginLoaderException(msg);
        }
        return this.loadClass(this.pluginClassName);
    }

    public Class loadPlugin(String name, byte[] bytecode, int len) {
        return this.defineClass(name, bytecode, 0, len);
    }

    public void addURL(String url) throws PluginLoaderException {
        this.addURL(new File(url));
    }

    private void logAddPath(File path, boolean isExpand) {
        if (_log.isDebugEnabled()) {
            if (isExpand) {
                String url = path.toString();
                if (this.addedURLs.get(url) == Boolean.TRUE) {
                    return;
                }
                _log.debug((Object)(this.pluginName + " expanding " + path + "..."));
                this.addedURLs.put(url, Boolean.TRUE);
            } else if (path.canRead()) {
                _log.debug((Object)(this.pluginName + " += " + path));
            } else {
                _log.debug((Object)(this.pluginName + " -= " + path + ": Permission denied"));
            }
        }
    }

    public static String[] expand(File file) {
        String name = file.getName();
        int ix = name.indexOf("*");
        if (ix == -1) {
            return null;
        }
        File dir = file.getParentFile();
        if (!dir.isDirectory()) {
            return null;
        }
        String start = name.substring(0, ix);
        String end = name.substring(ix + 1);
        return dir.list(new ClassPathFilter(start, end));
    }

    public void addURL(File file) throws PluginLoaderException {
        boolean isExpand = false;
        String[] jars = null;
        if (!file.exists()) {
            jars = PluginLoader.expand(file);
            if (jars == null) {
                return;
            }
            isExpand = true;
            this.logAddPath(file, true);
            file = file.getParentFile();
        }
        if (isExpand || file.isDirectory()) {
            if (!isExpand) {
                boolean addedDir = this.addedURLs.get(file) == Boolean.TRUE;
                this.logAddPath(file, true);
                if (!addedDir) {
                    this.addedURLs.put(file, Boolean.TRUE);
                    try {
                        super.addURL(PluginLoader.toURL(file.toString() + "/"));
                    }
                    catch (Exception e) {
                        throw new PluginLoaderException(e.getMessage());
                    }
                }
                jars = file.list();
            }
            if (jars == null) {
                return;
            }
            for (int j = 0; j < jars.length; ++j) {
                this.addURL(new File(file, jars[j]));
            }
            return;
        }
        if (!file.exists()) {
            return;
        }
        String url = file.toString();
        if (this.addedURLs.get(url) == Boolean.TRUE) {
            return;
        }
        this.addedURLs.put(url, Boolean.TRUE);
        try {
            this.logAddPath(file, false);
            this.addURL(PluginLoader.toURL(url));
        }
        catch (Exception e) {
            throw new PluginLoaderException(e.getMessage());
        }
    }

    public void addURLs(String[] urls) throws PluginLoaderException {
        for (int i = 0; i < urls.length; ++i) {
            this.addURL(urls[i]);
        }
    }

    public void addURLs(List urls) throws PluginLoaderException {
        for (int i = 0; i < urls.size(); ++i) {
            this.addURL((String)urls.get(i));
        }
    }

    private PluginLoader(URL[] urls, ClassLoader parent, String name) {
        super(urls, parent);
        this.pluginClassName = name;
        this.previousClassLoader.set(PluginLoader.getClassLoader());
    }

    public String toString() {
        URL[] urls = this.getURLs();
        String s = super.toString() + "/" + this.pluginName + "=[";
        for (int i = 0; i < urls.length; ++i) {
            s = s + urls[i].getFile();
            if (i >= urls.length - 1) continue;
            s = s + ", ";
        }
        s = s + "]";
        return s;
    }

    protected String findLibrary(String libname) {
        String lib = System.getProperty("net.covalent.lib." + libname);
        if (lib != null) {
            return lib;
        }
        return super.findLibrary(libname);
    }

    private static class ClassPathFilter
    implements FilenameFilter {
        private String start;
        private String end;

        private ClassPathFilter(String start, String end) {
            this.start = start;
            this.end = end;
        }

        public boolean accept(File file, String name) {
            return name.startsWith(this.start) && name.endsWith(this.end);
        }
    }
}

