/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.util.config;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.hyperic.util.GenericValueMap;
import org.hyperic.util.StringUtil;
import org.hyperic.util.config.ConfigOption;
import org.hyperic.util.config.ConfigSchema;
import org.hyperic.util.config.EncodingException;
import org.hyperic.util.config.InvalidOptionException;
import org.hyperic.util.config.InvalidOptionValueException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigResponse
implements GenericValueMap,
Serializable {
    public static final String CONCEALED_SECRET_VALUE = "#CONCEALED_SECRET_VALUE#";
    Map attributes;
    private Map schemaOptionsMap;
    private ConfigSchema schema = null;
    public static final byte[] EMPTY_CONFIG;

    public ConfigResponse(ConfigSchema schema) {
        this.attributes = new HashMap();
        this.schema = schema;
        this.setSchema(schema);
    }

    public ConfigResponse() {
        this.attributes = new HashMap();
        this.schema = null;
    }

    public ConfigResponse(Map attributes) {
        this.attributes = attributes;
        this.schema = null;
    }

    public final void setSchema(ConfigSchema configSchema) {
        if (configSchema != null) {
            this.schema = configSchema;
            this.schemaOptionsMap = new HashMap();
            List<ConfigOption> options = this.schema.getOptions();
            ConfigOption opt = null;
            String sOptionKey = null;
            for (int i = 0; i < options.size(); ++i) {
                opt = options.get(i);
                sOptionKey = opt.getName();
                this.schemaOptionsMap.put(sOptionKey, opt);
                String def = opt.getDefault();
                if (def == null || this.attributes.containsKey(sOptionKey)) continue;
                this.attributes.put(sOptionKey, def);
            }
        }
    }

    public void setValue(String key, boolean value) {
        this.setValue(key, String.valueOf(value));
    }

    public void setValue(String key, int value) {
        this.setValue(key, String.valueOf(value));
    }

    public void setValue(String key, long value) {
        this.setValue(key, String.valueOf(value));
    }

    @Override
    public void setValue(String key, String value) throws InvalidOptionException, InvalidOptionValueException {
        if (this.schema != null) {
            ConfigOption option = (ConfigOption)this.schemaOptionsMap.get(key);
            if (option == null) {
                throw new InvalidOptionException(key);
            }
            option.checkOptionIsValid(value);
        }
        this.attributes.put(key, value);
    }

    public void unsetValue(String key) throws InvalidOptionException, InvalidOptionValueException {
        ConfigOption option;
        if (this.schema != null && (option = (ConfigOption)this.schemaOptionsMap.get(key)) == null) {
            throw new InvalidOptionException(key);
        }
        this.attributes.remove(key);
    }

    @Override
    public String getValue(String key) {
        return this.getValue(key, false);
    }

    public String getValue(String key, boolean concealSecretValues) {
        if (concealSecretValues && ConfigSchema.isSecret(key)) {
            return CONCEALED_SECRET_VALUE;
        }
        return (String)this.attributes.get(key);
    }

    public String getValue(String key, String defaultValue) {
        String val = (String)this.attributes.get(key);
        return val != null ? val : defaultValue;
    }

    @Override
    public Set<String> getKeys() {
        return this.attributes.keySet();
    }

    public static ConfigResponse decode(byte[] data) throws EncodingException {
        try {
            return ConfigResponse.decode(null, data);
        }
        catch (InvalidOptionException ioe) {
            throw new EncodingException(ioe);
        }
        catch (InvalidOptionValueException iove) {
            throw new EncodingException(iove);
        }
    }

    public static ConfigResponse decode(ConfigSchema schema, byte[] data) throws EncodingException, InvalidOptionException, InvalidOptionValueException {
        try {
            String key;
            ByteArrayInputStream byteStream = new ByteArrayInputStream(data);
            ObjectInputStream objectStream = new ObjectInputStream(byteStream);
            ConfigResponse res = new ConfigResponse(schema);
            while ((key = (String)objectStream.readObject()) != null) {
                String val = (String)objectStream.readObject();
                res.setValue(key, val);
            }
            return res;
        }
        catch (IOException exc) {
            throw new EncodingException(exc.toString(), exc);
        }
        catch (ClassNotFoundException exc) {
            throw new EncodingException(exc.toString(), exc);
        }
    }

    public static byte[] safeEncode(ConfigResponse cr) throws EncodingException {
        if (cr == null) {
            return null;
        }
        return cr.encode();
    }

    public byte[] encode() throws EncodingException {
        ObjectOutputStream objectStream = null;
        byte[] retVal = null;
        try {
            ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
            objectStream = new ObjectOutputStream(byteStream);
            Set keys = this.attributes.keySet();
            for (String key : keys) {
                objectStream.writeObject(key);
                objectStream.writeObject((String)this.attributes.get(key));
            }
            objectStream.writeObject(null);
            objectStream.flush();
            retVal = byteStream.toByteArray();
        }
        catch (IOException exc) {
            throw new EncodingException(exc.toString(), exc);
        }
        finally {
            if (objectStream != null) {
                try {
                    objectStream.close();
                }
                catch (Exception ex) {}
            }
        }
        return retVal;
    }

    public void merge(ConfigResponse other, boolean overWrite) {
        Set entrySet = other.attributes.entrySet();
        for (Map.Entry entry : entrySet) {
            if (!overWrite && this.attributes.get(entry.getKey()) != null) continue;
            this.attributes.put(entry.getKey(), entry.getValue());
        }
    }

    public Properties toProperties() {
        if (this.attributes instanceof Properties) {
            return (Properties)this.attributes;
        }
        Properties props = new Properties();
        Set entries = this.attributes.entrySet();
        for (Map.Entry entry : entries) {
            String value = (String)entry.getValue();
            if (value == null) continue;
            props.setProperty((String)entry.getKey(), value.trim());
        }
        return props;
    }

    public final Map getConfig() {
        return this.attributes;
    }

    public String toString() {
        StringBuffer rtn = new StringBuffer();
        for (Map.Entry entry : this.attributes.entrySet()) {
            String key = entry.getKey().toString();
            String val = null;
            if (ConfigSchema.isSecret(key)) {
                val = "******";
            } else if (entry.getValue() != null) {
                val = entry.getValue().toString();
            }
            rtn.append(key).append("=").append(val).append(",");
        }
        if (rtn.length() == 0) {
            return "";
        }
        rtn.substring(0, rtn.length() - 1);
        return rtn.toString();
    }

    public int size() {
        return this.attributes.size();
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof ConfigResponse)) {
            return false;
        }
        return ((ConfigResponse)o).toProperties().equals(this.toProperties());
    }

    public int hashCode() {
        return this.toProperties().hashCode();
    }

    public List getPreferenceAsList(String key, String delimiter) throws InvalidOptionException {
        return StringUtil.explode(this.getValue(key), delimiter);
    }

    public final boolean supportsOption(String sOptionKey) {
        return this.schemaOptionsMap != null && this.schemaOptionsMap.containsKey(sOptionKey);
    }

    static {
        try {
            EMPTY_CONFIG = new ConfigResponse().encode();
        }
        catch (EncodingException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }
}

