/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.util.config;

import java.io.Serializable;
import org.hyperic.util.HostIP;
import org.hyperic.util.config.InvalidOptionValueException;
import org.hyperic.util.config.StringConfigOption;

public class IpAddressConfigOption
extends StringConfigOption
implements Serializable {
    public static final String DEFAULT_ADDR = "*.*";

    public IpAddressConfigOption(String optName, String optDesc, String defValue) {
        super(optName, optDesc, defValue);
    }

    public void checkOptionIsValid(String value) throws InvalidOptionValueException {
        super.checkOptionIsValid(value);
        if (value.equals(DEFAULT_ADDR)) {
            return;
        }
        if (!HostIP.isValidIP(value)) {
            throw this.invalidOption("not a valid IP address");
        }
    }
}

